/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.util.Utils;

public class Moving
extends RobotModule {
    public final int MAX_WALL_DISTANCE = 22;
    public final int BLIND_STICK = 150;
    protected int direction = 1;
    protected double newHeading = 0.0;
    protected Tracking tracking;
    protected Position hideout = null;
    protected BulletTracking wave = null;
    protected Position generalPosition = null;
    protected double diveAllowance;
    protected int lastDirectionChange;

    public Moving(AdvancedRobot robot, Tracking tracking) {
        super(robot);
        this.tracking = tracking;
        this.diveAllowance = 1.3744467859455345;
        this.lastDirectionChange = 0;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.changeDirection();
    }

    @Override
    public void init() {
        this.generalPosition = new Position(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
    }

    @Override
    public void turn() {
        double maxTurn;
        Position myPos = new Position((Robot)this.robot);
        long now = this.robot.getTime();
        double speed = 0.0;
        if (this.lastDirectionChange > 0) {
            --this.lastDirectionChange;
        }
        if (this.wave != null && now > this.wave.getETA(myPos) - 1L) {
            this.wave.setEvaded();
            this.wave = null;
            this.hideout = null;
            this.newHeading = this.direction == 1 ? this.robot.getHeadingRadians() : Utils.normalAbsoluteAngle((double)(this.robot.getHeadingRadians() + Math.PI));
        }
        if (this.hideout == null) {
            if (this.generalPosition != null) {
                Log.log(4, "Following general direction");
                this.newHeading = myPos.getDirectionTo(this.generalPosition);
                speed = myPos.distance(this.generalPosition) * (double)this.direction;
            } else {
                Log.log(4, "Not going anywhere");
                speed = 20 * this.direction;
                this.newHeading = this.robot.getHeadingRadians();
                if (this.direction == -1) {
                    this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + Math.PI));
                }
            }
        } else {
            this.newHeading = myPos.getDirectionTo(this.hideout);
            speed = myPos.distance(this.hideout) * (double)this.direction;
        }
        double changeNeeded = 0.0;
        int freezeProtection = 3;
        int wallBounce = 1;
        while (freezeProtection > 0) {
            double tmp;
            --freezeProtection;
            Log.log(4, "loop start heading " + this.newHeading);
            Position blindStick = new Position(myPos);
            blindStick.modify(1L, 80.0, this.newHeading);
            boolean wallCorrected = blindStick.adjustForWalls(myPos, wallBounce, null, 0.0, this.newHeading);
            wallBounce = -1;
            this.newHeading = myPos.getDirectionTo(blindStick);
            if (wallCorrected) {
                Log.log(4, "Wall corrected heading: " + this.newHeading);
            }
            double currentHeading = this.robot.getHeadingRadians();
            if (this.direction == -1) {
                currentHeading = Utils.normalAbsoluteAngle((double)(currentHeading + Math.PI));
            }
            if (Math.abs(changeNeeded = Utils.normalRelativeAngle((double)(this.newHeading - currentHeading))) > 1.5707963267948966) {
                Log.log(4, "New heading requires direction change");
                this.changeDirection();
                continue;
            }
            if (this.tracking.getLastHitBy() == null || freezeProtection < 2) break;
            double diveProtection = AngleUtils.difference(this.newHeading, myPos.getDirectionTo(this.tracking.getLastHitBy().getLastPosition()));
            double boundary = 9.0 * this.diveAllowance / 10.0;
            if (diveProtection > 0.0 && diveProtection < boundary) {
                Log.log(4, "Positive dive protection violated: " + diveProtection);
                if (wallCorrected) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                tmp = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + this.diveAllowance - diveProtection));
                Log.paintArc(3, myPos, tmp, Utils.normalRelativeAngle((double)(this.newHeading - tmp)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (diveProtection < 0.0 && diveProtection > -boundary) {
                Log.log(4, "Positive dive protection violated: " + diveProtection);
                if (wallCorrected) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                tmp = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + this.diveAllowance + diveProtection));
                Log.paintArc(3, myPos, tmp, Utils.normalRelativeAngle((double)(this.newHeading - tmp)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (diveProtection < -(Math.PI - boundary)) {
                Log.log(4, "Negative dive protection violated: " + diveProtection);
                if (wallCorrected) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                tmp = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading - diveProtection - (Math.PI - this.diveAllowance)));
                Log.paintArc(3, myPos, tmp, Utils.normalRelativeAngle((double)(this.newHeading - tmp)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (!(diveProtection > Math.PI - boundary)) break;
            Log.log(4, "Negative dive protection violated: " + diveProtection);
            if (wallCorrected) {
                Log.log(4, "  also wall hit, changing dir");
                this.changeDirection();
                continue;
            }
            tmp = this.newHeading;
            this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading - diveProtection + (Math.PI - this.diveAllowance)));
            Log.paintArc(3, myPos, tmp, Utils.normalRelativeAngle((double)(this.newHeading - tmp)), 100.0, new Color(255, 255, 255, 60), 0);
        }
        if (changeNeeded > (maxTurn = 0.17453292519943295 - 0.006544984694978735 * Math.abs(this.robot.getVelocity()))) {
            changeNeeded = maxTurn;
        } else if (changeNeeded < -maxTurn) {
            changeNeeded = -maxTurn;
        }
        this.robot.setTurnRightRadians(changeNeeded);
        this.robot.setAhead(speed);
    }

    private void changeDirection() {
        Log.log(4, "Changing direction");
        this.direction *= -1;
        this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + 1.5707963267948966));
        this.lastDirectionChange = 25;
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (this.hideout != null) {
            Log.paintPoint(1, this.hideout, Color.YELLOW);
        }
    }

    public void bulletHitMe(BulletTracking b) {
        if (b == this.wave) {
            this.wave = null;
            this.hideout = null;
        }
    }

    public double timeToPosition(Position target) {
        Position myPos = new Position((Robot)this.robot);
        double distance = 0.0;
        double currentHeading = this.robot.getHeadingRadians();
        double currentSpeed = this.robot.getVelocity();
        double dirToTarget = myPos.getDirectionTo(target);
        boolean dirChangeNeeded = false;
        double diff = Math.abs(Utils.normalRelativeAngle((double)(currentHeading - dirToTarget)));
        if (diff > 1.5707963267948966 && currentSpeed > 0.0) {
            dirChangeNeeded = true;
        }
        if (diff < 1.5707963267948966 && currentSpeed < 0.0) {
            dirChangeNeeded = true;
        }
        double decelTime = 0.0;
        if (dirChangeNeeded) {
            decelTime = Math.abs(currentSpeed) / 2.0;
            distance += decelTime * Math.abs(currentSpeed) / 2.0;
            currentSpeed = 0.0;
        }
        double accelTime = (8.0 - Math.abs(currentSpeed)) / 1.0;
        return (long)((myPos.distance(target) + (distance -= accelTime * (8.0 - Math.abs(currentSpeed)) / 2.0)) / 8.0 + accelTime + decelTime);
    }
}

