/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import rampancy.util.RPoint;

public class RBattlefield {
    public static final int AGAINST_WALL = 0;
    public static final int NEAR_WALL = 1;
    public static final int AWAY_FROM_WALL = 2;
    public static final double AGAINST_WALL_TOLERANCE = 150.0;
    public static final double NEAR_WALL_TOLERANCE = 300.0;
    public static final int INNER_DISTANCE = 18;
    public Rectangle bfRect;
    public Rectangle innerRect;
    public int width;
    public int height;

    public RBattlefield(int width, int height) {
        this.width = width;
        this.height = height;
        this.bfRect = new Rectangle(width, height);
        this.innerRect = new Rectangle(18, 18, width - 36, height - 36);
    }

    public boolean contains(RPoint point) {
        return this.bfRect.contains(point);
    }

    public double distanceFromTop(RPoint point) {
        return Math.abs((double)this.bfRect.height - point.y);
    }

    public double distanceFromBot(RPoint point) {
        return point.y;
    }

    public double distanceFromLeft(RPoint point) {
        return point.x;
    }

    public double distanceFromRight(RPoint point) {
        return Math.abs((double)this.bfRect.width - point.x);
    }

    public double innerDistanceFromTop(RPoint point) {
        return Math.max(1.0, this.distanceFromTop(point) - 18.0);
    }

    public double innerDistanceFromBot(RPoint point) {
        return Math.max(1.0, this.distanceFromBot(point) - 18.0);
    }

    public double innerDistanceFromRight(RPoint point) {
        return Math.max(1.0, this.distanceFromRight(point) - 18.0);
    }

    public double innerDistanceFromLeft(RPoint point) {
        return Math.max(1.0, this.distanceFromLeft(point) - 18.0);
    }

    public double distanceFromWall(RPoint point) {
        if (!this.contains(point)) {
            return -1.0;
        }
        double distLeft = point.x;
        double distRight = (double)this.bfRect.width - point.x;
        double distTop = (double)this.bfRect.height - point.y;
        double distBot = point.y;
        return Math.min(Math.min(distRight, distLeft), Math.min(distTop, distBot));
    }

    public int distanceFromWallCategory(RPoint point) {
        return this.distanceFromWallCategory(this.distanceFromWall(point));
    }

    public int distanceFromWallCategory(double distance) {
        if (distance < 150.0) {
            return 0;
        }
        if (distance < 300.0) {
            return 1;
        }
        return 2;
    }

    public boolean validMovePosition(RPoint point) {
        return this.innerRect.contains(point);
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.gray);
        g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width, this.innerRect.height);
    }
}

