/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.kdTree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rampancy.util.data.kdTree.KDNearestSearch;
import rampancy.util.data.kdTree.KDNode;
import rampancy.util.data.kdTree.KDPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree<T extends KDPoint> {
    private KDNode<T> rootNode;
    private List<T> points;
    private List<Comparator<T>> comparators;
    private int numDimensions;

    public KDTree(List<Comparator<T>> comparators) {
        this(new ArrayList(), comparators);
    }

    public KDTree(List<T> points, List<Comparator<T>> comparators) {
        this(points, points.size(), comparators);
    }

    public KDTree(List<T> points, int size, List<Comparator<T>> comparators) {
        this.points = points;
        this.comparators = comparators;
        this.numDimensions = comparators.size();
        this.rootNode = this.generateInitialNodes(this.points.subList(0, size), 0);
    }

    public T getNearestNeighbor(T point) {
        List<T> nearest = this.getKNearestNeighbors(point, 1);
        if (nearest == null || nearest.isEmpty()) {
            return null;
        }
        return (T)((KDPoint)nearest.get(0));
    }

    public List<T> getKNearestNeighbors(T point, int k) {
        if (this.rootNode == null) {
            return new ArrayList();
        }
        KDNearestSearch<T> nearestSearch = new KDNearestSearch<T>(point, k);
        this.recursiveFindKNearestNeighbors(nearestSearch, this.rootNode);
        return nearestSearch.getNearestNeighbors();
    }

    public void add(T point) {
        this.points.add(point);
        if (this.rootNode == null) {
            this.rootNode = this.generateNewNode(point, 0);
        } else {
            this.recursiveAdd(point, this.rootNode);
        }
    }

    public KDNode<T> getRootNode() {
        return this.rootNode;
    }

    public int getNumberOfDimensions() {
        return this.numDimensions;
    }

    public List<T> getAllPoints() {
        return this.points;
    }

    private void recursiveFindKNearestNeighbors(KDNearestSearch<T> search, KDNode<T> node) {
        if (node.isLeaf()) {
            search.attemptToAdd(node.median);
        } else {
            boolean canMoveLeft = node.left != null;
            boolean canMoveRight = node.right != null;
            boolean targetToTheLeft = this.isToTheLeftOf(search.target, node.median, node.axis);
            boolean wentLeft = false;
            boolean wentRight = false;
            if (canMoveLeft && (!canMoveRight || targetToTheLeft)) {
                this.recursiveFindKNearestNeighbors(search, node.left);
                wentLeft = true;
            } else if (!(!canMoveRight || canMoveLeft && targetToTheLeft)) {
                this.recursiveFindKNearestNeighbors(search, node.right);
                wentRight = true;
            }
            if (search.attemptToAdd(node.median)) {
                KDNearestSearch newSearch = new KDNearestSearch(search.target, search.k);
                if (wentLeft && canMoveRight) {
                    this.recursiveFindKNearestNeighbors(newSearch, node.right);
                } else if (wentRight && canMoveLeft) {
                    this.recursiveFindKNearestNeighbors(newSearch, node.left);
                }
                if (!newSearch.nearestNeighbors.isEmpty()) {
                    search.nearestNeighbors.addAll(newSearch.nearestNeighbors);
                }
            }
        }
    }

    private void recursiveAdd(T point, KDNode<T> node) {
        if (this.isToTheLeftOf(point, node.median, node.axis)) {
            if (node.left == null) {
                node.left = this.generateNewNode(point, node.depth + 1);
            } else {
                this.recursiveAdd(point, node.left);
            }
        } else if (node.right == null) {
            node.right = this.generateNewNode(point, node.depth + 1);
        } else {
            this.recursiveAdd(point, node.right);
        }
    }

    private boolean isToTheLeftOf(T point, T median, int axis) {
        return this.comparators.get(axis).compare(point, median) < 0;
    }

    private KDNode<T> generateNewNode(T point, int depth) {
        KDNode node = new KDNode();
        node.axis = depth % this.numDimensions;
        node.depth = depth;
        node.median = point;
        return node;
    }

    private KDNode<T> generateInitialNodes(List<T> points, int depth) {
        if (points.isEmpty()) {
            return null;
        }
        int axis = depth % this.numDimensions;
        Collections.sort(points, this.comparators.get(axis));
        int medianIndex = points.size() / 2;
        KDPoint median = (KDPoint)points.get(medianIndex);
        KDNode node = new KDNode();
        node.axis = axis;
        node.depth = depth;
        node.median = median;
        List<T> left = points.subList(0, medianIndex);
        List<T> right = points.subList(medianIndex + 1, points.size());
        node.left = this.generateInitialNodes(left, depth + 1);
        node.right = this.generateInitialNodes(right, depth + 1);
        return node;
    }
}

