/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun.crowd;

import ags.muse.gun.IStatTracker;
import ags.muse.gun.SWave;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import ags.util.BinUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class CrowdLearner
implements IStatTracker {
    private final IStatTracker[] children;
    private final double[] values;
    private final double[] m;
    private final int bins;
    private final WeakHashMap<SWave, double[][]> rawchilddata = new WeakHashMap();
    private final WeakHashMap<SWave, double[][]> normalchilddata = new WeakHashMap();
    private final LinkedList<SWave> recentWaves = new LinkedList();
    private int ahits = 0;
    private long waveEnds = 0L;

    public CrowdLearner(int bins, IStatTracker ... children) {
        this.children = Arrays.copyOf(children, children.length);
        this.values = new double[children.length];
        this.m = new double[children.length];
        this.bins = bins;
    }

    public void setValues(double ... v) {
        if (v.length != this.children.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(v, 0, this.values, 0, this.values.length);
    }

    public double[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    private double[] sumBuffers(double[][] childbins, boolean ignoreSmall) {
        if (childbins.length != this.children.length) {
            throw new IllegalArgumentException();
        }
        double[] sum = new double[this.bins];
        int x = 0;
        while (x < childbins.length) {
            if (this.bins != childbins[x].length) {
                throw new IllegalArgumentException();
            }
            if (ignoreSmall && Math.abs(this.values[x]) < 0.5) break;
            int i = 0;
            while (i < this.bins) {
                int n = i;
                sum[n] = sum[n] + childbins[x][i] * this.values[x];
                ++i;
            }
            ++x;
        }
        return sum;
    }

    private static void normalizeAvgBuffer(double[] b) {
        double total = 0.0;
        double low = b[0];
        double[] dArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            total += v;
            if (v < low) {
                low = v;
            }
            ++n2;
        }
        double avg = total / (double)b.length - low;
        if (avg == 0.0) {
            return;
        }
        int x = 0;
        while (x < b.length) {
            b[x] = (b[x] - low) / avg;
            ++x;
        }
    }

    @Override
    public double[] getBins(SWave wave) {
        double[][] rawchildbins = new double[this.children.length][];
        double[][] normalchildbins = new double[this.children.length][];
        int i = 0;
        while (i < this.children.length) {
            rawchildbins[i] = this.children[i].getBins(wave);
            normalchildbins[i] = Arrays.copyOf(rawchildbins[i], this.bins);
            CrowdLearner.normalizeAvgBuffer(normalchildbins[i]);
            ++i;
        }
        this.rawchilddata.put(wave, rawchildbins);
        this.normalchilddata.put(wave, normalchildbins);
        return this.sumBuffers(rawchildbins, true);
    }

    @Override
    public void waveEnded(SWave wave) {
        IStatTracker[] iStatTrackerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatTracker t = iStatTrackerArray[n2];
            t.waveEnded(wave);
            ++n2;
        }
        if (wave.getBullet() != null) {
            ++this.waveEnds;
            this.recentWaves.addLast(wave);
            if (this.recentWaves.size() > 20) {
                this.recentWaves.removeFirst();
            }
        }
        if (wave.getBullet() != null && this.waveEnds >= 50L) {
            this.adaptToOutcome();
        }
    }

    public double[] getAdjustments(SWave wave) {
        double[][] rawchildbins = this.rawchilddata.get(wave);
        double[][] normalchildbins = this.normalchilddata.get(wave);
        if (rawchildbins == null || normalchildbins == null || wave.getHitRange() == null) {
            return null;
        }
        double[] sum = this.sumBuffers(rawchildbins, false);
        CrowdLearner.normalizeAvgBuffer(sum);
        double[] goal = BinUtils.makeRectBins(this.bins, wave.getHitRange());
        CrowdLearner.normalizeAvgBuffer(goal);
        double[] diff = new double[this.bins];
        int x = 0;
        while (x < this.bins) {
            diff[x] = goal[x] - sum[x];
            ++x;
        }
        double[] adjustments = new double[this.children.length];
        int i = 0;
        while (i < this.children.length) {
            double total = 0.0;
            double low = rawchildbins[i][0];
            int x2 = 0;
            while (x2 < this.bins) {
                int n = i;
                adjustments[n] = adjustments[n] + (normalchildbins[i][x2] - sum[x2]) * diff[x2];
                total += rawchildbins[i][x2];
                if (rawchildbins[i][x2] < low) {
                    low = rawchildbins[i][x2];
                }
                ++x2;
            }
            int n = i;
            adjustments[n] = adjustments[n] * (total / (double)this.bins - low);
            int n2 = i++;
            adjustments[n2] = adjustments[n2] / (double)this.bins;
        }
        return adjustments;
    }

    public void adaptToOutcome() {
        double[] adjustments = new double[this.children.length];
        for (SWave w : this.recentWaves) {
            double[] adj = this.getAdjustments(w);
            if (adj == null) continue;
            int i = 0;
            while (i < this.children.length) {
                int n = i;
                adjustments[n] = adjustments[n] + adj[i];
                ++i;
            }
        }
        double totala = 0.0;
        int i = 0;
        while (i < this.children.length) {
            totala += Math.abs(adjustments[i]);
            ++i;
        }
        i = 0;
        while (i < this.children.length) {
            adjustments[i] = adjustments[i] * (double)this.children.length / totala;
            ++i;
        }
        i = 0;
        while (i < this.children.length) {
            double sgn = Math.signum(adjustments[i]);
            if (sgn == Math.signum(this.m[i])) {
                int n = i;
                this.m[n] = this.m[n] + 2.5E-4 * sgn;
            } else {
                int n = i;
                this.m[n] = this.m[n] / 8.0;
                int n2 = i;
                this.m[n2] = this.m[n2] + 0.001 * sgn;
            }
            int n = i;
            this.values[n] = this.values[n] + Math.abs(adjustments[i]) * this.m[i];
            ++i;
        }
        double total = 0.0;
        int i2 = 0;
        while (i2 < this.children.length) {
            total += Math.abs(this.values[i2]);
            ++i2;
        }
        if (total != 0.0) {
            i2 = 0;
            while (i2 < this.children.length) {
                int n = i2++;
                this.values[n] = this.values[n] / (total / 10.0);
            }
        }
    }

    @Override
    public void waveStarted(SelfStatus status, EnemyList enemyList, SWave wave) {
        IStatTracker[] iStatTrackerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatTracker t = iStatTrackerArray[n2];
            t.waveStarted(status, enemyList, wave);
            ++n2;
        }
    }

    @Override
    public void bulletHit(SWave wave) {
        IStatTracker[] iStatTrackerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatTracker t = iStatTrackerArray[n2];
            t.bulletHit(wave);
            ++n2;
        }
        if (wave.getHitRange() != null && !wave.getHitRange().intersects(wave.getAimGF())) {
            System.out.println("Shouldn't have hit! " + wave.getAimGF() + " not within " + wave.getHitRange());
        }
        ++this.ahits;
    }

    @Override
    public void bulletHitBullet(SWave wave) {
        IStatTracker[] iStatTrackerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatTracker t = iStatTrackerArray[n2];
            t.bulletHitBullet(wave);
            ++n2;
        }
    }
}

