/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.awt.geom.Point2D;

class Vec2d
extends Point2D.Double {
    public Vec2d() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d(Vec2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public static Vec2d fromHeadingRadians(double radians) {
        return new Vec2d(Math.sin(radians), Math.cos(radians));
    }

    public static Vec2d fromHeading(double degrees) {
        return Vec2d.fromHeadingRadians(Math.toRadians(degrees));
    }

    public static Vec2d polarRadians(double radians, double radius) {
        return new Vec2d(radius * Math.sin(radians), radius * Math.cos(radians));
    }

    public static Vec2d polar(double degrees, double radius) {
        return Vec2d.polarRadians(Math.toRadians(degrees), radius);
    }

    public void set(Vec2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double dist(Vec2d v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double dist(double x, double y) {
        double dx = x - this.x;
        double dy = y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Vec2d unit() {
        double len = this.mag();
        return new Vec2d(this.x / len, this.y / len);
    }

    public double dot(Vec2d v) {
        return this.x * v.x + this.y * v.y;
    }

    public double getHeadingRadians() {
        return Math.atan2(this.x, this.y);
    }

    public double getHeading() {
        return Math.toDegrees(this.getHeadingRadians());
    }

    public Vec2d plus(Vec2d in) {
        return new Vec2d(this.x + in.x, this.y + in.y);
    }

    public Vec2d plus(double x, double y) {
        return new Vec2d(this.x + x, this.y + y);
    }

    public Vec2d minus(Vec2d in) {
        return new Vec2d(this.x - in.x, this.y - in.y);
    }

    public Vec2d minus(double x, double y) {
        return new Vec2d(this.x - x, this.y - y);
    }

    public Vec2d negate() {
        return new Vec2d(-this.x, -this.y);
    }

    public Vec2d mult(double s) {
        return new Vec2d(this.x * s, this.y * s);
    }

    public Vec2d scale(double sx, double sy) {
        return new Vec2d(this.x * sx, this.y * sy);
    }
}

