/*
 * Decompiled with CFR 0.152.
 */
package amk.util;

import java.awt.geom.Point2D;

public final class Utils {
    public static final double BOT_ROT_VEL = Math.toRadians(10.0);
    public static final double GUN_ROT_VEL = Math.toRadians(20.0);
    public static final double THREE_QUARTERS = 4.71238898038469;
    public static final double ONE_QUARTER = 1.5707963267948966;
    public static final double CLOSE_ANGLE = 0.19634954084936207;
    public static final double FOUR_QUARTERS = Math.PI * 2;

    public static double normalizeAngleRadians(double angle) {
        return angle % (Math.PI * 2);
    }

    public static double bestAngle(double angle) {
        double newAngle = angle;
        if (angle > Math.PI) {
            newAngle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            newAngle += Math.PI * 2;
        }
        return newAngle;
    }

    public static double smallestToParallel(double angle) {
        double fixedAngle;
        if (angle > -90.0 && angle <= 90.0) {
            return angle;
        }
        for (fixedAngle = angle; fixedAngle <= -90.0; fixedAngle += 180.0) {
        }
        while (fixedAngle > 90.0) {
            fixedAngle -= 180.0;
        }
        return fixedAngle;
    }

    public static double getUnitCircleAngle(double angle) {
        return -(angle + 4.71238898038469);
    }

    public static double getHeadingPoints(double originX, double originY, double targetX, double targetY) {
        return (Math.atan2(targetX - originX, targetY - originY) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double getRelativeBearing(double itemHeading, double originX, double originY, double targetX, double targetY) {
        double a = (Math.atan2(targetX - originX, targetY - originY) + Math.PI * 2) % (Math.PI * 2) - itemHeading;
        if (Math.abs(a) > Math.PI) {
            a += a < 0.0 ? Math.PI * 2 : Math.PI * -2;
        }
        return a;
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}

