/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.shield;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.cat.group.shield.BulletShieldingController;
import xander.cat.group.shield.BulletShieldingListener;
import xander.cat.group.shield.BulletTargeter;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.gun.AbstractGun;
import xander.core.gun.Aim;
import xander.core.math.Linear;
import xander.core.math.LinearIntercept;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;

public class BulletShieldingGun
extends AbstractGun
implements MyWaveListener,
OpponentWaveListener,
BulletShieldingListener {
    public static final String NAME = "Bullet Shielding Gun";
    private BulletTargeter[] bulletTargeters;
    private int[] bulletTargeterMatches;
    private Map<Wave, double[]> waveAims = new HashMap<Wave, double[]>();
    private Map<Wave, Integer> selectedAims = new HashMap<Wave, Integer>();
    private RobotProxy robotProxy;
    private BulletShieldingController controller;
    private Wave targetedWave;
    private Snapshot targetedSnapshot;
    private double maxFirePower = 0.1;
    private int firePowerAdjustedCount;
    private int totalCount;
    private int lastMissIdx = -1;
    private boolean allowFinishingShot;

    public BulletShieldingGun(BulletShieldingController controller, BulletTargeter ... bulletTargeters) {
        if (bulletTargeters == null) {
            throw new IllegalArgumentException("There must be at least 1 bullet targeter provided.");
        }
        this.controller = controller;
        controller.addBulletShieldingListener(this);
        this.bulletTargeters = bulletTargeters;
        this.bulletTargeterMatches = new int[bulletTargeters.length];
        this.robotProxy = Resources.getRobotProxy();
        Resources.getWaveHistory().addMyWaveListener(this);
        Resources.getWaveHistory().addOpponentWaveListener(this);
    }

    public BulletShieldingGun(BulletShieldingController controller, double maxAdjustedFirePower, BulletTargeter ... bulletTargeters) {
        this(controller, bulletTargeters);
        this.maxFirePower = maxAdjustedFirePower;
    }

    public void setAllowFinishingShot(boolean allowFinishingShot) {
        this.allowFinishingShot = allowFinishingShot;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onRoundBegin() {
        super.onRoundBegin();
        this.waveAims.clear();
        this.selectedAims.clear();
        this.reset();
    }

    public double getFirePowerAdjustedRatio() {
        return this.firePowerAdjustedCount == 0 ? 0.0 : (double)this.firePowerAdjustedCount / (double)this.totalCount;
    }

    public void reset() {
        this.targetedSnapshot = null;
        this.targetedWave = null;
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        if (this.targetedWave == null) {
            Snapshot los;
            this.targetedWave = this.controller.requestWaveToShieldAgainst();
            if (this.targetedWave != null) {
                double[] aims;
                int targeterIdx = 0;
                int mostMatches = this.bulletTargeterMatches[0];
                boolean tie = false;
                int i = 1;
                while (i < this.bulletTargeters.length) {
                    if (this.bulletTargeterMatches[i] > mostMatches) {
                        tie = false;
                        targeterIdx = i;
                        mostMatches = this.bulletTargeterMatches[i];
                    } else if (this.bulletTargeterMatches[i] == mostMatches) {
                        tie = true;
                    }
                    ++i;
                }
                if (tie && this.lastMissIdx == targeterIdx) {
                    i = this.bulletTargeters.length - 1;
                    while (i >= 0) {
                        if (i != this.lastMissIdx && this.bulletTargeterMatches[i] == mostMatches) {
                            targeterIdx = i;
                        }
                        --i;
                    }
                }
                if ((aims = this.waveAims.get(this.targetedWave)) == null) {
                    aims = new double[this.bulletTargeters.length];
                    int i2 = 0;
                    while (i2 < this.bulletTargeters.length) {
                        aims[i2] = this.bulletTargeters[i2].getAim(this.targetedWave);
                        ++i2;
                    }
                    this.waveAims.put(this.targetedWave, aims);
                }
                this.selectedAims.put(this.targetedWave, targeterIdx);
                this.targetedSnapshot = new Snapshot("Opponent Bullet", this.targetedWave.getOriginX(), this.targetedWave.getOriginY(), aims[targeterIdx], this.targetedWave.getBulletVelocity(), this.targetedWave.getInitialDefenderSnapshot().getDistance(), 100.0, this.targetedWave.getOriginTime() - 1L);
            } else if (this.allowFinishingShot && (los = Resources.getSnapshotHistory().getLastOpponentScanned()) != null && los.getEnergy() <= 0.0 && Resources.getWaveHistory().getOpponentWaveCount() == 0) {
                double aimHeading = RCMath.getRobocodeAngle(this.robotProxy.getX(), this.robotProxy.getY(), los.getX(), los.getY());
                return new Aim(aimHeading, 0.1);
            }
        }
        if (this.targetedSnapshot != null && this.controller.requestAuthorizationToFire()) {
            LinearIntercept intercept = Linear.calculateTrajectory(this.targetedSnapshot, this.robotProxy.getX(), this.robotProxy.getY(), RCPhysics.MAX_BULLET_VELOCITY, this.robotProxy.getBattleFieldSize(), Resources.getTime());
            double firePower = 0.1;
            if (intercept != null) {
                double mfp = Math.min(this.maxFirePower, this.targetedWave.getBulletPower());
                if (mfp > firePower && this.robotProxy.getEnergy() >= target.getEnergy()) {
                    LinearIntercept improvedIntercept;
                    double improvedTimeToIntercept = Math.floor(intercept.getTimeToIntercept()) + 0.5;
                    if (improvedTimeToIntercept < intercept.getTimeToIntercept()) {
                        improvedTimeToIntercept += 1.0;
                    }
                    double totalTime = (double)(Resources.getTime() - this.targetedSnapshot.getTime()) + improvedTimeToIntercept;
                    double travelDistance = this.targetedSnapshot.getVelocity() * totalTime;
                    Point2D.Double improvedInterceptPos = RCMath.getLocation(this.targetedSnapshot.getX(), this.targetedSnapshot.getY(), travelDistance, this.targetedSnapshot.getHeadingRoboDegrees());
                    double myShieldingShotTravelDistance = RCMath.getDistanceBetweenPoints(this.robotProxy.getX(), this.robotProxy.getY(), improvedInterceptPos.x, improvedInterceptPos.y);
                    double improvedBulletSpeed = myShieldingShotTravelDistance / improvedTimeToIntercept;
                    double improvedFirePower = RCPhysics.getBulletPower(improvedBulletSpeed);
                    if (improvedFirePower <= mfp && (improvedIntercept = Linear.calculateTrajectory(this.targetedSnapshot, this.robotProxy.getX(), this.robotProxy.getY(), improvedBulletSpeed, this.robotProxy.getBattleFieldSize(), Resources.getTime())) != null) {
                        intercept = improvedIntercept;
                        firePower = improvedFirePower;
                        ++this.firePowerAdjustedCount;
                    }
                }
                ++this.totalCount;
                return new Aim(intercept.getVelocityVector().getRoboAngle(), firePower);
            }
            this.reset();
        }
        return null;
    }

    private void updateMatches(Wave wave, Bullet bullet) {
        double[] aims = this.waveAims.get(wave);
        if (aims != null) {
            double actualAim = bullet.getHeadingRadians();
            int i = 0;
            while (i < aims.length) {
                if (Math.abs(actualAim - aims[i]) < 0.003) {
                    int n = i;
                    this.bulletTargeterMatches[n] = this.bulletTargeterMatches[n] + 1;
                }
                ++i;
            }
            this.waveAims.remove(wave);
            this.selectedAims.remove(wave);
        }
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        return true;
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
        this.reset();
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
        this.updateMatches(wave, oppBullet);
    }

    @Override
    public void oppWaveHit(Wave wave) {
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
        this.updateMatches(wave, hitByBulletEvent.getBullet());
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
        this.waveAims.remove(wave);
        this.selectedAims.remove(wave);
    }

    @Override
    public void shieldingShotHit(XBulletWave myWave, Wave opponentWave) {
    }

    @Override
    public void shieldingShotMissed(XBulletWave myWave, Wave opponentWave) {
        Integer aimIdx = this.selectedAims.get(opponentWave);
        if (aimIdx != null) {
            this.lastMissIdx = aimIdx;
        }
    }
}

