/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.drive.DriveOptions;
import xander.core.drive.DriveState;
import xander.core.event.BulletHitListener;
import xander.core.event.GunFiredEvent;
import xander.core.event.GunListener;
import xander.core.event.MyVirtualWaveListener;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentGunFiredEvent;
import xander.core.event.OpponentGunListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundBeginListener;
import xander.core.event.TurnListener;
import xander.core.gun.GunController;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.track.BulletShadow;
import xander.core.track.OpponentGunWatcher;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.core.track.WaveState;
import xander.core.track.XBullet;
import xander.core.track.XBulletWave;
import xander.gfws.RelativeAngleRange;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class WaveHistory
implements RoundBeginListener,
GunListener,
OpponentGunListener,
TurnListener,
BulletHitListener,
Paintable {
    private static final Log log = Logger.getLog(WaveHistory.class);
    private List<Wave> opponentWaves = new ArrayList<Wave>();
    private List<XBulletWave> myWaves = new ArrayList<XBulletWave>();
    private List<XBulletWave> myVirtualWaves = new ArrayList<XBulletWave>();
    private List<MyWaveListener> myWaveListeners = new ArrayList<MyWaveListener>();
    private List<MyVirtualWaveListener> myVirtualWaveListeners = new ArrayList<MyVirtualWaveListener>();
    private List<OpponentWaveListener> oppWaveListeners = new ArrayList<OpponentWaveListener>();
    private Map<WaveParams, RelativeAngleRange> meaCache = new HashMap<WaveParams, RelativeAngleRange>();
    private Wave oppNextWaveToHit;
    private SnapshotHistory snapshotHistory;
    private double maxWaveSaveDistance;
    private Rectangle2D.Double battleFieldBounds;
    private DriveOptions myDriveOptions;
    private DriveOptions opponentDriveOptions;

    public WaveHistory(GunController gunController, OpponentGunWatcher opponentGunWatcher, RobotEvents robotEvents, RobotProxy robotProxy, SnapshotHistory snapshotHistory, Configuration configuration) {
        this.snapshotHistory = snapshotHistory;
        if (configuration.isUsePreciseMEAForOpponentWaves()) {
            this.myDriveOptions = new DriveOptions(30, robotProxy.getBattleFieldSize(), configuration.getMyPreciseMEADriveBounds());
        }
        if (configuration.isUsePreciseMEAForMyWaves()) {
            this.opponentDriveOptions = new DriveOptions(30, robotProxy.getBattleFieldSize(), configuration.getOpponentPreciseMEADriveBounds());
        }
        gunController.addGunListener(this);
        opponentGunWatcher.addOpponentGunListener(this);
        robotEvents.addRoundBeginListener(this);
        robotEvents.addTurnListener(this);
        robotEvents.addBulletHitListener(this);
        this.maxWaveSaveDistance = robotProxy.getBattleFieldDiagonal();
        this.battleFieldBounds = robotProxy.getBattleFieldSize();
        Paintables.addPaintable(this);
    }

    @Override
    public String getPainterName() {
        return null;
    }

    @Override
    public void onRoundBegin() {
        this.opponentWaves.clear();
        this.myWaves.clear();
        this.myVirtualWaves.clear();
    }

    public int getOpponentWaveCount() {
        return this.opponentWaves.size();
    }

    public int getOpponentActiveWaveCount() {
        int count = 0;
        for (Wave wave : this.opponentWaves) {
            if (wave.isPassed()) continue;
            ++count;
        }
        return count;
    }

    public void addMyWaveListener(MyWaveListener listener) {
        this.myWaveListeners.add(listener);
    }

    public void addMyVirtualWaveListener(MyVirtualWaveListener listener) {
        this.myVirtualWaveListeners.add(listener);
    }

    public void addOpponentWaveListener(OpponentWaveListener listener) {
        this.oppWaveListeners.add(listener);
    }

    public List<Wave> getOpponentWaves() {
        return this.opponentWaves;
    }

    public List<XBulletWave> getMyWaves() {
        return this.myWaves;
    }

    public List<XBulletWave> getMyVirtualWaves() {
        return this.myVirtualWaves;
    }

    private RelativeAngleRange getMEA(Wave wave, Snapshot defenderSnapshot, long bulletFiredTime, boolean opponentWave) {
        if (!opponentWave && this.opponentDriveOptions != null) {
            DriveState defenderDriveState = new DriveState(defenderSnapshot);
            this.opponentDriveOptions.computeDriveOptions(wave, defenderDriveState, bulletFiredTime);
            return this.opponentDriveOptions.getMEA();
        }
        if (opponentWave && this.myDriveOptions != null) {
            DriveState defenderDriveState = new DriveState(defenderSnapshot);
            this.myDriveOptions.computeDriveOptions(wave, defenderDriveState, bulletFiredTime);
            return this.myDriveOptions.getMEA();
        }
        double simpleMEA = RCMath.getMaximumEscapeAngle(wave.getBulletVelocity());
        return new RelativeAngleRange(-simpleMEA, simpleMEA, "WaveHistory.getMEA");
    }

    public Wave createWave(Snapshot defenderSnapshot, Snapshot attackerSnapshot, double bulletPower, long bulletFiredTime, boolean opponentWave, boolean estimated) {
        WaveParams wp = new WaveParams(attackerSnapshot, defenderSnapshot, bulletPower);
        Wave wave = null;
        wave = opponentWave ? new Wave(defenderSnapshot, attackerSnapshot, bulletPower, bulletFiredTime, estimated) : new XBulletWave(defenderSnapshot, attackerSnapshot, bulletPower, bulletFiredTime);
        RelativeAngleRange mea = this.meaCache.get(wp);
        if (mea == null) {
            mea = this.getMEA(wave, defenderSnapshot, bulletFiredTime, opponentWave);
            this.meaCache.put(wp, mea);
        }
        wave.initialMEA = mea;
        return wave;
    }

    public XBulletWave createXBulletWave(Snapshot defenderSnapshot, Snapshot attackerSnapshot, XBullet bullet, String gunName, long bulletFiredTime, boolean opponentWave) {
        XBulletWave wave = (XBulletWave)this.createWave(defenderSnapshot, attackerSnapshot, bullet.getPower(), bulletFiredTime, opponentWave, false);
        wave.gunName = gunName;
        wave.xbullet = bullet;
        return wave;
    }

    public Wave getOpponentWaveAfter(Wave wave, double myX, double myY) {
        long time = Resources.getTime();
        long timeToHit = wave.getTimeUntilHit(myX, myY, time);
        long closestTimeToHitAfter = Long.MAX_VALUE;
        Wave closestWaveAfter = null;
        for (Wave waveAfter : this.opponentWaves) {
            long timeToHitAfter;
            if (wave == waveAfter || !waveAfter.isLeading() || (timeToHitAfter = waveAfter.getTimeUntilHit(myX, myY, time)) < timeToHit || timeToHitAfter >= closestTimeToHitAfter) continue;
            closestTimeToHitAfter = timeToHitAfter;
            closestWaveAfter = waveAfter;
        }
        return closestWaveAfter;
    }

    private void addBulletShadow(XBulletWave myWave, Wave opponentWave, long time) {
        if (myWave.getState() == WaveState.LEADING && opponentWave.getState() == WaveState.LEADING) {
            double angle2;
            double angle1;
            double turnAngle;
            --time;
            double myBulletToOppWaveOriginDistance = 0.0;
            double oppWaveDistance = 0.0;
            Point2D.Double myBulletPosition = null;
            while ((myBulletToOppWaveOriginDistance = RCMath.getDistanceBetweenPoints(myBulletPosition = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), myWave.getBulletTravelDistance(++time), myWave.getXBullet().getAim()), opponentWave.getOrigin())) > (oppWaveDistance = opponentWave.getBulletTravelDistance(time)) && this.battleFieldBounds.contains(myBulletPosition)) {
            }
            if (!this.battleFieldBounds.contains(myBulletPosition)) {
                return;
            }
            double trailPointDistance = myWave.getBulletTravelDistance(time - 1L);
            double leadPointDistance = myWave.getBulletTravelDistance(time);
            Point2D.Double leadPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), leadPointDistance, myWave.getXBullet().getAim());
            Point2D.Double trailPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), trailPointDistance, myWave.getXBullet().getAim());
            double oppLeadPointDistance = opponentWave.getBulletTravelDistance(time);
            if (oppLeadPointDistance < RCMath.getDistanceBetweenPoints(opponentWave.getOrigin(), trailPoint)) {
                Point2D.Double[] intersections = RCMath.getCircleToLineIntersections(opponentWave.getOrigin(), oppLeadPointDistance, trailPoint, leadPoint);
                if (intersections == null) {
                    log.error("No intersections found!");
                    return;
                }
                if (intersections.length == 1) {
                    trailPoint = intersections[0];
                } else if (leadPoint.x == trailPoint.x) {
                    if (RCMath.between(intersections[0].y, leadPoint.y, trailPoint.y)) {
                        trailPoint = intersections[0];
                    } else if (RCMath.between(intersections[1].y, leadPoint.y, trailPoint.y)) {
                        trailPoint = intersections[1];
                    } else {
                        log.error("Vertical segment does not contain either of the calculated intersection points!");
                    }
                } else if (leadPoint.y == trailPoint.y) {
                    if (RCMath.between(intersections[0].x, leadPoint.x, trailPoint.x)) {
                        trailPoint = intersections[0];
                    } else if (RCMath.between(intersections[1].x, leadPoint.x, trailPoint.x)) {
                        trailPoint = intersections[1];
                    } else {
                        log.error("Horizontal segment does not contain either of the calculated intersection points!");
                    }
                } else {
                    double h;
                    double w;
                    double y;
                    double x = Math.min(leadPoint.x, trailPoint.x);
                    Rectangle2D.Double segmentBounds = new Rectangle2D.Double(x, y = Math.min(leadPoint.y, trailPoint.y), w = Math.abs(leadPoint.x - trailPoint.x), h = Math.abs(leadPoint.y - trailPoint.y));
                    if (segmentBounds.contains(intersections[0])) {
                        trailPoint = intersections[0];
                    } else if (segmentBounds.contains(intersections[1])) {
                        trailPoint = intersections[1];
                    } else {
                        log.error("Segment bounds does not contain either of the calculated intersection points!");
                    }
                }
            }
            if ((turnAngle = RCMath.getTurnAngle(angle1 = RCMath.getRobocodeAngle(opponentWave.getOrigin(), leadPoint), angle2 = RCMath.getRobocodeAngle(opponentWave.getOrigin(), trailPoint))) < 0.0) {
                opponentWave.addBulletShadow(new BulletShadow(angle2, angle1));
            } else {
                opponentWave.addBulletShadow(new BulletShadow(angle1, angle2));
            }
        }
    }

    @Override
    public void gunFired(GunFiredEvent event) {
        long adjustedFireTime = Resources.getTime();
        XBullet xbullet = new XBullet(event.getMySnapshot().getLocation(), event.getAim(), event.getPower());
        XBulletWave wave = this.createXBulletWave(event.getOpponentSnapshot(), event.getMySnapshot(), xbullet, event.getGun().getName(), adjustedFireTime, false);
        this.myWaves.add(wave);
        for (Wave opponentWave : this.opponentWaves) {
            this.addBulletShadow(wave, opponentWave, Resources.getTime());
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppWaveUpdated(opponentWave);
            }
        }
        for (MyWaveListener listener : this.myWaveListeners) {
            listener.myWaveCreated(wave);
        }
    }

    @Override
    public void virtualGunFired(GunFiredEvent event) {
        long adjustedFireTime = Resources.getTime();
        XBullet xbullet = new XBullet(event.getMySnapshot().getLocation(), event.getAim(), event.getPower());
        XBulletWave wave = this.createXBulletWave(event.getOpponentSnapshot(), event.getMySnapshot(), xbullet, event.getGun().getName(), adjustedFireTime, false);
        this.myVirtualWaves.add(wave);
        for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
            listener.myVirtualWaveCreated(wave);
        }
    }

    @Override
    public void opponentGunFired(OpponentGunFiredEvent event) {
        long adjustedFireTime = event.getTime() - 1L;
        double adjustedFirePower = Math.max(0.1, event.getPower());
        Wave wave = this.createWave(event.getMySnapshot(), event.getOpponentSnapshot(), adjustedFirePower, adjustedFireTime, true, event.isEstimated());
        this.opponentWaves.add(wave);
        for (XBulletWave myWave : this.myWaves) {
            this.addBulletShadow(myWave, wave, Resources.getTime());
        }
        for (OpponentWaveListener listener : this.oppWaveListeners) {
            listener.oppWaveCreated(wave);
        }
    }

    private void updateMyWaves(long time) {
        Snapshot oppSnapshot = null;
        Iterator<XBulletWave> iter = this.myWaves.iterator();
        while (iter.hasNext()) {
            XBulletWave wave = iter.next();
            if (oppSnapshot == null || !oppSnapshot.getName().equals(wave.getInitialDefenderSnapshot().getName())) {
                oppSnapshot = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            }
            double waveDistance = wave.getBulletTravelDistance(time);
            double oppDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= oppDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWaveHit(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= oppDistance) {
                wave.state = WaveState.PASSING;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWavePassing(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= oppDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWavePassed(wave, oppSnapshot);
                }
            }
            if (wave.getState() != WaveState.PASSED || !(waveDistance > this.maxWaveSaveDistance)) continue;
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myWaveDestroyed(wave);
            }
            iter.remove();
        }
    }

    private void updateMyVirtualWaves(long time) {
        Snapshot oppSnapshot = null;
        Iterator<XBulletWave> iter = this.myVirtualWaves.iterator();
        while (iter.hasNext()) {
            XBulletWave wave = iter.next();
            if (oppSnapshot == null || !oppSnapshot.getName().equals(wave.getInitialDefenderSnapshot().getName())) {
                oppSnapshot = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            }
            double waveDistance = wave.getBulletTravelDistance(time);
            double oppDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= oppDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWaveHit(wave);
                }
                double waveDistanceToOpponent = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
                Point2D.Double expectedRobotPosition = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), waveDistanceToOpponent, wave.getXBullet().getAim());
                double diff = RCMath.getDistanceBetweenPoints(oppSnapshot.getLocation(), expectedRobotPosition);
                if (diff <= 20.0) {
                    for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                        listener.myVirtualBulletHit(wave);
                    }
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= oppDistance) {
                wave.state = WaveState.PASSING;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWavePassing(wave);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= oppDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWavePassed(wave);
                }
            }
            if (wave.getState() != WaveState.PASSED || !(waveDistance > this.maxWaveSaveDistance)) continue;
            for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                listener.myVirtualWaveDestroyed(wave);
            }
            iter.remove();
        }
    }

    private void updateOpponentWaves(long time) {
        Snapshot mySnapshot = this.snapshotHistory.getMySnapshot(time, true);
        Wave nextWaveToHit = null;
        long minToHitTime = Long.MAX_VALUE;
        Iterator<Wave> iter = this.opponentWaves.iterator();
        while (iter.hasNext()) {
            long timeToHit;
            Wave wave = iter.next();
            double waveDistance = wave.getBulletTravelDistance(time);
            double myDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), mySnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= myDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWaveHit(wave);
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= myDistance) {
                wave.state = WaveState.PASSING;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWavePassing(wave);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= myDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWavePassed(wave);
                }
            }
            if (wave.getState() == WaveState.PASSED && waveDistance > this.maxWaveSaveDistance) {
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWaveDestroyed(wave);
                }
                iter.remove();
            }
            if (wave.getState() != WaveState.LEADING || (timeToHit = wave.getTimeUntilHit(mySnapshot.getX(), mySnapshot.getY(), mySnapshot.getTime())) >= minToHitTime) continue;
            minToHitTime = timeToHit;
            nextWaveToHit = wave;
        }
        if (nextWaveToHit != this.oppNextWaveToHit) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppNextWaveToHit(nextWaveToHit);
            }
            this.oppNextWaveToHit = nextWaveToHit;
        }
    }

    @Override
    public void onTurnBegin() {
        long time = Resources.getTime();
        this.meaCache.clear();
        this.updateMyWaves(time);
        this.updateMyVirtualWaves(time);
        this.updateOpponentWaves(time);
    }

    @Override
    public void onTurnEnd() {
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        XBulletWave wave = (XBulletWave)this.getMatchingWave(this.myWaves, event.getBullet(), event.getTime());
        if (wave != null) {
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myBulletHit(wave, event);
            }
        }
    }

    private Wave getMatchingWave(List<? extends Wave> waves, Bullet bullet, long time) {
        double closestWaveDist = Double.POSITIVE_INFINITY;
        Wave closestWave = null;
        for (Wave wave : waves) {
            if (!RCMath.differenceLessThan(bullet.getVelocity(), wave.getBulletVelocity(), 0.05)) continue;
            double waveDistance = wave.getBulletTravelDistance(time);
            double bulletAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), bullet.getX(), bullet.getY());
            Point2D.Double wavePoint = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), waveDistance, bulletAngle);
            double positionDifference = RCMath.getDistanceBetweenPoints(wavePoint.x, wavePoint.y, bullet.getX(), bullet.getY());
            if (!(positionDifference < closestWaveDist)) continue;
            closestWaveDist = positionDifference;
            closestWave = wave;
        }
        if (closestWaveDist <= bullet.getVelocity() * 2.0 + 0.1) {
            return closestWave;
        }
        log.warn("Unable to find matching wave for bullet.");
        log.warn("Bullet: owner=" + bullet.getName() + "; velocity=" + Logger.format(bullet.getVelocity()) + "; closest wave dist=" + closestWaveDist);
        return null;
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Wave oppWave;
        Bullet myBullet = event.getBullet();
        Bullet oppBullet = event.getHitBullet();
        long time = event.getTime();
        XBulletWave myWave = (XBulletWave)this.getMatchingWave(this.myWaves, myBullet, time);
        if (myWave != null) {
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myWaveHitBullet(myWave, myBullet);
            }
            this.myWaves.remove(myWave);
        }
        if ((oppWave = this.getMatchingWave(this.opponentWaves, oppBullet, time)) != null) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppWaveHitBullet(oppWave, oppBullet);
            }
            this.opponentWaves.remove(oppWave);
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent event) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        Wave wave = this.getMatchingWave(this.opponentWaves, event.getBullet(), event.getTime());
        if (wave != null) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppBulletHit(wave, event);
            }
        }
    }

    private static class WaveParams {
        Snapshot attacker;
        Snapshot defender;
        double bulletPower;

        public WaveParams(Snapshot attacker, Snapshot defender, double bulletPower) {
            this.attacker = attacker;
            this.defender = defender;
            this.bulletPower = bulletPower;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attacker == null ? 0 : this.attacker.hashCode());
            long temp = Double.doubleToLongBits(this.bulletPower);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.defender == null ? 0 : this.defender.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaveParams other = (WaveParams)obj;
            if (this.attacker == null ? other.attacker != null : !this.attacker.equals(other.attacker)) {
                return false;
            }
            if (Double.doubleToLongBits(this.bulletPower) != Double.doubleToLongBits(other.bulletPower)) {
                return false;
            }
            return !(this.defender == null ? other.defender != null : !this.defender.equals(other.defender));
        }
    }
}

