/*
 * Decompiled with CFR 0.152.
 */
package FatalFlaw;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class FatalFlaw
extends AdvancedRobot {
    double previousEnergy = 100.0;
    int movementDirection = 1;
    int gunDirection = 1;
    public double fieldWidth = 0.0;
    public double fieldHeight = 0.0;
    public boolean movingForward = true;
    public double hitTimer = 10.0;
    public double targetBearing = -200.0;
    public double targetDistance = -1.0;
    public double targetHeading = 0.0;
    public double targetVelocity = 0.0;
    public double lastTargetHeading = 0.0;
    public double lastTargetVelocity = 0.0;
    public double targetX = 0.0;
    public double targetY = 0.0;
    public double myX;
    public double myY;
    public double noTargetTurn = 1000.0;
    public double turn = 1.0;
    public double scanNoTargetTurn = 0.0;
    public double estBulletX = 0.0;
    public double estBulletY = 0.0;
    public double lastTargetX = 0.0;
    public double lastTargetY = 0.0;
    public double radarDirection = 1.0;
    public double turnDirection = 1.0;

    public void run() {
        this.fieldWidth = this.getBattleFieldWidth();
        this.fieldHeight = this.getBattleFieldHeight();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.myX = this.getX();
        this.myY = this.getY();
        this.addCustomEvent(new Condition("move"){

            public boolean test() {
                return FatalFlaw.this.myX != FatalFlaw.this.getX() || FatalFlaw.this.myY != FatalFlaw.this.getY();
            }
        });
        this.addCustomEvent(new Condition("nearWall"){

            public boolean test() {
                return FatalFlaw.this.getX() < 100.0 || FatalFlaw.this.getY() < 100.0 || FatalFlaw.this.getX() > FatalFlaw.this.fieldWidth - 100.0 || FatalFlaw.this.getY() > FatalFlaw.this.fieldHeight - 100.0;
            }
        });
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurnRight(e.getBearing() + 90.0 - (double)(30 * this.movementDirection));
        double changeInEnergy = this.previousEnergy - e.getEnergy();
        if (changeInEnergy > 0.0 && changeInEnergy <= 3.0) {
            this.movementDirection = -this.movementDirection;
            this.setTurnRight((e.getBearing() + 90.0) * (double)this.movementDirection);
            this.setAhead((e.getDistance() / 4.0 + 25.0) * (double)this.movementDirection);
        }
        this.lastTargetHeading = this.targetHeading;
        this.lastTargetVelocity = this.targetVelocity;
        this.lastTargetX = this.targetX;
        this.lastTargetY = this.targetY;
        this.targetBearing = e.getBearing();
        this.targetDistance = e.getDistance();
        this.targetHeading = e.getHeading();
        this.targetVelocity = e.getVelocity();
        double radarTurn = (this.getHeading() - this.getRadarHeading() + this.targetBearing) % 360.0;
        radarTurn = radarTurn <= 180.0 ? radarTurn : radarTurn - 360.0;
        radarTurn = radarTurn >= -180.0 ? radarTurn : radarTurn + 360.0;
        this.setTurnRadarRight(radarTurn);
        this.radarDirection *= -1.0;
        this.setTargetXY(this.targetBearing, this.targetDistance);
        if (this.getGunHeat() == 0.0) {
            this.shoot();
        }
        this.noTargetTurn = 0.0;
        this.scan();
        this.previousEnergy = e.getEnergy();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.hitTimer = 0.0;
    }

    public void onHitWall(HitWallEvent e) {
        this.reverseDirection();
    }

    public void onHitRobot(HitRobotEvent e) {
        this.reverseDirection();
    }

    public void reverseDirection() {
        if (this.movingForward) {
            this.setMaxVelocity(6.0);
            this.setMaxTurnRate(10.0);
            this.setBack(40000.0);
            this.movingForward = false;
        } else {
            this.setMaxVelocity(6.0);
            this.setMaxTurnRate(10.0);
            this.setAhead(40000.0);
            this.movingForward = true;
        }
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition().getName().equals("move")) {
            double bearing = this.getTargetBearing("heading");
            this.hitTimer += 1.0;
            if (this.targetDistance > 400.0) {
                if (bearing <= 45.0 && bearing >= -45.0 && this.hitTimer >= 10.0) {
                    this.setMaxVelocity(8.0);
                } else if (this.hitTimer >= 10.0) {
                    this.setMaxVelocity(5.0);
                }
            } else if (this.hitTimer >= 10.0 && this.hitTimer % 4.0 == 0.0) {
                bearing = (bearing = (bearing - this.turnDirection * 90.0) % 360.0) <= 180.0 ? bearing : bearing - 360.0;
                bearing = bearing >= -180.0 ? bearing : bearing + 360.0;
                this.setTurnRight(bearing);
                this.setAhead(100000.0);
                this.setMaxVelocity(8.0);
            } else if (this.turnDirection == 1.0 && bearing <= 135.0 && bearing >= 45.0 || this.turnDirection == -1.0 && bearing <= -45.0 && bearing >= -35.0 && this.hitTimer >= 10.0) {
                this.setMaxVelocity(8.0);
                this.setMaxTurnRate(2.0);
            } else if (this.hitTimer >= 10.0) {
                this.setMaxVelocity(5.0);
                this.setMaxTurnRate(10.0);
            }
            if (this.hitTimer == 1.0) {
                this.turnDirection *= -1.0;
                this.turn = 1.0;
                this.setTurnRight(180.0);
                this.setMaxVelocity(8.0);
            }
            this.noTargetTurn += 1.0;
            if (this.noTargetTurn > 6.0 && this.noTargetTurn % 7.0 == 0.0) {
                this.setTurnRadarRight(360.0);
                this.noTargetTurn = 0.0;
            }
        } else if (e.getCondition().getName().equals("nearWall")) {
            double bearing = this.getCenterBearing();
            this.setMaxTurnRate(10.0);
            this.setTurnRight(bearing);
            this.setMaxVelocity(8.0);
            this.setAhead(40000.0);
            this.hitTimer = 1.0;
        }
    }

    public double getCenterBearing() {
        double alpha = Math.toDegrees(Math.atan((this.fieldHeight / 2.0 - this.getY()) / (this.fieldWidth / 2.0 - this.getX())));
        if (this.fieldHeight / 2.0 - this.getY() < 0.0 && this.fieldWidth / 2.0 - this.getX() < 0.0) {
            alpha += 180.0;
        } else if (this.fieldHeight / 2.0 - this.getY() < 0.0 && this.fieldWidth / 2.0 - this.getX() > 0.0) {
            alpha += 360.0;
        } else if (this.fieldHeight / 2.0 - this.getY() > 0.0 && this.fieldWidth / 2.0 - this.getX() < 0.0) {
            alpha += 180.0;
        }
        double bearing = 90.0 - this.getHeading() - alpha;
        bearing = bearing <= 180.0 ? bearing : bearing - 360.0;
        bearing = bearing >= -180.0 ? bearing : bearing + 360.0;
        return bearing;
    }

    public void setTargetXY(double targetBearing, double targetDistance) {
        this.targetBearing = targetBearing;
        this.targetDistance = targetDistance;
        double alpha = 90.0 - this.getHeading() - targetBearing;
        this.targetX = targetDistance * Math.cos(Math.toRadians(alpha)) + this.getX();
        this.targetY = targetDistance * Math.sin(Math.toRadians(alpha)) + this.getY();
        this.scanNoTargetTurn = this.noTargetTurn;
    }

    public double getTargetBearing(String type) {
        double alpha = Math.toDegrees(Math.atan((this.targetY - this.getY()) / (this.targetX - this.getX())));
        if (this.targetY - this.getY() < 0.0 && this.targetX - this.getX() < 0.0) {
            alpha += 180.0;
        } else if (this.targetY - this.getY() < 0.0 && this.targetX - this.getX() > 0.0) {
            alpha += 360.0;
        } else if (this.targetY - this.getY() > 0.0 && this.targetX - this.getX() < 0.0) {
            alpha += 180.0;
        }
        double bearing = 90.0 - this.getGunHeading() - alpha;
        if (type.equals("heading")) {
            bearing = 90.0 - this.getHeading() - alpha;
        }
        bearing = bearing <= 180.0 ? bearing : bearing - 360.0;
        bearing = bearing >= -180.0 ? bearing : bearing + 360.0;
        return bearing;
    }

    public double predictionAngle(double bulletSpeed) {
        double angle = 0.0;
        double bearing = this.getHeading() + this.targetBearing;
        double toTurn = this.getHeading() - this.getGunHeading() + this.targetBearing;
        double angularChange = 0.0;
        double velocityChange = 0.0;
        if (this.scanNoTargetTurn < 3.0 && this.scanNoTargetTurn != 0.0) {
            angularChange = (this.targetHeading - this.lastTargetHeading) / this.scanNoTargetTurn;
            velocityChange = (this.targetVelocity - this.lastTargetVelocity) / this.scanNoTargetTurn;
            double dTravel = Math.sqrt((this.targetX - this.lastTargetX) * (this.targetX - this.lastTargetX) + (this.targetY - this.lastTargetY) * (this.targetY - this.lastTargetY)) / this.scanNoTargetTurn;
            angularChange = angularChange / dTravel * this.targetVelocity;
            velocityChange = velocityChange / dTravel * this.targetVelocity;
        }
        double diagonal = Math.sqrt(this.fieldWidth * this.fieldWidth + this.fieldHeight * this.fieldHeight);
        angle = -45.0;
        while (angle < 45.0) {
            double gunTurn = Math.abs((toTurn + angle) % 180.0);
            double estTargetX = this.targetX;
            double estTargetY = this.targetY;
            double time = 1.0;
            while (time < diagonal / bulletSpeed) {
                double estDistance;
                double myAngle = bearing + angle;
                estTargetX += Math.sin(Math.toRadians(this.targetHeading + time * angularChange)) * (this.targetVelocity + time * velocityChange);
                estTargetY += Math.cos(Math.toRadians(this.targetHeading + time * angularChange)) * (this.targetVelocity + time * velocityChange);
                this.estBulletX = this.myX + Math.sin(Math.toRadians(myAngle)) * (time - gunTurn / 20.0) * bulletSpeed;
                this.estBulletY = this.myY + Math.cos(Math.toRadians(myAngle)) * (time - gunTurn / 20.0) * bulletSpeed;
                if (!(this.estBulletX < 0.0 || this.estBulletY < 0.0 || this.estBulletX > this.fieldWidth || this.estBulletY > this.fieldHeight || !((estDistance = Math.sqrt((estTargetX - this.estBulletX) * (estTargetX - this.estBulletX) + (estTargetY - this.estBulletY) * (estTargetY - this.estBulletY))) < 5.0))) {
                    return angle;
                }
                time += 1.0;
            }
            angle += 1.0;
        }
        return 1000.0;
    }

    public void shoot() {
        this.myX = this.getX();
        this.myY = this.getY();
        double angle = this.predictionAngle(Rules.getBulletSpeed((double)2.0));
        if (angle != 1000.0) {
            double gunTurn = (this.getHeading() - this.getGunHeading() + this.targetBearing + angle) % 360.0;
            gunTurn = gunTurn <= 180.0 ? gunTurn : gunTurn - 360.0;
            gunTurn = gunTurn >= -180.0 ? gunTurn : gunTurn + 360.0;
            this.turnGunRight(gunTurn);
            this.fire(2.0);
        } else {
            double gunTurn = (this.getHeading() - this.getGunHeading() + this.targetBearing) % 360.0;
            gunTurn = gunTurn <= 180.0 ? gunTurn : gunTurn - 360.0;
            gunTurn = gunTurn >= -180.0 ? gunTurn : gunTurn + 360.0;
            this.setTurnGunRight(gunTurn);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.white);
        g.drawLine((int)this.myX, (int)this.myY, (int)this.estBulletX, (int)this.estBulletY);
        g.setColor(Color.red);
        g.fillOval((int)this.estBulletX - 3, (int)this.estBulletY - 3, 6, 6);
    }
}

