/*
 * Decompiled with CFR 0.152.
 */
package jbot.guns;

import java.awt.Graphics2D;
import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import robocode.Bullet;

public abstract class Gun {
    public static final double SHIELD_BULLET_POWER = 0.1;
    public static final double ACCURATE_BULLET_POWER = 0.49999;
    public static final double MAIN_BULLET_POWER = 1.99999;
    public static final double MIGHT_BULLET_POWER = 3.0;
    protected Rabbit2 mBot;
    protected Tracer mTracer;
    protected Target mTarget;
    protected Target mSelf;
    protected boolean mIsEnergyPermitted = true;
    protected double mTurnBearing = 0.0;
    private int mFiredBullets = 0;

    protected Gun(Rabbit2 bot) {
        this.mBot = bot;
        this.mTracer = this.mBot.getTracer();
        this.mTarget = this.mTracer.getEnemyTarget();
        this.mSelf = this.mTracer.getSelfTarget();
    }

    public void frame(double deltaTime) {
        this.frameLogic(deltaTime);
        this.mBot.setTurnGunRightRadians(this.mTurnBearing);
    }

    protected abstract void frameLogic(double var1);

    public boolean isGunCool() {
        return this.mBot.getGunHeat() == 0.0;
    }

    public int getFiredBulletsNum() {
        return this.mFiredBullets;
    }

    public void permitEnergy(boolean ep) {
        this.mIsEnergyPermitted = ep;
    }

    public int getRemainCoolingFrames() {
        if (this.isGunCool()) {
            return 0;
        }
        return (int)Math.ceil(this.mBot.getGunHeat() / this.mBot.getGunCoolingRate());
    }

    public static int getRemainCoolingFrames(double gunHeat, double coolingRate) {
        if (gunHeat == 0.0) {
            return 0;
        }
        return (int)Math.ceil(gunHeat / coolingRate);
    }

    public Bullet setFireBullet(double power) {
        if (this.isGunCool()) {
            this.mTracer.setFireBullet(power);
            ++this.mFiredBullets;
            return this.mBot.setFireBullet(power);
        }
        return null;
    }

    public void onPaint(Graphics2D g) {
    }
}

