/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Move;

import java.awt.Graphics2D;
import java.util.Random;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Move.MoveAlgo;
import robocode.util.Utils;

public class Sidestep
extends MoveAlgo {
    private static double APPROACH_ANGEL = 0.0;
    private static int MAX_DIST = 50;
    private static int MIN_DIST = 15;
    private static int MIN_BORDER_DIST = 50;
    private boolean tooClose = false;
    private boolean clockwise = true;
    private int distance = 0;
    private Random rand = new Random();

    public Sidestep(DataList s, Aiming t) {
        super(s, t);
    }

    private boolean checkCloseToBorder() {
        if (this.myPos.x < 50.0) {
            return true;
        }
        if (this.myPos.y < 50.0) {
            return true;
        }
        if (this.battleSize.x - this.myPos.x < 50.0) {
            return true;
        }
        return this.battleSize.y - this.myPos.y < 50.0;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
    }

    @Override
    public void process(Vector myPos_, double myHeading_) {
        super.process(myPos_, myHeading_);
        String target = this.aiming.getTargetName();
        if (target == null) {
            return;
        }
        if (this.checkCloseToBorder()) {
            if (!this.tooClose) {
                this.distance = 0;
                this.tooClose = true;
            }
        } else {
            this.tooClose = false;
        }
        if (this.distance == 0) {
            this.clockwise = !this.clockwise;
            this.distance = this.rand.nextInt(MAX_DIST - MIN_DIST + 1) + MIN_DIST;
        }
        --this.distance;
        ScanData scan = this.scans.getEnemyData(target).getLastScan();
        double dir = scan.vDirToHim.getDirection();
        if (this.clockwise) {
            dir += 1.5707963267948966 - APPROACH_ANGEL;
            this.finalDist = Double.POSITIVE_INFINITY;
        } else {
            dir += 1.5707963267948966 + APPROACH_ANGEL;
            this.finalDist = Double.NEGATIVE_INFINITY;
        }
        this.finalAngle = Utils.normalRelativeAngle((double)(dir - myHeading_));
    }
}

