/*
 * Decompiled with CFR 0.152.
 */
package nzeemin;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Izh
extends AdvancedRobot {
    double targetDirection = -1.0;
    double targetAngle = 0.0;
    double targetX = -1.0;
    double targetY = -1.0;
    int targetPauseCount = 0;
    double enemyLastX = -1.0;
    double enemyLastY = -1.0;
    double enemyLastHeadingRad = 0.0;
    double enemyLastVelocity = 0.0;
    int ticksSinceEnemyLast = -1;
    double enemyPredictX = -1.0;
    double enemyPredictY = -1.0;

    public void run() {
        this.setAdjustRadarForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustGunForRobotTurn(false);
        this.setColors(Color.blue, Color.cyan, Color.gray);
        this.setBulletColor(Color.cyan);
        while (true) {
            if (this.ticksSinceEnemyLast >= 4) {
                this.ticksSinceEnemyLast = -1;
            }
            if (this.ticksSinceEnemyLast < 0) {
                this.enemyLastY = -1.0;
                this.enemyLastX = -1.0;
                this.enemyLastVelocity = 0.0;
                this.enemyLastHeadingRad = 0.0;
                this.ticksSinceEnemyLast = -1;
                this.setTurnRadarRight(45.0);
            }
            double bulletPower = 1.0;
            double gunRotate = 0.0;
            double bearing = 0.0;
            double bodyRotate = 0.0;
            if (this.targetPauseCount > 0) {
                --this.targetPauseCount;
            } else if (this.targetX < 0.0) {
                int i = 0;
                while (i < 100) {
                    this.targetAngle = Utils.getRandom().nextDouble() * Math.PI * 2.0;
                    this.targetDirection = 1.0;
                    if (this.targetAngle > Math.PI) {
                        this.targetDirection = -1.0;
                    }
                    this.targetAngle = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + this.targetAngle - 1.5707963267948966));
                    double stepdist = 60.0 + Utils.getRandom().nextDouble() * 60.0;
                    this.targetX = this.getX() + Math.sin(this.targetAngle) * stepdist;
                    this.targetY = this.getY() + Math.cos(this.targetAngle) * stepdist;
                    if (this.targetX < 27.0 || this.targetX > this.getBattleFieldWidth() - 27.0 || this.targetY < 27.0 || this.targetY > this.getBattleFieldHeight() - 27.0 || (this.targetX - this.enemyLastX) * (this.targetX - this.enemyLastX) + (this.targetY - this.enemyLastY) * (this.targetY - this.enemyLastY) < 2025.0) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if ((this.getX() - this.targetX) * (this.getX() - this.targetX) + (this.getY() - this.targetY) * (this.getY() - this.targetY) < 36.0) {
                this.targetY = -1.0;
                this.targetX = -1.0;
                this.targetAngle = 0.0;
                this.targetPauseCount = Utils.getRandom().nextInt(3);
            } else {
                double bearingTarget = Math.atan2(this.targetX - this.getX(), this.targetY - this.getY());
                double speed = 6.0 + Utils.getRandom().nextDouble() * 2.0;
                double goalDirection = this.targetDirection < 0.0 ? bearingTarget + Math.PI : bearingTarget;
                double maxBodyTurn = 0.14835298641951802;
                bodyRotate = Utils.normalRelativeAngle((double)((goalDirection += (Utils.getRandom().nextDouble() - 0.5) * 3.0 * Math.PI / 180.0) - this.getHeadingRadians()));
                bodyRotate = Math.max(Math.min(bodyRotate, maxBodyTurn), -maxBodyTurn);
                this.setAhead(speed * this.targetDirection);
                this.setTurnRightRadians(bodyRotate);
            }
            if (this.ticksSinceEnemyLast > 0) {
                double distance = Math.sqrt((this.enemyLastX - this.getX()) * (this.enemyLastX - this.getX()) + (this.enemyLastY - this.getY()) * (this.enemyLastY - this.getY()));
                bulletPower = Math.min(3.0, distance < 300.0 ? 450.0 / distance : 1.5);
                double bulletTravelTime = distance / (20.0 - 3.0 * bulletPower);
                this.enemyPredictX = this.enemyLastX + bulletTravelTime * this.enemyLastVelocity * Math.sin(this.enemyLastHeadingRad);
                this.enemyPredictY = this.enemyLastY + bulletTravelTime * this.enemyLastVelocity * Math.cos(this.enemyLastHeadingRad);
                bearing = Math.atan2(this.enemyPredictX - this.getX(), this.enemyPredictY - this.getY());
                distance = Math.sqrt((this.enemyPredictX - this.getX()) * (this.enemyPredictX - this.getX()) + (this.enemyPredictY - this.getY()) * (this.enemyPredictY - this.getY()));
                gunRotate = Utils.normalRelativeAngle((double)(bearing - this.getGunHeadingRadians()));
                gunRotate = Math.max(Math.min(gunRotate, Rules.GUN_TURN_RATE_RADIANS), -Rules.GUN_TURN_RATE_RADIANS);
                this.setTurnGunRightRadians(gunRotate);
            }
            if (this.ticksSinceEnemyLast > 0) {
                double bearingCurrent = Math.atan2(this.enemyLastX - this.getX(), this.enemyLastY - this.getY());
                double radarTurnRad = Utils.normalRelativeAngle((double)(bearingCurrent - this.getRadarHeadingRadians()));
                double extraTurnRad = 0.1308996938995747;
                radarTurnRad += radarTurnRad < 0.0 ? -extraTurnRad : extraTurnRad;
                radarTurnRad = Utils.normalRelativeAngle((double)(radarTurnRad - gunRotate - bodyRotate));
                radarTurnRad = Math.max(Math.min(radarTurnRad, Rules.RADAR_TURN_RATE_RADIANS), -Rules.RADAR_TURN_RATE_RADIANS);
                this.setTurnRadarRightRadians(radarTurnRad);
            }
            if (Math.abs(gunRotate) < 0.06981317007977318 && this.getGunHeat() == 0.0) {
                this.setFire(bulletPower);
            }
            this.execute();
            if (this.ticksSinceEnemyLast < 0) continue;
            ++this.ticksSinceEnemyLast;
        }
    }

    public void onPaint(Graphics2D g) {
        if (this.targetX >= 0.0) {
            g.setColor(Color.RED);
            g.drawLine((int)this.getX(), (int)this.getY(), (int)this.targetX, (int)this.targetY);
        }
        if (this.enemyLastX >= 0.0) {
            g.setColor(Color.GRAY);
            g.drawLine((int)this.getX(), (int)this.getY(), (int)this.enemyPredictX, (int)this.enemyPredictY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.enemyLastX = this.getX() + Math.sin(absBearing) * e.getDistance();
        this.enemyLastY = this.getY() + Math.cos(absBearing) * e.getDistance();
        this.enemyLastHeadingRad = e.getHeadingRadians();
        this.enemyLastVelocity = e.getVelocity();
        this.ticksSinceEnemyLast = 0;
    }
}

