/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.move.plan;

import catcat20.helios.move.path.Path;
import catcat20.helios.move.path.PathPos;
import catcat20.helios.move.plan.SurfPlan;
import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.robot.Bot;
import catcat20.helios.robot.BotState;
import catcat20.helios.utils.HConstants;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.MovementPredictor;
import catcat20.helios.utils.Wave;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class MeleePlan
implements SurfPlan {
    public static final int directions = 12;
    public static final int WALL_STICK = 200;

    @Override
    public ArrayList<Path> generatePath(MovementPredictor.PredictionStatus status, Wave w) {
        ArrayList<Path> paths = new ArrayList<Path>();
        long genTime = 0L;
        long then = System.nanoTime();
        double division = 12.0;
        int start = 0;
        Bot en = HeliosRadar.getBot(w.enName);
        BotState enState = en.currentState;
        double enAngle = HUtils.absoluteBearing(status, enState.getPosition());
        for (int i = start; i < 360; i += (int)(360.0 / division)) {
            boolean isDangerAngle = true;
            if (!isDangerAngle || !HConstants.field.contains(HUtils.project(status, Math.toRadians(i), 140.0))) continue;
            Path path = new Path(this.precisePredict(HConstants.safeField, w, 8.0, status, Math.toRadians(i)));
            if (!HConstants.field.contains(path.path.get(Math.max(0, path.path.size() - 1)))) continue;
            paths.add(path);
        }
        paths.add(new Path(this.precisePredict(HConstants.safeField, w, 0.0, status, status.heading)));
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        genTime += millis;
        return paths;
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        double count = 1.0;
        double step = 0.0;
        double v = Math.toRadians(2.0);
        while (!HConstants.safeField.contains(HUtils.project(botLocation, angle, 200.0))) {
            count = -Math.signum(count) * (step += v);
            angle += (double)orientation * count;
        }
        return angle;
    }

    public ArrayList<PathPos> precisePredict(Rectangle2D.Double fieldRect, Wave ew, double maxVelocity, MovementPredictor.PredictionStatus status, double heading) {
        ArrayList<PathPos> cachePoss = new ArrayList<PathPos>();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        do {
            predictedStatus = MovementPredictor.predict(predictedStatus, heading, maxVelocity);
            PathPos cachePos = new PathPos(predictedStatus.x, predictedStatus.y);
            cachePos.status = predictedStatus;
            cachePos.maxVelocity = maxVelocity;
            cachePos.goHeading = heading;
            cachePos.pathColor = ew.color;
            heading = this.wallSmoothing(status, heading, 1);
            cachePoss.add(cachePos);
            ++counter;
            if (predictedStatus.distance(ew) < ew.distanceTraveled + (double)counter * ew.bulletVelocity() + ew.bulletVelocity()) {
                intercepted = true;
            }
            if (fieldRect.contains(predictedStatus.x, predictedStatus.y)) continue;
            intercepted = true;
        } while (!intercepted && counter < 30);
        return cachePoss;
    }

    @Override
    public double eval(MovementPredictor.PredictionStatus status, Wave w) {
        return 0.0;
    }
}

