/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.useful;

import java.awt.geom.Point2D;

public class FieldPoint
extends Point2D.Double {
    private static final long serialVersionUID = 6797587839090734395L;

    public static double getAngleFromSides(double x, double y) {
        double angle;
        for (angle = Math.atan2(x, y); angle < 0.0; angle += Math.PI * 2) {
        }
        while (angle >= Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public FieldPoint() {
    }

    public FieldPoint(double x, double y) {
        super(x, y);
    }

    public FieldPoint(FieldPoint point) {
        super(point.x, point.y);
    }

    @Override
    public double distance(Point2D point) {
        double answer = super.distance(point);
        if (Double.isNaN(answer)) {
            return 0.0;
        }
        return answer;
    }

    public double getAngleTo(FieldPoint point) {
        return FieldPoint.getAngleFromSides(point.x - this.x, point.y - this.y);
    }

    public FieldPoint getMeanPoint(FieldPoint point) {
        return new FieldPoint((this.x + point.x) / 2.0, (this.y + point.y) / 2.0);
    }

    public FieldPoint project(double distance, double angle) {
        return new FieldPoint(this.x + distance * Math.sin(angle), this.y + distance * Math.cos(angle));
    }
}

