/*
 * Decompiled with CFR 0.152.
 */
package Polkwane;

import Polkwane.GFTUtils;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

class GFTWave
extends Condition {
    static Point2D targetLocation;
    double bulletPower;
    Point2D gunLocation;
    double bearing;
    double lateralDirection;
    private static final double MAX_DISTANCE = 900.0;
    private static final int DISTANCE_INDEXES = 5;
    private static final int VELOCITY_INDEXES = 5;
    private static final int BINS = 25;
    private static final int MIDDLE_BIN = 12;
    private static final double MAX_ESCAPE_ANGLE = 0.7;
    private static final double BIN_WIDTH = 0.05833333333333333;
    private static int[][][][] statBuffers;
    private int[] buffer;
    private AdvancedRobot robot;
    private double distanceTraveled;

    static {
        statBuffers = new int[5][5][5][25];
    }

    GFTWave(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public boolean test() {
        this.advance();
        if (this.hasArrived()) {
            int n = this.currentBin();
            this.buffer[n] = this.buffer[n] + 1;
            this.robot.removeCustomEvent((Condition)this);
        }
        return false;
    }

    double mostVisitedBearingOffset() {
        return this.lateralDirection * 0.05833333333333333 * (double)(this.mostVisitedBin() - 12);
    }

    void setSegmentations(double distance, double velocity, double lastVelocity) {
        int distanceIndex = (int)(distance / 180.0);
        int velocityIndex = (int)Math.abs(velocity / 2.0);
        int lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
        this.buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
    }

    private void advance() {
        this.distanceTraveled += GFTUtils.bulletVelocity(this.bulletPower);
    }

    private boolean hasArrived() {
        return this.distanceTraveled > this.gunLocation.distance(targetLocation) - 18.0;
    }

    private int currentBin() {
        int bin = (int)Math.round(Utils.normalRelativeAngle((double)(GFTUtils.absoluteBearing(this.gunLocation, targetLocation) - this.bearing)) / (this.lateralDirection * 0.05833333333333333) + 12.0);
        return GFTUtils.minMax(bin, 0, 24);
    }

    private int mostVisitedBin() {
        int mostVisited = 12;
        int i = 0;
        while (i < 25) {
            if (this.buffer[i] > this.buffer[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }
}

