/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.utils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import robocode.Rules;
import robocode.util.Utils;

public final class PreciseWallSmooth {
    private static final double DELTA_SIN = Math.sin(Rules.getTurnRateRadians((double)8.0) / 2.0);
    private static final double DELTA_COS = Math.sqrt(1.0 - DELTA_SIN * DELTA_SIN);
    private static final double INNER_R = 4.0 / Math.tan(Rules.getTurnRateRadians((double)8.0) / 2.0);
    private static final double OUTER_R = 4.0 / DELTA_SIN;
    private static final double WALL_PADDING = 18.5;
    private final double MIN_X;
    private final double MIN_Y;
    private final double MAX_X;
    private final double MAX_Y;

    public PreciseWallSmooth(double fieldWidth, double fieldHeight) {
        this.MIN_X = 18.5;
        this.MIN_Y = 18.5;
        this.MAX_X = fieldWidth - 18.5;
        this.MAX_Y = fieldHeight - 18.5;
    }

    public double smoothHeading(double absoluteHeading, @Output Trig headingTrig, double x, double y, int latDir) {
        double stickDistV;
        double stickDistH;
        double stickBearingSin = headingTrig.cos * (double)latDir;
        double stickBearingCos = -headingTrig.sin * (double)latDir;
        double stickX = x + INNER_R * stickBearingSin + 4.0 * headingTrig.sin;
        double stickY = y + INNER_R * stickBearingCos + 4.0 * headingTrig.cos;
        double stickDistW = stickX - this.MIN_X;
        double stickDistE = this.MAX_X - stickX;
        double stickDistN = this.MAX_Y - stickY;
        double stickDistS = stickY - this.MIN_Y;
        double distW = x - this.MIN_X;
        double distE = this.MAX_X - x;
        double distN = this.MAX_Y - y;
        double distS = y - this.MIN_Y;
        WALL wallH = null;
        if (stickDistW < stickDistE) {
            stickDistH = stickDistW;
            if (stickDistH < OUTER_R - 0.1) {
                wallH = WALL.W;
            }
        } else {
            stickDistH = stickDistE;
            if (stickDistH < OUTER_R - 0.1) {
                wallH = WALL.E;
            }
        }
        WALL wallV = null;
        if (stickDistS < stickDistN) {
            stickDistV = stickDistS;
            if (stickDistV < OUTER_R - 0.1) {
                wallV = WALL.S;
            }
        } else {
            stickDistV = stickDistN;
            if (stickDistV < OUTER_R - 0.1) {
                wallV = WALL.N;
            }
        }
        WALL forwardHWall = headingTrig.sin < 0.0 ? WALL.W : WALL.E;
        WALL forwardVWall = headingTrig.cos < 0.0 ? WALL.S : WALL.N;
        WALL firstWall = null;
        WALL secondWall = null;
        double firstDist = Double.NaN;
        double secondDist = Double.NaN;
        if (forwardHWall == wallH && forwardVWall == wallV) {
            if (latDir > 0) {
                if (forwardHWall == WALL.W) {
                    if (forwardVWall == WALL.N) {
                        firstWall = WALL.W;
                        firstDist = distW;
                        secondWall = WALL.N;
                        secondDist = distN;
                    } else {
                        firstWall = WALL.S;
                        firstDist = distS;
                        secondWall = WALL.W;
                        secondDist = distW;
                    }
                } else if (forwardVWall == WALL.N) {
                    firstWall = WALL.N;
                    firstDist = distN;
                    secondWall = WALL.E;
                    secondDist = distE;
                } else {
                    firstWall = WALL.E;
                    firstDist = distE;
                    secondWall = WALL.S;
                    secondDist = distS;
                }
            } else if (forwardHWall == WALL.W) {
                if (forwardVWall == WALL.N) {
                    firstWall = WALL.N;
                    firstDist = distN;
                    secondWall = WALL.W;
                    secondDist = distW;
                } else {
                    firstWall = WALL.W;
                    firstDist = distW;
                    secondWall = WALL.S;
                    secondDist = distS;
                }
            } else if (forwardVWall == WALL.N) {
                firstWall = WALL.E;
                firstDist = distE;
                secondWall = WALL.N;
                secondDist = distN;
            } else {
                firstWall = WALL.S;
                firstDist = distS;
                secondWall = WALL.E;
                secondDist = distE;
            }
        } else if (forwardHWall == wallH) {
            firstWall = wallH;
            firstDist = wallH == WALL.W ? distW : distE;
        } else if (forwardVWall == wallV) {
            firstWall = wallV;
            firstDist = wallV == WALL.S ? distS : distN;
        }
        WALL smoothWall = firstWall;
        double smoothDist = firstDist;
        while (smoothWall != null) {
            double newCos;
            double newSin;
            double wallSin = (OUTER_R - smoothDist) / OUTER_R;
            if (wallSin > 1.0) {
                wallSin = 1.0;
            }
            double wallCos = Math.sqrt(1.0 - (wallSin *= (double)latDir) * wallSin);
            double newWallSin = wallSin * DELTA_COS + wallCos * DELTA_SIN * (double)latDir;
            double newWallCos = wallCos * DELTA_COS - wallSin * DELTA_SIN * (double)latDir;
            if (newWallCos > 0.0) {
                wallSin = newWallSin;
                wallCos = newWallCos;
            }
            if (smoothWall == WALL.N) {
                newSin = wallSin;
                newCos = wallCos * 1.0;
            } else if (smoothWall == WALL.E) {
                newSin = wallCos * 1.0;
                newCos = -wallSin;
            } else if (smoothWall == WALL.S) {
                newSin = -wallSin;
                newCos = -wallCos * 1.0;
            } else {
                newSin = -wallCos * 1.0;
                newCos = wallSin;
            }
            double newHeading = Math.atan2(newSin, newCos);
            if (Math.signum(Utils.normalRelativeAngle((double)(newHeading - absoluteHeading))) == (double)latDir) {
                headingTrig.sin = newSin;
                headingTrig.cos = newCos;
                absoluteHeading = newHeading;
            }
            if (smoothWall != firstWall) break;
            smoothWall = secondWall;
            smoothDist = secondDist;
        }
        return absoluteHeading;
    }

    @Target(value={ElementType.PARAMETER})
    public static @interface Output {
    }

    public static final class Trig {
        public double sin;
        public double cos;
    }

    static enum WALL {
        W,
        N,
        E,
        S;

    }
}

