/*
 * Decompiled with CFR 0.152.
 */
package areb;

import areb.ActiveEnemyWaves;
import areb.BulletNode;
import areb.EnemyWave;
import areb.EnemyWaveStats;
import areb.Util;
import areb.WaveStats;
import java.awt.Color;
import java.io.PrintStream;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Union
extends AdvancedRobot {
    private boolean circleRight = true;
    private int timeSinceLastScan = 0;
    private static PrintStream ps;
    private static RobocodeFileOutputStream rcfos;
    private static int battleCount;
    public static double wallCushion;
    public static double battleFieldWidth;
    public static double battleFieldHeight;
    public static double maxBattleFieldDistance;
    private double bulletPower;
    private static WaveStats waveStats;
    private static Vector activeBullets;
    private static EnemyWaveStats enemyWaveStats;
    private static ActiveEnemyWaves activeEnemyWaves;
    private static final boolean COLLECTING_STATS = true;
    private static final int RANDOM_TARGETING = 0;
    private static final int LINEAR_TARGETING = 1;
    private static final int STATISTIC_TARGETING = 2;
    private static int TARGETING_TYPE;
    private static final boolean logging = false;
    private double enemyAbsoluteBearing;
    private double enemyEnergy = 100.0;
    private double enemyX;
    private double enemyY;
    private double prevEnemyX;
    private double prevEnemyY;
    private double prevMyX;
    private double prevMyY;
    private double prevMyVel;
    private int prevMyAccel;
    private double previousEVel = 0.0;
    private double prevMyDist;
    private double prevMyHeading;
    private double prevMyBearing;
    private double enemyEnergyGained;
    private double enemyEnergyLost;
    private EnemyWave currentThreat;
    private double goalDistance = 600.0;
    private int tickCount = 0;
    private boolean isTC = false;
    private boolean isMC = false;
    private int currentModule;
    private static final int DAMAGE_DISTS = 3;
    private static double[] damage;
    private static double[] goalDist;
    private static double[] damageGiven;
    private static double[] damageReceived;
    public boolean runningAway = false;
    private static double[] damageGivenRound;
    private static double[] damageReceivedRound;

    public void run() {
        this.setColors(Color.yellow, Color.black, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        boolean bl = false;
        this.setEventPriority("BulletHitEvent", 90);
        this.setEventPriority("HitByBulletEvent", 90);
        activeEnemyWaves = new ActiveEnemyWaves(this.out, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        activeBullets = new Vector();
        if (++battleCount == 1) {
            battleFieldWidth = this.getBattleFieldWidth();
            battleFieldHeight = this.getBattleFieldHeight();
            waveStats = new WaveStats(this.getBattleFieldWidth(), this.getBattleFieldHeight(), false);
            enemyWaveStats = new EnemyWaveStats(this.getBattleFieldWidth(), this.getBattleFieldHeight(), false);
            maxBattleFieldDistance = Math.sqrt(this.getBattleFieldWidth() * this.getBattleFieldWidth() + this.getBattleFieldHeight() * this.getBattleFieldHeight());
        }
        boolean bl2 = false;
        while (true) {
            ++this.tickCount;
            this.doScanner();
            if (!this.isTC) {
                this.doWaveMovement();
            }
            this.execute();
        }
    }

    private void updateEnemyInfo(ScannedRobotEvent scannedRobotEvent) {
        this.enemyAbsoluteBearing = this.getHeading() + scannedRobotEvent.getBearing();
        if (this.enemyAbsoluteBearing >= 360.0) {
            this.enemyAbsoluteBearing -= 360.0;
        }
        this.timeSinceLastScan = 0;
        double d = scannedRobotEvent.getDistance() * Math.sin(Math.toRadians(this.enemyAbsoluteBearing));
        double d2 = scannedRobotEvent.getDistance() * Math.cos(Math.toRadians(this.enemyAbsoluteBearing));
        this.enemyX = this.getX() + d;
        this.enemyY = this.getY() + d2;
    }

    private int getDamageBin(double d) {
        int n = 2;
        for (int i = 0; i < 3; ++i) {
            if (!(d < damage[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    private void calculateGoalDist() {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < 3; ++i) {
            double d2 = damageGiven[i] - damageReceived[i];
            if (d2 >= 0.0) {
                bl = false;
            }
            if (!(d2 >= d)) continue;
            d = d2;
            n = i;
        }
        this.goalDistance = bl ? goalDist[n] : 600.0;
    }

    private void printRoundDamages() {
        for (int i = 1; i <= battleCount; ++i) {
            this.out.println(damageGivenRound[i] + "," + damageReceivedRound[i]);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        this.processMiss(bulletMissedEvent.getBullet());
        waveStats.addMiss();
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        waveStats.addHit();
        boolean bl = false;
        int n = 0;
        if (!bl) {
            int n2;
            BulletNode bulletNode = (BulletNode)activeBullets.get(n);
            if (bulletHitEvent.getBullet() == bulletNode.getBullet()) {
                // empty if block
            }
            bl = true;
            if (!bulletNode.hasWaveAlreadyIntersected()) {
                bulletNode.setWaveIntersected(true);
                waveStats.addWave(bulletNode.getEDist(), bulletNode.getEVel(), bulletNode.getEAccel(), bulletNode.getBPower(), bulletNode.getFwDist(), bulletNode.getBwDist(), bulletNode.getActualShotFraction());
            }
            activeBullets.remove(n);
            this.enemyEnergyLost += bulletHitEvent.getBullet().getPower() * 4.0;
            if (bulletHitEvent.getBullet().getPower() > 1.0) {
                this.enemyEnergyLost += 2.0 * (bulletHitEvent.getBullet().getPower() - 1.0);
            }
            double d = Util.distance(bulletNode.getFireX(), bulletNode.getFireY(), bulletNode.getEnemyX(), bulletNode.getEnemyY());
            int n3 = n2 = this.getDamageBin(d);
            damageGiven[n3] = damageGiven[n3] + this.enemyEnergyLost;
            int n4 = battleCount;
            damageGivenRound[n4] = damageGivenRound[n4] + this.enemyEnergyLost;
            this.calculateGoalDist();
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.processMiss(bulletHitBulletEvent.getBullet());
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.circleRight = !this.circleRight;
        EnemyWave enemyWave = activeEnemyWaves.getWhoHitMe(this.getX(), this.getY());
        this.enemyEnergyGained += hitByBulletEvent.getPower() * 3.0;
        double d = hitByBulletEvent.getPower() * 4.0;
        if (hitByBulletEvent.getPower() > 1.0) {
            d += 2.0 * (hitByBulletEvent.getPower() - 1.0);
        }
        if (enemyWave != null) {
            int n;
            double d2 = enemyWave.getAngle(this.getX(), this.getY());
            enemyWaveStats.addHit(enemyWave.getMDist(), enemyWave.getMVel(), enemyWave.getMAccel(), enemyWave.getBPower(), d2);
            double d3 = Util.distance(enemyWave.getInitX(), enemyWave.getInitY(), enemyWave.getFireX(), enemyWave.getFireY());
            int n2 = n = this.getDamageBin(d3);
            damageReceived[n2] = damageReceived[n2] + d;
            int n3 = battleCount;
            damageReceivedRound[n3] = damageReceivedRound[n3] + d;
        } else {
            int n = battleCount;
            damageReceivedRound[n] = damageReceivedRound[n] + d;
            damageReceived[0] = damageReceived[0] + d;
        }
        this.calculateGoalDist();
        this.currentThreat = null;
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.out.println("Crap I hit the wall!");
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.updateEnemyInfo(scannedRobotEvent);
        if (scannedRobotEvent.getEnergy() + 0.001 < this.enemyEnergy - this.enemyEnergyLost + this.enemyEnergyGained) {
            this.addEnemyWave(scannedRobotEvent);
        }
        this.checkActiveBullets();
        if (!this.isMC) {
            this.shoot(scannedRobotEvent);
        }
        this.enemyEnergy = scannedRobotEvent.getEnergy();
        this.previousEVel = Math.abs(scannedRobotEvent.getVelocity());
        this.prevEnemyX = this.enemyX;
        this.prevEnemyY = this.enemyY;
        this.prevMyDist = scannedRobotEvent.getDistance();
        this.prevMyX = this.getX();
        this.prevMyY = this.getY();
        this.prevMyAccel = enemyWaveStats.getMAccel(this.getVelocity(), this.prevMyVel);
        this.prevMyVel = this.getVelocity();
        this.prevMyHeading = this.getHeading();
        this.prevMyBearing = Util.getBearing(this.enemyX, this.enemyY, this.getX(), this.getY());
        this.enemyEnergyGained = 0.0;
        this.enemyEnergyLost = 0.0;
    }

    public void onWin(WinEvent winEvent) {
    }

    public void onDeath(DeathEvent deathEvent) {
    }

    private void doScanner() {
        ++this.timeSinceLastScan;
        double d = Util.getRelativeAngle(this.getRadarHeading(), this.enemyAbsoluteBearing) * 2.0;
        if (this.timeSinceLastScan > 3) {
            d = Double.POSITIVE_INFINITY;
        }
        this.setTurnRadarRight(d);
    }

    private void doWaveMovement() {
        this.currentModule = 1;
        activeEnemyWaves.advanceAllWaves();
        activeEnemyWaves.checkForPassedWaves(this.getX(), this.getY());
        double[] dArray = null;
        double[] dArray2 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (Util.distance(this.getX(), this.getY(), this.enemyX, this.enemyY) < 150.0 && this.getDistanceRemaining() < 8.0) {
            this.runningAway = true;
            double d3 = 80.0;
            int n = 9;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 1.0;
            for (int i = 0; i < n; ++i) {
                double d7;
                double d8 = -50.0 + 12.5 * (double)i;
                double d9 = this.getHeading() + d8;
                double d10 = Math.sin(d9);
                double d11 = Math.cos(d9);
                double d12 = this.getX() + d3 * d10;
                double d13 = this.getX() - d3 * d10;
                double d14 = this.getY() + d3 * d11;
                double d15 = this.getY() - d3 * d11;
                if (d12 > wallCushion && battleFieldWidth - d12 > wallCushion && d14 > wallCushion && battleFieldHeight - d14 > wallCushion && (d7 = Util.distance(d12, d14, this.enemyX, this.enemyY)) > d4) {
                    d5 = d8;
                    d6 = 1.0;
                }
                if (!(d13 > wallCushion) || !(battleFieldWidth - d13 > wallCushion) || !(d15 > wallCushion) || !(battleFieldHeight - d15 > wallCushion) || !((d7 = Util.distance(d13, d15, this.enemyX, this.enemyY)) > d4)) continue;
                d5 = d8;
                d6 = -1.0;
            }
            this.setAhead(d3 * d6);
            this.setTurnRight(d5);
        } else if (this.runningAway) {
            if (this.getDistanceRemaining() < 3.0) {
                this.runningAway = false;
            }
        } else if (activeEnemyWaves.getWaveCount() > 0) {
            EnemyWave enemyWave = activeEnemyWaves.getFurthestWave(this.getX(), this.getY());
            double d16 = this.calculateTurn(enemyWave);
            this.setTurnRight(d16);
            if (enemyWave != this.currentThreat) {
                double d17;
                int n;
                this.currentThreat = enemyWave;
                int n2 = 11;
                double[] dArray3 = new double[n2];
                double[] dArray4 = new double[n2];
                dArray = enemyWave.getMaximumExtent(this.getX(), this.getY(), this.getVelocity(), this.getHeading() + d16);
                dArray2 = enemyWave.getMinimumExtent(this.getX(), this.getY(), this.getVelocity(), this.getHeading() + d16);
                double d18 = (dArray[0] - dArray2[0]) / (double)(n2 - 1);
                for (int i = 0; i < n2; ++i) {
                    dArray3[i] = dArray2[0] + d18 * (double)i;
                }
                d2 = enemyWave.getAngle(this.getX(), this.getY());
                double d19 = this.getHeading();
                double d20 = this.getVelocity();
                int n3 = n = this.getVelocity() >= 0.0 ? 1 : -1;
                if (dArray[0] < dArray2[0]) {
                    this.out.println("Dir fucked up");
                    d17 = dArray[0];
                    dArray[0] = dArray2[0];
                    dArray2[0] = d17;
                }
                if (enemyWave.getWaveID() != -1) {
                    for (int i = 0; i < dArray3.length; ++i) {
                        if (!(dArray3[i] < dArray[0]) || !(dArray3[i] > dArray2[0])) continue;
                        dArray4[i] = enemyWaveStats.evaluate(dArray3[i], activeEnemyWaves, dArray, dArray2, this.getX(), this.getY(), this.getVelocity(), this.getHeading() + d16);
                    }
                    d17 = 0.0;
                    for (int i = 0; i < dArray4.length; ++i) {
                        if (!(dArray4[i] > d17)) continue;
                        d = dArray3[i];
                        d17 = dArray4[i];
                    }
                } else {
                    d = Math.abs(dArray[0]) > Math.abs(dArray2[0]) ? dArray[0] : dArray2[0];
                }
                d17 = Util.distance(this.getX(), this.getY(), enemyWave.getFireX(), enemyWave.getFireY());
                double d21 = d - d2;
                double d22 = 0.0;
                d22 = d21 > 0.0 ? (d - d2) * dArray[1] : (d - d2) * dArray2[1];
                this.setAhead(d22 * (double)n);
            }
        } else if (Math.abs(this.getDistanceRemaining()) < 3.0) {
            double d23 = 90.0;
            double d24 = Util.getRelativeAngle(this.prevMyBearing, this.prevMyHeading);
            if (d24 < 0.0) {
                d23 = -90.0;
            }
            double d25 = Util.projectAngle(this.prevMyBearing, this.prevMyBearing + d23, 8.0, 3.0);
            int n = this.prevMyVel >= 0.0 ? 1 : -1;
            EnemyWave enemyWave = new EnemyWave(11.0, this.enemyX, this.enemyY, this.getX(), this.getY(), Util.getBearing(this.enemyX, this.enemyY, this.getX(), this.getY()), this.getHeading(), d25, n);
            enemyWave.advanceWave();
            activeEnemyWaves.addWave(enemyWave);
        }
        this.currentModule = 0;
    }

    private double calculateTurn(EnemyWave enemyWave) {
        double d = Util.getRelativeAngle(this.getHeading(), this.enemyAbsoluteBearing);
        boolean bl = d < 0.0;
        int n = 17;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[]{-30.0, -20.0, -10.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0, 30.0};
        double d2 = -666.0;
        double d3 = 0.0;
        double d4 = Util.distance(this.getX(), this.getY(), this.enemyX, this.enemyY);
        double d5 = this.goalDistance - d4;
        double d6 = 100.0;
        if (d5 > 0.0) {
            d6 += 300.0 - Util.getDistToClosestWall(this.getX(), this.getY());
        }
        double d7 = Math.abs(d5) / d6;
        for (int i = 0; i < n; ++i) {
            double d8 = dArray4[i];
            dArray[i] = enemyWave.getMaximumExtent(this.getX(), this.getY(), this.getVelocity(), this.getHeading() + d8)[0];
            dArray2[i] = enemyWave.getMinimumExtent(this.getX(), this.getY(), this.getVelocity(), this.getHeading() + d8)[0];
            double d9 = dArray[i] - dArray2[i];
            double d10 = Math.abs(Math.abs(Util.getRelativeAngle(this.getHeading() + d8, this.enemyAbsoluteBearing)) - 90.0);
            double d11 = Math.abs(Util.getRelativeAngle(this.getHeading() + d8, this.enemyAbsoluteBearing)) - 90.0;
            if (d5 > 0.0) {
                if (this.getVelocity() < 0.0) {
                    d11 *= -1.0;
                }
            } else if (this.getVelocity() > 0.0) {
                d11 *= -1.0;
            }
            if (Math.abs(d11) > 25.0) {
                d11 = 0.0;
            }
            dArray3[i] = d11 / 90.0 * d7 + d9 - d10 * 0.011111111111111112;
            if (this.tickCount % 10 == 0) {
                // empty if block
            }
            if (!(dArray3[i] > d2)) continue;
            d2 = dArray3[i];
            d3 = d8;
        }
        if (d3 > 90.0) {
            d3 -= 180.0;
        } else if (d3 < -90.0) {
            d3 += 180.0;
        }
        return d3;
    }

    private double calculateDistanceAdjustAngle() {
        return 5.0 * Math.abs(Util.distance(this.getX(), this.getY(), this.enemyX, this.enemyY) - this.goalDistance) / 100.0;
    }

    private double adjustTurnAmount(double d, double d2, boolean bl) {
        d = Util.distance(this.getX(), this.getY(), this.enemyX, this.enemyY) > this.goalDistance ? (bl ? (this.getVelocity() > 0.0 ? (d -= d2) : (d += d2)) : (this.getVelocity() > 0.0 ? (d += d2) : (d -= d2))) : (bl ? (this.getVelocity() > 0.0 ? (d += d2) : (d -= d2)) : (this.getVelocity() > 0.0 ? (d -= d2) : (d += d2)));
        return d;
    }

    private void addEnemyWave(ScannedRobotEvent scannedRobotEvent) {
        double d = this.enemyEnergy - this.enemyEnergyLost + this.enemyEnergyGained - scannedRobotEvent.getEnergy();
        int n = enemyWaveStats.getMDist(this.prevMyDist);
        int n2 = enemyWaveStats.getMVel(this.prevMyVel);
        int n3 = this.prevMyAccel;
        int n4 = enemyWaveStats.getBPower(d);
        double d2 = 20.0 - 3.0 * d;
        double[] dArray = enemyWaveStats.getMoveGuess(n, n2, n3, n4);
        double d3 = 90.0;
        double d4 = Util.getRelativeAngle(this.prevMyBearing, this.prevMyHeading);
        if (d4 < 0.0) {
            d3 = -90.0;
        }
        double d5 = Util.projectAngle(this.prevMyBearing, this.prevMyBearing + d3, 8.0, d);
        if (d + 0.001 >= 0.1 && d - 0.001 <= 3.0) {
            int n5 = this.prevMyVel >= 0.0 ? 1 : -1;
            EnemyWave enemyWave = new EnemyWave(n, n2, n3, n4, d2, this.prevEnemyX, this.prevEnemyY, this.prevMyX, this.prevMyY, this.prevMyBearing, this.prevMyHeading, d5, dArray, n5);
            activeEnemyWaves.addWave(enemyWave);
        }
    }

    private boolean isXInPlay(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = this.getHeading();
        if (this.getVelocity() < 0.0) {
            d6 += 180.0;
        }
        return (d5 = (d4 = d * Math.sin(Math.toRadians(d3 = d6 + d2))) + this.getX()) > wallCushion && d5 < this.getBattleFieldWidth() - wallCushion;
    }

    private boolean isYInPlay(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = this.getHeading();
        if (this.getVelocity() < 0.0) {
            d6 += 180.0;
        }
        return (d5 = (d4 = d * Math.cos(Math.toRadians(d3 = d6 + d2))) + this.getY()) > wallCushion && d5 < this.getBattleFieldHeight() - wallCushion;
    }

    private void checkActiveBullets() {
        for (int i = 0; i < activeBullets.size(); ++i) {
            BulletNode bulletNode = (BulletNode)activeBullets.get(i);
            if (bulletNode.hasWaveAlreadyIntersected() || !bulletNode.hasWaveIntersected(this.enemyX, this.enemyY)) continue;
            double d = bulletNode.calculateWaveIntersect(this.enemyX, this.enemyY);
            waveStats.addWave(bulletNode.getEDist(), bulletNode.getEVel(), bulletNode.getEAccel(), bulletNode.getBPower(), bulletNode.getFwDist(), bulletNode.getBwDist(), d);
        }
    }

    private void calculatePower(double d, double d2) {
        if (d < 75.0) {
            this.bulletPower = 3.0;
        } else {
            double d3 = (maxBattleFieldDistance - d) / maxBattleFieldDistance;
            double d4 = this.getEnergy() / 100.0;
            double d5 = 1.0 + 2.0 * Math.abs((this.getEnergy() - d2) / this.getEnergy());
            double d6 = 1.0;
            this.bulletPower = 3.0 * d3 * d4 * d5 * d6;
            if (Double.isNaN(this.bulletPower)) {
                this.bulletPower = 1.0;
            }
        }
        if (this.bulletPower > 3.0) {
            this.bulletPower = 3.0;
        } else if (this.bulletPower < 0.1) {
            this.bulletPower = 0.1;
        }
        if (this.bulletPower > d2 / 4.0) {
            this.bulletPower = d2 / 4.0;
        }
        if (this.bulletPower > this.getEnergy() / 5.0) {
            this.bulletPower = this.getEnergy() / 5.0;
        }
    }

    private void shoot(ScannedRobotEvent scannedRobotEvent) {
        double d;
        this.currentModule = 2;
        if (this.isTC) {
            this.bulletPower = 3.0;
        } else {
            this.calculatePower(scannedRobotEvent.getDistance(), scannedRobotEvent.getEnergy());
        }
        double d2 = Util.getRelativeAngle(this.getGunHeading(), this.enemyAbsoluteBearing);
        double d3 = 90.0;
        double d4 = scannedRobotEvent.getHeading();
        if (scannedRobotEvent.getVelocity() < 0.0) {
            d4 = scannedRobotEvent.getHeading() <= 180.0 ? (d4 += 180.0) : (d4 -= 180.0);
        }
        if ((d = Util.getRelativeAngle(this.enemyAbsoluteBearing, d4)) < 0.0) {
            d3 = -90.0;
        }
        double d5 = Util.projectAngle(this.enemyAbsoluteBearing, this.enemyAbsoluteBearing + d3, 8.0, this.bulletPower);
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl = false;
        double d8 = Util.getDistanceToWall(this.enemyX, this.enemyY, d4);
        double d9 = Util.getDistanceToWall(this.enemyX, this.enemyY, Util.correctLargeAngle(d4 + 180.0));
        int n = waveStats.getEDist(scannedRobotEvent.getDistance());
        int n2 = waveStats.getEVel(Math.abs(scannedRobotEvent.getVelocity()));
        int n3 = waveStats.getEAccel(Math.abs(scannedRobotEvent.getVelocity()), this.previousEVel);
        int n4 = waveStats.getBPower(this.bulletPower);
        int n5 = waveStats.getFwDist(d8);
        int n6 = waveStats.getBwDist(d9);
        double[] dArray = waveStats.getShotGuess(n, n2, n3, n4, n5, n6);
        int n7 = 0;
        if (dArray.length == 2) {
            this.out.println("Using Last 5 Shots!");
        }
        do {
            if (this.enemyX == this.prevEnemyX && this.enemyY == this.prevEnemyY && scannedRobotEvent.getEnergy() <= 0.1) {
                d6 = 0.0;
                d7 = d2;
                bl = true;
                continue;
            }
            if (TARGETING_TYPE == 0) {
                d6 = Math.random() * 2.0 - 1.0;
                d7 = d2 + d5 * d6;
                bl = true;
                continue;
            }
            if (TARGETING_TYPE == 1) {
                d6 = 1.0;
                d7 = d2 + d5 * d6;
                bl = true;
                continue;
            }
            if (TARGETING_TYPE != 2) continue;
            d6 = dArray[n7];
            ++n7;
            d7 = d2 + d5 * d6;
            bl = this.isValidShot(this.enemyAbsoluteBearing, this.enemyAbsoluteBearing + d3, scannedRobotEvent.getDistance(), 8.0 * d6, this.getGunHeading() + d7, d5);
        } while (!bl);
        if (this.getGunHeat() == 0.0 && this.getEnergy() > 0.0 && Math.abs(this.getGunTurnRemaining()) < 2.0) {
            activeBullets.add(new BulletNode(this.setFireBullet(this.bulletPower), n, n2, n3, n4, n5, n6, this.getX(), this.getY(), this.enemyX, this.enemyY, d4, this.enemyAbsoluteBearing, d5, d6));
        } else if (this.getGunHeat() > 0.0) {
            this.setTurnGunRight(d7);
        }
        this.currentModule = 0;
    }

    private boolean isValidShot(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.enemyX;
        double d8 = this.enemyY;
        double d9 = d4 * Math.sin(Math.toRadians(d2));
        double d10 = d4 * Math.cos(Math.toRadians(d2));
        double d11 = 20.0 - 3.0 * this.bulletPower;
        double d12 = d11 * Math.sin(Math.toRadians(d5));
        double d13 = d11 * Math.cos(Math.toRadians(d5));
        double d14 = this.getX();
        boolean bl = false;
        for (double d15 = this.getY(); d14 < this.getBattleFieldWidth() && d14 > 0.0 && d15 < this.getBattleFieldHeight() && d15 > 0.0; d14 += d12, d15 += d13) {
            d7 += d9;
            d8 += d10;
            if (!(Math.abs(d14 - d7) < this.getWidth() / 2.0) || !(Math.abs(d15 - d8) < this.getHeight() / 2.0)) continue;
            return true;
        }
        return false;
    }

    private void processMiss(Bullet bullet) {
        boolean bl = false;
        for (int i = 0; !bl && i < activeBullets.size(); ++i) {
            BulletNode bulletNode = (BulletNode)activeBullets.get(i);
            if (bullet == bulletNode.getBullet()) {
                // empty if block
            }
            bl = true;
            activeBullets.remove(i);
        }
    }

    static {
        battleCount = 0;
        wallCushion = 18.0;
        TARGETING_TYPE = 2;
        damage = new double[]{300.0, 500.0, Double.POSITIVE_INFINITY};
        goalDist = new double[]{200.0, 400.0, 600.0};
        damageGiven = new double[3];
        damageReceived = new double[3];
        damageGivenRound = new double[10000];
        damageReceivedRound = new double[10000];
    }
}

