/*
 * Decompiled with CFR 0.152.
 */
package mmb;

import mmb.AbstractBehavior;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Rules;

public class BrownianMotion
extends AbstractBehavior {
    private boolean direction = true;
    private double currentLength = 0.0;
    private double length = 40.0;
    private double angle = 90.0;
    private double currentPositionX = 0.0;
    private double currentPositionY = 0.0;
    private double previousPositionX = 0.0;
    private double previousPositionY = 0.0;
    private double battleFieldHeight = 0.0;
    private double battleFieldWidth = 0.0;

    public BrownianMotion(AdvancedRobot robot) {
        super(robot);
    }

    @Override
    protected void setBodyAction() {
        this.avoidWall();
        if (this.currentLength > this.length) {
            this.robot.setTurnRight(this.angle);
            this.angle = this.random.nextFloat() * 180.0f - 90.0f;
            this.length = this.random.nextFloat() * 20.0f + 20.0f;
            this.currentLength = 0.0;
        }
        if (this.direction) {
            this.robot.setAhead(100.0);
        } else {
            this.robot.setAhead(-100.0);
        }
        this.currentLength += 1.0;
    }

    private void reverseDirection() {
        this.direction = !this.direction;
    }

    @Override
    protected void setGunAction() {
    }

    @Override
    protected void setRadarAction() {
        double radarTurningAngle = 0.0;
        double gunTurningAngle = 0.0;
        double triangulation = 0.0;
        double bulletPower = 0.0;
        double bulletVelocity = 0.0;
        bulletPower = this.enemyDistance < 100.0 ? 3.0 : (this.enemyDistance < 200.0 ? 2.0 : (this.enemyDistance < 500.0 ? 1.0 : 0.0));
        bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
        if (this.enemyLocked) {
            radarTurningAngle = this.calcolateRadarTurningAngle();
            gunTurningAngle = this.calcolateGunTurningAngle();
        } else {
            radarTurningAngle = 90.0;
        }
        triangulation = this.calcolateTriangulation(bulletVelocity);
        this.robot.setTurnRadarRight(radarTurningAngle);
        this.robot.setTurnGunRight(gunTurningAngle + triangulation + this.getRandomOffset());
        if (Math.abs(gunTurningAngle + triangulation) <= 5.0 && this.robot.getGunHeat() == 0.0 && bulletPower > 0.0) {
            Bullet bullet = null;
            bullet = this.robot.setFireBullet(bulletPower);
        }
    }

    private void avoidWall() {
        this.battleFieldHeight = this.robot.getBattleFieldHeight();
        this.battleFieldWidth = this.robot.getBattleFieldWidth();
        this.currentPositionX = this.robot.getX();
        this.currentPositionY = this.robot.getY();
        if (this.currentPositionX < this.previousPositionX && this.currentPositionX < 100.0 && !(this.currentPositionY < 100.0) && !(this.currentPositionY > this.battleFieldHeight - 100.0)) {
            this.reverseDirection();
        }
        if (this.currentPositionX > this.previousPositionX && this.currentPositionX > this.battleFieldWidth - 100.0 && !(this.currentPositionY < 100.0) && !(this.currentPositionY > this.battleFieldHeight - 100.0)) {
            this.reverseDirection();
        }
        if (this.currentPositionY < this.previousPositionY && this.currentPositionY < 100.0 && !(this.currentPositionX < 100.0) && !(this.currentPositionX > this.battleFieldWidth - 100.0)) {
            this.reverseDirection();
        }
        if (this.currentPositionY > this.previousPositionY && this.currentPositionY > this.battleFieldHeight - 100.0 && !(this.currentPositionX < 100.0) && !(this.currentPositionX > this.battleFieldWidth - 100.0)) {
            this.reverseDirection();
        }
        this.previousPositionX = this.currentPositionX;
        this.previousPositionY = this.currentPositionY;
    }
}

