/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Area;
import et.EtMath;
import et.Location;
import robocode.AdvancedRobot;

abstract class EtRobot
extends AdvancedRobot {
    public double direction = 1.0;
    private Location myPosition = new Location();
    public static Area battleField;

    EtRobot() {
    }

    protected void initialize() {
        battleField = new Area(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }

    public final double getAngleToLocationFromHeading(double d, double d2, double d3) {
        double d4 = -1.0;
        double d5 = this.getX();
        double d6 = this.getY();
        d4 = Math.toDegrees(Math.atan(Math.abs(d5 - d) / Math.abs(d6 - d2)));
        if (d5 >= d && d6 >= d2) {
            d4 = 180.0 + d4;
        } else if (d5 >= d && d6 < d2) {
            d4 = 360.0 - d4;
        } else if (d5 < d && d6 >= d2) {
            d4 = 180.0 - d4;
        }
        return EtMath.normalRelativeAngle(d4 - d3);
    }

    public final double getAngleToLocationFromHeading(Location location, double d) {
        return this.getAngleToLocationFromHeading(location.getX(), location.getY(), d);
    }

    public final double getAngleToLocation(Location location) {
        return this.getAngleToLocation(location.getX(), location.getY());
    }

    public final double getAngleToLocation(double d, double d2) {
        double d3 = this.getHeading(false);
        if (this.direction == -1.0) {
            d3 = EtMath.normalAbsoluteAngle(d3 + 180.0);
        }
        return this.getAngleToLocationFromHeading(d, d2, d3);
    }

    public static final double getAngleToLocationFromLocation(Location location, Location location2) {
        double d = -1.0;
        d = Math.toDegrees(Math.atan(Math.abs(location2.getX() - location.getX()) / Math.abs(location2.getY() - location.getY())));
        if (location2.getX() >= location.getX() && location2.getY() >= location.getY()) {
            d = 180.0 + d;
        } else if (location2.getX() >= location.getX() && location2.getY() < location.getY()) {
            d = 360.0 - d;
        } else if (location2.getX() < location.getX() && location2.getY() >= location.getY()) {
            d = 180.0 - d;
        }
        return EtMath.normalRelativeAngle(d);
    }

    public final double timeSince(double d) {
        return (double)this.getTime() - d;
    }

    public final Location getPosition() {
        this.myPosition.setLocation(this.getX(), this.getY());
        return this.myPosition;
    }

    public final double getHeading(boolean bl) {
        double d = this.getHeading();
        if (bl && this.direction == -1.0) {
            d = EtMath.normalAbsoluteAngle(d + 180.0);
        }
        return d;
    }

    public final double getTurnRate() {
        return 4.0 + 6.0 * (1.0 - Math.abs(this.getVelocity()) / 8.0);
    }
}

