/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.enemy;

import dmh.robocode.data.CauseAndEffect;
import dmh.robocode.data.CompleteMovementSequence;
import dmh.robocode.data.DynamicMovementSequence;

public class EnemyRobotMovementAnalyser {
    static int causeLength = 20;
    static int effectLength = 20;
    private CauseAndEffect<CompleteMovementSequence, CompleteMovementSequence> prototypeCauseAndEffectInfo = new CauseAndEffect();

    void notifyNewMovement(DynamicMovementSequence currentMovementSequence, long timeNow) {
        if (currentMovementSequence.getLength() >= causeLength + effectLength) {
            CompleteMovementSequence cause = new CompleteMovementSequence(currentMovementSequence, timeNow + 1L - (long)causeLength - (long)effectLength, timeNow - (long)effectLength);
            CompleteMovementSequence effect = new CompleteMovementSequence(currentMovementSequence, timeNow + 1L - (long)effectLength, timeNow);
            this.prototypeCauseAndEffectInfo.record(cause, effect);
        }
    }

    public void resetForNextRound() {
        this.prototypeCauseAndEffectInfo.purge(100);
    }

    public Prediction predictNextMoves(DynamicMovementSequence allRecentMovements, long currentTime) {
        CompleteMovementSequence cause = new CompleteMovementSequence(allRecentMovements, currentTime + 1L - (long)causeLength, currentTime);
        CompleteMovementSequence effect = this.prototypeCauseAndEffectInfo.getMostLikelyEffectOf(cause);
        double probability = this.prototypeCauseAndEffectInfo.getProbabilityOf(cause, effect);
        return new Prediction(effect, probability);
    }

    public class Prediction {
        private CompleteMovementSequence sequence;
        double probability;

        public Prediction(CompleteMovementSequence sequence, double probability) {
            this.sequence = sequence;
            this.probability = probability;
        }

        public double getProbability() {
            return this.probability;
        }

        public CompleteMovementSequence getSequence() {
            return this.sequence;
        }
    }
}

