/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import justin.BulletM;
import justin.Movement3;
import justin.MyUtils;
import justin.RandomMoveD;
import justin.RandomMovement;
import justin.Scan;
import justin.ScannerV2;
import justin.Tank;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Mallais
extends AdvancedRobot {
    static Rectangle2D battleField;
    static ArrayList<Tank> tank;
    static ArrayList<BulletM> bulletList;
    static Tank myTank;
    static Scan myData;
    static Tank target;
    static Scan targetScan;
    ScannerV2 scan;
    static double radarDirection;
    RandomMovement movement1;
    RandomMoveD movement2;
    Movement3 movement;
    boolean startup;
    static final double PI = Math.PI;
    static long scanCounter;
    static long missedScansCounter;
    static long totalTime;
    static final boolean DRAW = true;

    static {
        scanCounter = 0L;
        missedScansCounter = 0L;
        totalTime = 0L;
    }

    public void run() {
        battleField = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setColors(new Color(152, 90, 90), new Color(131, 106, 89), new Color(84, 140, 83));
        this.setScanColor(Color.white);
        if (tank == null) {
            tank = new ArrayList();
            Tank.updateSelf(this);
        } else {
            Tank.newRound();
        }
        target = null;
        targetScan = null;
        bulletList = new ArrayList();
        this.scan = new ScannerV2(this);
        this.movement = new Movement3(this);
        this.movement.init();
        this.movement1 = new RandomMovement(this);
        this.movement2 = new RandomMoveD(this);
        this.movement2.initRound();
        radarDirection = Math.signum(Utils.normalRelativeAngle((double)(MyUtils.absbearing(this.getX(), this.getY(), this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0) - this.getRadarHeadingRadians())));
        if (radarDirection == 0.0) {
            radarDirection = 1.0;
        }
        this.setTurnGunRightRadians(1.5707963267948966 * radarDirection);
        this.setTurnRadarRightRadians(radarDirection * Double.POSITIVE_INFINITY);
        this.startup = true;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            Tank.updateSelf(this);
            if (!this.startup) {
                BulletM.removeOldBullets(this);
                if (target != null) {
                    this.getTarget();
                    Mallais.target.gun.execute();
                }
                if (this.getTime() > 20L) {
                    Tank.updateWaves(this);
                }
                this.scan.scan();
                this.movement.move();
            } else if (Tank.allBotsAlive() & tank.size() > this.getOthers()) {
                this.startup = false;
                this.out.println(" initialized..");
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++scanCounter;
        Tank.update(e, this);
        this.scan.update(e);
        Tank.get((String)e.getName()).gun.update(e);
        this.movement2.update(e);
        if (!this.startup) {
            BulletM.onScanBot(e, this);
        }
    }

    public void onWin(WinEvent e) {
        double sp = Math.round((double)scanCounter * 1000.0 / ((double)(totalTime += this.getTime()) * 10.0));
        double sp2 = Math.round((double)missedScansCounter * 1000.0 / ((double)totalTime * 10.0));
        this.out.println(" scanner Performance: " + sp + "% and missed scans :" + sp2 + "%");
    }

    public void onDeath(DeathEvent e) {
        double sp = Math.round((double)scanCounter * 1000.0 / ((double)(totalTime += this.getTime()) * 10.0));
        double sp2 = Math.round((double)missedScansCounter * 1000.0 / ((double)totalTime * 10.0));
        this.out.println(" scanner Performance: " + sp + "% and missed scans :" + sp2 + "%");
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Tank.get((String)e.getName()).alive = false;
        Tank.get((String)e.getName()).gun.cleanUpRound();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Tank.iWasHit(e);
    }

    public Tank getTarget() {
        target = Tank.get(Mallais.target.name);
        targetScan = Tank.getScan(Mallais.target.name, 0);
        double bestScore = Double.POSITIVE_INFINITY;
        int q = 1;
        while (q < tank.size()) {
            Tank t = tank.get(q);
            if (t.alive) {
                Scan s = t.scanList.get(t.scanList.size() - 1);
                double score = s.distance * (s.energy / 300.0 + 1.0);
                if (s.name == Mallais.target.name) {
                    score *= 0.75;
                }
                if (this.getOthers() < 4) {
                    score *= s.energy / 400.0 + 1.0;
                }
                if (s.closestBotName == this.getName()) {
                    score *= 0.85;
                }
                double threat = t.threatLevel / 15.0 + 1.0;
                int dist = (int)s.smallestDistance;
                if ((score /= threat) < bestScore & this.getGunHeat() / this.getGunCoolingRate() > 6.0 | !Mallais.target.alive | this.getTime() - Mallais.targetScan.scanTime > 20L) {
                    target = t;
                    targetScan = s;
                    bestScore = score;
                }
            }
            ++q;
        }
        return target;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double velocity(double _firePower) {
        return 20.0 - 3.0 * _firePower;
    }
}

