/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.RobotSnapshots;

import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Utils.RuleUtils;
import robocode.util.Utils;

public class RobotSnapshotUtils {
    public static void FillInSnapshot(RobotSnapshot snapshot, int round, long tick, double x, double y, double velocity, double absHeading, double targetX, double targetY, double energy, RobotSnapshots previousSnapshots) {
        long minPreviousSnapshotTick = Math.max(0L, tick - (long)previousSnapshots.Capacity());
        snapshot.Round = round;
        snapshot.Tick = tick;
        snapshot.LocationX = x;
        snapshot.LocationY = y;
        snapshot.TargetX = targetX;
        snapshot.TargetY = targetY;
        snapshot.AbsoluteHeading = absHeading;
        snapshot.AbsoluteHeadingAlongVelocityVector = Utils.normalAbsoluteAngle((double)(absHeading + (Math.signum(velocity) >= 0.0 ? 0.0 : Math.PI)));
        snapshot.VelocityAlongHeading = velocity;
        snapshot.AbsoluteVelocity = Math.abs(velocity);
        snapshot.AbsoluteAngleFromOpponent = MathUtils.GetAngle(targetX, targetY, x, y);
        snapshot.Energy = energy;
        double diffX = x - targetX;
        double diffY = y - targetY;
        snapshot.DistanceToItsTarget = Math.sqrt(diffX * diffX + diffY * diffY);
        double previousVelocity = 0.0;
        double previousAbsoluteVelocity = 0.0;
        double previousX = targetX;
        double previousY = targetY;
        double previousRotationDirectionToTarget = 1.0;
        double previousLateralVelocity = 0.0;
        double previousAdvancingVelocity = 0.0;
        long previousTicksAtZeroVelocity = 0L;
        long previousTicksAtMaxVelocity = 0L;
        long previousTicksSinceZeroVelocity = 0L;
        long previousTicksSinceDirectionChange = 0L;
        long previousTicksSinceDecceleration = 0L;
        if (tick > 0L && minPreviousSnapshotTick <= tick - 1L) {
            RobotSnapshot previousSnapshot = previousSnapshots.Read(tick - 1L);
            previousVelocity = previousSnapshot.VelocityAlongHeading;
            previousAbsoluteVelocity = previousSnapshot.AbsoluteVelocity;
            previousX = previousSnapshot.LocationX;
            previousY = previousSnapshot.LocationY;
            previousRotationDirectionToTarget = previousSnapshot.RotationDirectionToTarget;
            previousTicksAtZeroVelocity = previousSnapshot.TicksAtZeroVelocity;
            previousTicksAtMaxVelocity = previousSnapshot.TicksAtMaxVelocity;
            previousTicksSinceZeroVelocity = previousSnapshot.TicksSinceZeroVelocity;
            previousTicksSinceDirectionChange = previousSnapshot.TicksSinceDirectionChange;
            previousTicksSinceDecceleration = previousSnapshot.TicksSinceDecceleration;
            previousLateralVelocity = previousSnapshot.LateralVelocity;
            previousAdvancingVelocity = previousSnapshot.AdvancingVelocity;
        }
        snapshot.AccelerationAlongHeading = velocity - previousVelocity;
        snapshot.AccelerationAlongHeading = Math.max(Math.min(snapshot.AccelerationAlongHeading, 2.0), -2.0);
        snapshot.AccelerationAlongVelocityVector = snapshot.AccelerationAlongHeading * Math.signum(snapshot.VelocityAlongHeading);
        double prevAngle = MathUtils.GetAngle(targetX, targetY, previousX, previousY);
        prevAngle = Utils.normalAbsoluteAngle((double)prevAngle);
        double diff = snapshot.AbsoluteAngleFromOpponent - prevAngle;
        diff = Utils.normalRelativeAngle((double)diff);
        double newDirection = 1.0;
        if (Utils.isNear((double)0.0, (double)diff) || Math.abs(velocity) < 1.0) {
            newDirection = previousRotationDirectionToTarget;
        } else if (diff < 0.0) {
            newDirection = -1.0;
        }
        snapshot.RotationDirectionToTarget = newDirection;
        double velocityDirection = Math.signum(snapshot.VelocityAlongHeading);
        if (Utils.isNear((double)velocityDirection, (double)0.0)) {
            velocityDirection = 1.0;
        }
        double targetDirectionX = MathUtils.FastSin(absHeading) * velocityDirection;
        double targetDirectionY = MathUtils.FastCos(absHeading) * velocityDirection;
        snapshot.DistanceToWallAlongVelocityVector = RuleUtils.GetDistanceToWall(x, y, targetDirectionX, targetDirectionY, 1.0);
        snapshot.DistanceToWallBehindVelocityVector = RuleUtils.GetDistanceToWall(x, y, -targetDirectionX, -targetDirectionY, 1.0);
        if (Utils.isNear((double)snapshot.AbsoluteVelocity, (double)0.0) || previousRotationDirectionToTarget != snapshot.RotationDirectionToTarget) {
            snapshot.TicksAtZeroVelocity = previousTicksAtZeroVelocity + 1L;
            snapshot.TicksAtMaxVelocity = 0L;
            snapshot.TicksSinceZeroVelocity = 0L;
        } else if (Utils.isNear((double)snapshot.AbsoluteVelocity, (double)8.0)) {
            snapshot.TicksAtZeroVelocity = 0L;
            snapshot.TicksAtMaxVelocity = previousTicksAtMaxVelocity + 1L;
            snapshot.TicksSinceZeroVelocity = previousTicksSinceZeroVelocity + 1L;
        } else {
            snapshot.TicksAtZeroVelocity = 0L;
            snapshot.TicksAtMaxVelocity = 0L;
            snapshot.TicksSinceZeroVelocity = previousTicksSinceZeroVelocity + 1L;
        }
        snapshot.TicksSinceDirectionChange = snapshot.AbsoluteVelocity > 0.0 && previousRotationDirectionToTarget != snapshot.RotationDirectionToTarget ? 0L : previousTicksSinceDirectionChange + 1L;
        snapshot.TicksSinceDecceleration = snapshot.AbsoluteVelocity < previousAbsoluteVelocity ? 0L : previousTicksSinceDecceleration + 1L;
        long previous10Tick = Math.max(minPreviousSnapshotTick, tick - 10L);
        RobotSnapshot previous10Snapshot = previousSnapshots.Read(previous10Tick);
        double previous10dX = x - previous10Snapshot.LocationX;
        double previous10dY = y - previous10Snapshot.LocationY;
        snapshot.DistanceLast10 = Math.sqrt(previous10dX * previous10dX + previous10dY * previous10dY);
        long previous20Tick = Math.max(minPreviousSnapshotTick, tick - 20L);
        RobotSnapshot previous20Snapshot = previousSnapshots.Read(previous20Tick);
        double previous20dX = x - previous20Snapshot.LocationX;
        double previous20dY = y - previous20Snapshot.LocationY;
        snapshot.DistanceLast20 = Math.sqrt(previous20dX * previous20dX + previous20dY * previous20dY);
        snapshot.LateralVelocity = Math.abs(velocity * Math.sin(absHeading - snapshot.AbsoluteAngleFromOpponent));
        snapshot.AdvancingVelocity = velocity * -Math.cos(absHeading - snapshot.AbsoluteAngleFromOpponent);
        snapshot.LateralAcceleration = snapshot.LateralVelocity - previousLateralVelocity;
        snapshot.AdvancingAcceleration = snapshot.AdvancingVelocity - previousAdvancingVelocity;
    }
}

