/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.Wraith.DangerPrediction.CachedVelocityData;
import rdt.Wraith.EnemyPrediction.EnemyPredictionManager;
import rdt.Wraith.Guns.AimAtTargetMode;
import rdt.Wraith.Guns.ClosestTargetMode;
import rdt.Wraith.Guns.FinisherMode;
import rdt.Wraith.Guns.RaikoGun;
import rdt.Wraith.IBattleEndedEventHandler;
import rdt.Wraith.IBulletHitBulletEventHandler;
import rdt.Wraith.IBulletHitEventHandler;
import rdt.Wraith.IDebugDrawer;
import rdt.Wraith.IHitByBulletEventHandler;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRobotDeathEventHandler;
import rdt.Wraith.IRoundEndedEventHandler;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.IScannedRobotEventHandler;
import rdt.Wraith.Movement.DangerPredictionMode;
import rdt.Wraith.Movement.LowEffortMode;
import rdt.Wraith.Profiling.Profiler;
import rdt.Wraith.Radar.FindAnyTargetMode;
import rdt.Wraith.Radar.FocusTargetMode;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshotUtils;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.Average;
import rdt.Wraith.Stats.Counter;
import rdt.Wraith.Stats.Max;
import rdt.Wraith.Stats.Stats;
import rdt.Wraith.SubsystemManager;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Targeting.Targeting;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Utils.RuleUtils;
import rdt.Wraith.Waves.EnemyWaveManager;
import rdt.Wraith.Waves.FriendlyWaveManager;
import rdt.Wraith.Waves.IWaveManager;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.util.Utils;

public class Wraith
extends AdvancedRobot
implements IRobot {
    private static SubsystemManager _radarSubsystem;
    private static SubsystemManager _targetingSubsystem;
    private static SubsystemManager _movementSubsystems;
    private static SubsystemManager _gunSubsystem;
    private static IWaveManager _friendlyWaveManager;
    private static IWaveManager _enemyWaveManager;
    private static ITargeting _targeting;
    private static EnemyPredictionManager _enemyPredictionManager;
    private static RobotSnapshots _ownSnapshots;
    private static Profiler _profiler;
    private static Stats _stats;
    private static ArrayList<IScannedRobotEventHandler> _scannedRobotEventHandlers;
    private static ArrayList<IRobotDeathEventHandler> _robotDeathEventHandlers;
    private static ArrayList<IRoundStartedEventHandler> _roundStartedEventHandlers;
    private static ArrayList<IRoundEndedEventHandler> _roundEndedEventHandlers;
    private static ArrayList<IBulletHitEventHandler> _bulletHitEventHandlers;
    private static ArrayList<IHitByBulletEventHandler> _hitByBulletEventHandlers;
    private static ArrayList<IBulletHitBulletEventHandler> _bulletHitBulletEventHandlers;
    private static ArrayList<IBattleEndedEventHandler> _battleEndedEventHandlers;
    private static ArrayList<IDebugDrawer> _debugDrawers;
    private static double _botSizeMax;
    private static long _maxPredictedTick;
    private static long _lastWrittenSnapshot;
    private static Counter _skippedTurnsCounter;
    private static Counter _hitWallCounter;
    private static Counter _hitEnemyCounter;
    private static Average _averageTurnCount;
    private static Max _maxTurnCount;
    private static RaikoGun _raikoGun;
    private static long _absoluteTime;
    private double _lastFiredFirepower = 0.0;

    @Override
    public double getBotSizeMax() {
        return _botSizeMax;
    }

    public void run() {
        this.Initialise();
        while (true) {
            Profiler.StartScope("Main Loop");
            ++_absoluteTime;
            this.RecordOurSnapshot();
            _targetingSubsystem.Update();
            _radarSubsystem.Update();
            _friendlyWaveManager.Update();
            if (_enemyWaveManager != null) {
                _enemyWaveManager.Update();
            }
            if (_enemyPredictionManager != null) {
                _enemyPredictionManager.Update();
            }
            if (_movementSubsystems != null) {
                _movementSubsystems.Update();
            }
            if (_raikoGun == null && _gunSubsystem != null) {
                _gunSubsystem.Update();
            }
            Profiler.EndScope();
            this.execute();
        }
    }

    private void Initialise() {
        if (_stats == null) {
            _stats = new Stats(this);
            _stats.RegisterStat(_skippedTurnsCounter);
            _stats.RegisterStat(_hitWallCounter);
            _stats.RegisterStat(_hitEnemyCounter);
            _stats.RegisterStat(_averageTurnCount);
            _stats.RegisterStat(_maxTurnCount);
        }
        if (_raikoGun == null) {
            // empty if block
        }
        this.setColors(Color.darkGray, Color.white, Color.gray);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        _botSizeMax = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        RuleUtils.Initialise(this);
        CachedVelocityData.Initialise();
        MathUtils.FastSin(0.0);
        MathUtils.FastCos(0.0);
        if (_profiler == null) {
            _profiler = new Profiler(this);
        }
        if (_ownSnapshots == null) {
            _ownSnapshots = new RobotSnapshots();
        }
        _ownSnapshots.OnRoundStart(this.getRoundNum());
        if (_targeting == null) {
            _targeting = new Targeting(this, _stats);
        }
        if (_radarSubsystem == null) {
            _radarSubsystem = new SubsystemManager("Radar");
            _radarSubsystem.AddMode(new FindAnyTargetMode(this, _targeting));
            _radarSubsystem.AddMode(new FocusTargetMode(this, _targeting));
        }
        if (_targetingSubsystem == null) {
            _targetingSubsystem = new SubsystemManager("Targeting");
            _targetingSubsystem.AddMode(new rdt.Wraith.Targeting.ClosestTargetMode(_targeting));
        }
        if (_friendlyWaveManager == null) {
            _friendlyWaveManager = new FriendlyWaveManager(this, _targeting);
        }
        if (_enemyWaveManager == null) {
            _enemyWaveManager = new EnemyWaveManager(this, _targeting);
            _targeting.SetWaveManagers(_friendlyWaveManager, _enemyWaveManager);
        }
        if (_enemyPredictionManager == null) {
            _enemyPredictionManager = new EnemyPredictionManager(this, _targeting, _enemyWaveManager);
        }
        if (_movementSubsystems == null) {
            _movementSubsystems = new SubsystemManager("Movement");
            _movementSubsystems.AddMode(new DangerPredictionMode(this, _targeting, _enemyPredictionManager, _stats));
            _movementSubsystems.AddMode(new LowEffortMode(_enemyPredictionManager, _targeting, this));
        }
        if (_gunSubsystem == null) {
            _gunSubsystem = new SubsystemManager("Gun");
            _gunSubsystem.AddMode(new ClosestTargetMode(this, _targeting, _friendlyWaveManager));
            _gunSubsystem.AddMode(new AimAtTargetMode(this, _targeting));
            _gunSubsystem.AddMode(new FinisherMode(this, _targeting));
        }
        _lastWrittenSnapshot = -1L;
        this._lastFiredFirepower = 0.0;
        this.SetMaxPredictedTick(0L);
        this.RecordOurSnapshot();
        for (int index = 0; index < _roundStartedEventHandlers.size(); ++index) {
            _roundStartedEventHandlers.get(index).OnRoundStartedEvent();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        for (int index = 0; index < _scannedRobotEventHandlers.size(); ++index) {
            _scannedRobotEventHandlers.get(index).OnScannedRobotEvent(event);
        }
        if (_raikoGun != null) {
            _raikoGun.onScannedRobot(event);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        _skippedTurnsCounter.Increment();
    }

    public void onHitWall(HitWallEvent event) {
        _hitWallCounter.Increment();
    }

    public void onRobotDeath(RobotDeathEvent event) {
        for (int index = 0; index < _robotDeathEventHandlers.size(); ++index) {
            _robotDeathEventHandlers.get(index).OnRobotDeathEvent(event);
        }
    }

    public void onRoundEnded(RoundEndedEvent event) {
        for (int index = 0; index < _roundEndedEventHandlers.size(); ++index) {
            _roundEndedEventHandlers.get(index).OnRoundEndedEvent(event);
        }
        _averageTurnCount.Record(this.getTime());
        _maxTurnCount.Record(this.getTime());
    }

    public void onBulletHit(BulletHitEvent event) {
        for (int index = 0; index < _bulletHitEventHandlers.size(); ++index) {
            _bulletHitEventHandlers.get(index).OnBulletHitEvent(event);
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        for (int index = 0; index < _hitByBulletEventHandlers.size(); ++index) {
            _hitByBulletEventHandlers.get(index).OnHitByBulletEvent(event);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent eventData) {
        for (int index = 0; index < _bulletHitBulletEventHandlers.size(); ++index) {
            _bulletHitBulletEventHandlers.get(index).OnBulletHitBulletEvent(eventData);
        }
    }

    public void onBattleEnded(BattleEndedEvent event) {
        for (int index = 0; index < _battleEndedEventHandlers.size(); ++index) {
            _battleEndedEventHandlers.get(index).OnBattleEndedEvent(event);
        }
    }

    public void onPaint(Graphics2D gfx) {
        for (int index = 0; index < _debugDrawers.size(); ++index) {
            _debugDrawers.get(index).DebugDraw(gfx);
        }
    }

    @Override
    public void RegisterForEventHandling(IScannedRobotEventHandler eventHandler) {
        _scannedRobotEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRobotDeathEventHandler eventHandler) {
        _robotDeathEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRoundStartedEventHandler eventHandler) {
        _roundStartedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRoundEndedEventHandler eventHandler) {
        _roundEndedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBulletHitEventHandler eventHandler) {
        _bulletHitEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IHitByBulletEventHandler eventHandler) {
        _hitByBulletEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBulletHitBulletEventHandler eventHandler) {
        _bulletHitBulletEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBattleEndedEventHandler eventHandler) {
        _battleEndedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterDebugDrawer(IDebugDrawer debugDrawer) {
        _debugDrawers.add(debugDrawer);
    }

    private void RecordOurSnapshot() {
        double ourX = this.getX();
        double ourY = this.getY();
        double targetX = ourX;
        double targetY = ourY;
        long thisTick = this.getTime();
        if (_targeting.HasValidTarget()) {
            Target target = _targeting.GetCurrentTarget();
            long safeTargetTick = target.GetSafePredictedTick(thisTick);
            RobotSnapshot targetSnapshot = target.RobotSnapshots.Read(safeTargetTick);
            targetX = targetSnapshot.LocationX;
            targetY = targetSnapshot.LocationY;
        }
        assert (_lastWrittenSnapshot <= thisTick);
        while (_lastWrittenSnapshot < thisTick) {
            RobotSnapshot snapshot = _ownSnapshots.Write(++_lastWrittenSnapshot);
            RobotSnapshotUtils.FillInSnapshot(snapshot, this.getRoundNum(), _lastWrittenSnapshot, this.getX(), this.getY(), this.getVelocity(), this.getHeadingRadians(), targetX, targetY, this.getEnergy(), _ownSnapshots);
        }
        assert (_lastWrittenSnapshot == thisTick);
        if (_maxPredictedTick < thisTick) {
            this.SetMaxPredictedTick(thisTick);
        }
    }

    @Override
    public void SetMaxPredictedTick(long tick) {
        assert (tick >= this.getTime());
        _maxPredictedTick = tick;
    }

    @Override
    public long GetSafePredictedTick(long tick) {
        return Math.min(tick, _maxPredictedTick);
    }

    @Override
    public RobotSnapshot ReadRobotSnapshot(long tick) {
        return _ownSnapshots.Read(tick);
    }

    @Override
    public RobotSnapshot WriteRobotSnapshot(long tick) {
        return _ownSnapshots.Write(tick);
    }

    @Override
    public RobotSnapshots GetRobotSnapshots() {
        return _ownSnapshots;
    }

    @Override
    public long getAbsoluteTime() {
        return _absoluteTime;
    }

    @Override
    public long getAverageRoundTime() {
        if (this.getRoundNum() == 0) {
            return 1000L;
        }
        return Math.round(_averageTurnCount.GetAverage());
    }

    @Override
    public long getMaxRoundTime() {
        if (this.getRoundNum() == 0) {
            return 1000L;
        }
        return Math.round(_maxTurnCount.GetMax());
    }

    @Override
    public boolean IsDisabled() {
        return Utils.isNear((double)this.getEnergy(), (double)0.0);
    }

    @Override
    public double getLastFiredFirepower() {
        return this._lastFiredFirepower;
    }

    @Override
    public void setFire(double firepower) {
        super.setFire(firepower);
        this._lastFiredFirepower = firepower;
    }

    static {
        _scannedRobotEventHandlers = new ArrayList();
        _robotDeathEventHandlers = new ArrayList();
        _roundStartedEventHandlers = new ArrayList();
        _roundEndedEventHandlers = new ArrayList();
        _bulletHitEventHandlers = new ArrayList();
        _hitByBulletEventHandlers = new ArrayList();
        _bulletHitBulletEventHandlers = new ArrayList();
        _battleEndedEventHandlers = new ArrayList();
        _debugDrawers = new ArrayList();
        _skippedTurnsCounter = new Counter("Issues : SkippedTurns");
        _hitWallCounter = new Counter("Issues : HitWall");
        _hitEnemyCounter = new Counter("Issues : HitEnemy");
        _averageTurnCount = new Average("Game Stats: Average Turn Count");
        _maxTurnCount = new Max("Game Stats: Max Turn Count");
        _absoluteTime = 0L;
    }
}

