/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import java.util.ListIterator;
import shrub.Bearing;
import shrub.MoveHistory;
import shrub.Movement;

public class PCalculator {
    private final MoveHistory mHistoryRef;
    private final ListIterator mLoIterator;
    private final ListIterator mHiIterator;
    private final int mPeriod;
    private final boolean mIsOkay;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public static PCalculator getInstance(MoveHistory historyRef, int periodVal) {
        PCalculator answer = new PCalculator(historyRef, periodVal);
        return answer;
    }

    private PCalculator(MoveHistory historyRef, int periodVal) {
        int listSize;
        if (historyRef == null) {
            System.out.println("ERROR: PCalculator constructor, null ref");
            this.mIsOkay = false;
        } else if (periodVal < 1) {
            System.out.println("ERROR: PCalculator constructor, pVal " + periodVal);
            this.mIsOkay = false;
        } else {
            listSize = historyRef.size();
            this.mIsOkay = periodVal <= listSize / 2;
        }
        if (!this.mIsOkay) {
            this.mPeriod = -1;
            this.mHistoryRef = null;
            this.mLoIterator = null;
            this.mHiIterator = null;
        } else {
            this.mPeriod = periodVal;
            this.mHistoryRef = historyRef;
            listSize = historyRef.size();
            int loStartIndex = listSize - periodVal;
            this.mLoIterator = this.mHistoryRef.listIterator(loStartIndex);
            this.mHiIterator = this.mHistoryRef.listIterator(listSize);
        }
    }

    public final boolean IsOkay() {
        return this.mIsOkay;
    }

    public final double Evaluate() {
        double accEval = 0.0;
        int numIterations = 0;
        int numEvaluations = 0;
        while (this.mLoIterator.hasPrevious()) {
            ++numIterations;
            Movement loMove = (Movement)this.mLoIterator.previous();
            Movement hiMove = (Movement)this.mHiIterator.previous();
            ++numEvaluations;
            Bearing loHdngDelta = loMove.GetHdngDelta();
            Bearing hiHdngDelta = hiMove.GetHdngDelta();
            double loVelocity = loMove.GetVelocityNow();
            double hiVelocity = hiMove.GetVelocityNow();
            double diffVelocity = loVelocity - hiVelocity;
            Bearing diffHdngDelta = Bearing.ZERO;
            if (loHdngDelta != null && hiHdngDelta != null) {
                diffHdngDelta = Bearing.valueOfFromTo(loHdngDelta, hiHdngDelta);
            }
            double thisEval = Math.pow(diffVelocity, 2.0) + Math.pow(diffHdngDelta.Get(), 2.0);
            accEval += thisEval;
        }
        double avgEval = accEval / (double)numEvaluations;
        return avgEval;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

