/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;

public class ShrubMath {
    private static double[] mSinTable = null;
    private static double[] mCosTable = null;
    private static double[] mTanTable = null;
    private static double[] mRobotAngularWidthTable = null;
    private static int mAWMaxIndex = 200;
    private static double mAWMaxDistance = 2000.0;
    private static double mAWDistanceStep = 100.0;
    private static double mRobotRadius = 15.0;
    private static NumberFormat dp2 = NumberFormat.getInstance();

    public static void Initialise() {
        mSinTable = new double[91];
        mCosTable = new double[91];
        mTanTable = new double[91];
        int angleIndexDegrees = 0;
        ShrubMath.mSinTable[angleIndexDegrees] = 0.0;
        ShrubMath.mCosTable[angleIndexDegrees] = 1.0;
        ShrubMath.mTanTable[angleIndexDegrees] = 0.0;
        ++angleIndexDegrees;
        while (angleIndexDegrees < 90) {
            ShrubMath.mSinTable[angleIndexDegrees] = Math.sin(Math.toRadians(angleIndexDegrees));
            ShrubMath.mCosTable[angleIndexDegrees] = Math.cos(Math.toRadians(angleIndexDegrees));
            ShrubMath.mTanTable[angleIndexDegrees] = Math.tan(Math.toRadians(angleIndexDegrees));
            ++angleIndexDegrees;
        }
        ShrubMath.mSinTable[angleIndexDegrees] = 1.0;
        ShrubMath.mCosTable[angleIndexDegrees] = 0.0;
        ShrubMath.mTanTable[angleIndexDegrees] = 9999.0;
        mAWMaxDistance = 2000.0;
        mAWDistanceStep = 100.0;
        mRobotRadius = 15.0;
        mAWMaxIndex = (int)(mAWMaxDistance / mAWDistanceStep);
        mRobotAngularWidthTable = new double[mAWMaxIndex + 1];
        for (int distanceIndex = 0; distanceIndex <= mAWMaxIndex; ++distanceIndex) {
            double angularWidthDeg;
            double angularWidthRad = Math.atan(mRobotRadius / ((double)distanceIndex * mAWDistanceStep));
            ShrubMath.mRobotAngularWidthTable[distanceIndex] = angularWidthDeg = Math.toDegrees(angularWidthRad);
        }
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }

    public static void SetRobotRadius(double newValue) {
        mRobotRadius = newValue;
    }

    public static final double Sin(double angle) {
        double answer = 0.0;
        if (angle < 0.0 || angle > 90.0) {
            System.out.println("ERROR: ShrubMath.sin, invalid angle " + angle);
        } else {
            answer = mSinTable[(int)angle];
        }
        return answer;
    }

    public static final double Cos(double angle) {
        double answer = 0.0;
        if (angle < 0.0 || angle > 90.0) {
            System.out.println("ERROR: ShrubMath.cos, invalid angle " + angle);
        } else {
            answer = mCosTable[(int)angle];
        }
        return answer;
    }

    public static final double Tan(double angle) {
        double answer = 0.0;
        if (angle < 0.0 || angle > 90.0) {
            System.out.println("ERROR: ShrubMath.tan, invalid angle " + angle);
        } else {
            answer = mTanTable[(int)angle];
        }
        return answer;
    }

    public static final double RobotAngularWidth(double distance) {
        double answer = 0.0;
        int index = (int)(distance / mAWDistanceStep);
        if (index > mAWMaxIndex) {
            index = mAWMaxIndex;
        }
        answer = mRobotAngularWidthTable[index];
        return answer;
    }
}

