/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns;

import de._4geeks.robots.guns.Stats;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.SUtils;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.AdvancedRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VGun {
    public static final boolean writeOutput = false;
    public static int rollingAvg = 10;
    protected double meanDeviation = 0.0;
    protected int totalWaves = 0;
    protected double meanDeviationRolling = 0.0;
    protected int roundsFired = 0;
    protected int roundsHit = 0;
    private static HashMap<String, Stats> battleStats;

    public abstract double doAim(Wave var1);

    public void addError(Wave wave, double guess) {
        double error = SUtils.sqr(wave.getGuessFactor() - guess);
        ++this.totalWaves;
        this.meanDeviation += error;
        this.meanDeviationRolling = SUtils.rollingAvg(this.meanDeviationRolling, error, Math.min(rollingAvg, this.totalWaves - 1), 1.0);
        if (wave.testHit(guess)) {
            ++this.roundsHit;
        }
    }

    public double getError() {
        Stats stats = battleStats.get(this.getGunName());
        if (stats != null) {
            return (double)(stats.totalWaves + this.totalWaves) / (double)(stats.roundsHit + this.roundsHit + 1);
        }
        return this.meanDeviationRolling;
    }

    public void fire() {
        ++this.roundsFired;
    }

    public abstract String getGunName();

    public double getMeanDeviation() {
        return this.meanDeviation;
    }

    public int getTotalWaves() {
        return this.totalWaves;
    }

    public double getMeanDeviationRolling() {
        return this.meanDeviationRolling;
    }

    public int getRoundsFired() {
        return this.roundsFired;
    }

    public int getRoundsHit() {
        return this.roundsHit;
    }

    public static void createStats(ArrayList<VGun> guns) {
        if (battleStats == null) {
            battleStats = new HashMap();
        }
        for (VGun gun : guns) {
            if (battleStats.containsKey(gun.getGunName())) continue;
            Stats stats = new Stats();
            stats.name = gun.getGunName();
            battleStats.put(gun.getGunName(), stats);
        }
    }

    public static void roundOver(ArrayList<VGun> guns) {
        for (VGun gun : guns) {
            Stats stats = battleStats.get(gun.getGunName());
            stats.meanDeviation += gun.meanDeviation;
            stats.roundsFired += gun.roundsFired;
            stats.roundsHit += gun.roundsHit;
            stats.totalWaves += gun.totalWaves;
            ++stats.totalRounds;
        }
    }

    public static void battleOver(AdvancedRobot robot, String enemyName) {
    }
}

