/*
 * Decompiled with CFR 0.152.
 */
package kid.data.factor;

import kid.data.Data;
import kid.utils.Utils;

public class GuessFactor
implements Data {
    private double guessFactor;

    public GuessFactor() {
        this.init(-1.0);
    }

    public GuessFactor(double guessFactor) {
        this.init(guessFactor);
    }

    private void init(double guessFactor) {
        this.guessFactor = guessFactor;
    }

    public double getValue() {
        return this.guessFactor;
    }

    public double getGuessFactor() {
        return this.getValue();
    }

    public final int getIndex(int numOfBins) {
        return GuessFactor.getIndex(this.getGuessFactor(), numOfBins);
    }

    public static final int getIndex(double guessFactor, int numOfBins) {
        return Utils.round(((double)numOfBins - 1.0) / 2.0 * (guessFactor + 1.0));
    }

    public final double getAngle(double maxEscapeAngle) {
        return GuessFactor.getAngle(this.getGuessFactor(), maxEscapeAngle);
    }

    public static final double getAngle(double guessFactor, double maxEscapeAngle) {
        return guessFactor * maxEscapeAngle;
    }

    @Override
    public double compare(Data d) {
        if (d instanceof GuessFactor) {
            return this.getGuessFactor() - ((GuessFactor)d).getGuessFactor();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double max() {
        return 2.0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GuessFactor) {
            return ((GuessFactor)obj).getValue() == this.getValue();
        }
        return false;
    }
}

