/*
 * Decompiled with CFR 0.152.
 */
package kid.targeting;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import kid.data.Printable;
import kid.info.GunInfo;
import kid.robot.RobotData;
import kid.utils.Utils;
import kid.virtual.VirtualBullet;
import robocode.Robot;
import robocode.Rules;

public abstract class Targeting
implements Cloneable,
Serializable,
Printable {
    private static final long serialVersionUID = -4109180260777309708L;
    protected Robot robot;
    protected GunInfo gunInfo;

    protected Targeting(Robot myRobot) {
        this.init(myRobot);
    }

    protected Targeting(Targeting targeting) {
        this.init(targeting.robot);
    }

    private final void init(Robot myRobot) {
        this.robot = myRobot;
        this.gunInfo = new GunInfo(this.robot);
    }

    public abstract double getAngle(RobotData var1, double var2);

    protected final double getAngle(RobotData target, double firePower, double velocity, double deltaHeading) {
        double angle = Utils.relative(this.gunInfo.getHeading() + this.gunInfo.getHeading());
        if (target != null && !target.isDead()) {
            firePower = Utils.limit(0.1, Math.min(this.robot.getEnergy(), firePower), 3.0);
            double bulletVelocity = Rules.getBulletSpeed((double)firePower);
            Rectangle2D battleField = this.gunInfo.getBattleField();
            double myX = this.robot.getX();
            double myY = this.robot.getY();
            double prodictedX = target.getX();
            double prodictedY = target.getY();
            double enemyHeading = target.getHeading();
            double enemyVelocity = velocity;
            int t = -1;
            while (Utils.sqr((double)t * bulletVelocity) < Utils.distSq(myX, myY, prodictedX, prodictedY) && (deltaHeading != 0.0 || battleField.contains(prodictedX, prodictedY))) {
                double deltaY;
                double deltaX = Utils.getDeltaX(enemyVelocity, enemyHeading += deltaHeading);
                if (!battleField.contains(prodictedX += deltaX, prodictedY += (deltaY = Utils.getDeltaY(enemyVelocity, enemyHeading)))) {
                    prodictedX -= deltaX;
                    prodictedY -= deltaY;
                }
                ++t;
            }
            angle = this.gunInfo.angle(prodictedX, prodictedY);
        }
        return angle;
    }

    public final VirtualBullet getBullet(RobotData target, double firePower) {
        return new VirtualBullet(this.robot.getX(), this.robot.getY(), this.getAngle(target, firePower), firePower, this.robot.getTime());
    }

    public abstract String getName();

    public abstract String getType();

    public abstract Color getColor();

    public boolean equals(Object obj) {
        if (obj instanceof Targeting) {
            Targeting targeting = (Targeting)obj;
            return targeting.getName().equals(this.getName());
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.robot = null;
        this.gunInfo = null;
        super.finalize();
    }
}

