/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.MovementChange;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.util.Utils;

public class CircleMoving
extends RobotModule {
    protected int direction;
    protected Tracking tracking;
    protected double heading;
    protected double diveAllowance;
    protected double slowSpeed;
    protected int slowPeriod;
    protected BulletTracking evading;
    protected double maxSpeed;
    protected double movingBudget;
    private Position pivot = null;

    public CircleMoving(AdvancedRobot robot, Tracking tracking) {
        super(robot);
        this.tracking = tracking;
        this.diveAllowance = 1.0471975511965976;
        this.slowSpeed = 2.0;
        this.slowPeriod = 4;
        this.evading = null;
        this.maxSpeed = 8.0;
        this.movingBudget = -1.0;
    }

    protected void setPivot(Position p) {
        this.pivot = p;
    }

    @Override
    public void init() {
        this.heading = this.robot.getHeadingRadians();
        this.direction = 1;
    }

    public void setMovingBudget(double s) {
        this.movingBudget = s;
    }

    public void setMaxSpeed(double s) {
        this.movingBudget = -1.0;
        this.maxSpeed = s;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.emergencyDirectionChange();
    }

    protected void emergencyDirectionChange() {
        this.direction *= -1;
    }

    protected MovementChange getNeededDirChange(Opponent enemy, Position myPos, Position pivot, int direction) {
        boolean wallCorrected;
        double actualHeading;
        int passed_direction = direction;
        double distanceCorrection = -0.1;
        if (enemy != null) {
            if (enemy.getLastEnergy() < 0.1 || myPos.inCorner((int)this.robot.getBattleFieldWidth() / 5)) {
                distanceCorrection = -0.35;
            } else {
                double energyRatio = this.robot.getEnergy() / enemy.getLastEnergy();
                double distance = myPos.getDirectionTo(enemy.getLastPosition()) / this.robot.getBattleFieldWidth();
                if (distance < 0.3 && energyRatio < 2.0) {
                    distanceCorrection = 0.3;
                    Log.log(4, "Too close go away!");
                } else if (energyRatio < 0.9) {
                    distanceCorrection = 0.0;
                    Log.log(4, "Away!");
                } else if (energyRatio > 1.3) {
                    distanceCorrection = -0.2;
                    Log.log(4, "Closer!");
                } else {
                    distanceCorrection = -0.15;
                    Log.log(4, "neutral!");
                }
            }
        } else {
            distanceCorrection = -0.2;
        }
        while (true) {
            this.heading = myPos.getDirectionTo(pivot);
            actualHeading = this.heading = Utils.normalAbsoluteAngle((double)(this.heading - (1.5707963267948966 + (double)direction * distanceCorrection)));
            if (direction == -1) {
                actualHeading = Utils.normalAbsoluteAngle((double)(actualHeading + Math.PI));
            }
            Position blindStick = new Position(myPos);
            blindStick.modify(1L, 140.0, actualHeading);
            wallCorrected = blindStick.adjustForWalls(myPos, 1, null, 0.0, actualHeading);
            actualHeading = myPos.getDirectionTo(blindStick);
            if (enemy == null || !wallCorrected || myPos.inCorner(60)) break;
            double diveProtection = AngleUtils.difference(actualHeading, myPos.getDirectionTo(pivot));
            double boundary = 9.0 * this.diveAllowance / 10.0;
            if (diveProtection > 0.0 && diveProtection < boundary) {
                direction *= -1;
                continue;
            }
            if (diveProtection < 0.0 && diveProtection > -boundary) {
                direction *= -1;
                continue;
            }
            if (diveProtection < -(Math.PI - boundary)) {
                direction *= -1;
                continue;
            }
            if (!(diveProtection > Math.PI - boundary)) break;
            direction *= -1;
        }
        if (wallCorrected && direction == -1) {
            this.heading = Utils.normalAbsoluteAngle((double)(actualHeading + Math.PI));
        }
        double changeNeeded = Utils.normalRelativeAngle((double)(this.heading - this.robot.getHeadingRadians()));
        return new MovementChange(direction != passed_direction, changeNeeded);
    }

    @Override
    public void turn() {
        Position myPos = new Position((Robot)this.robot);
        double speed = 20.0;
        Opponent enemy = this.tracking.getLastHitBy();
        MovementChange mc = null;
        if (this.pivot != null) {
            mc = this.getNeededDirChange(null, myPos, this.pivot, this.direction);
            Log.paintLine(4, myPos, this.pivot, new Color(0, 0, 255, 100), 0);
        } else if (enemy == null && this.pivot == null) {
            mc = this.getNeededDirChange(enemy, myPos, Position.getCenter(), this.direction);
            Log.paintLine(4, myPos, Position.getCenter(), new Color(0, 0, 255, 100), 0);
        } else {
            mc = this.getNeededDirChange(enemy, myPos, enemy.getLastPosition(), this.direction);
            Log.paintLine(4, myPos, enemy.getLastPosition(), new Color(0, 0, 255, 100), 0);
        }
        assert (mc != null);
        if (mc.revert) {
            this.emergencyDirectionChange();
        }
        this.evading = this.tracking.getClosestBullet();
        if (this.evading != null && this.evading.getSource().distance(myPos) > 300.0) {
            int border;
            long currentTime = this.robot.getTime();
            long eta = this.evading.getETA(myPos) - 1L;
            if (eta >= currentTime - (long)(border = (int)((double)(this.slowPeriod / 2) + (Math.abs(this.robot.getVelocity()) - this.slowSpeed) / 2.0)) && eta < currentTime + (long)border - 1L) {
                speed = this.slowSpeed;
            }
        }
        if (enemy != null && myPos.distance(enemy.getLastPosition()) > 150.0) {
            if (speed > this.maxSpeed) {
                speed = this.maxSpeed;
            }
            if (speed < -this.maxSpeed) {
                speed = -this.maxSpeed;
            }
        }
        if (this.movingBudget == -1.0) {
            speed += speed / 2.0 * (speed / 2.0);
            this.robot.setAhead(speed * (double)this.direction);
        } else if (this.movingBudget > 0.0) {
            this.robot.setAhead(this.movingBudget * (double)this.direction);
            this.movingBudget = 0.0;
        }
        this.robot.setTurnRightRadians(mc.dirChange);
    }

    public void bulletHitMe(BulletTracking b) {
        b.setEvaded();
    }
}

