/*
 * Decompiled with CFR 0.152.
 */
package reaper;

import reaper.Data;
import reaper.Methods;

public class Location {
    public double x;
    public double y;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDistance(Location l) {
        return Methods.getDistance(this.x, this.y, l.getX(), l.getY());
    }

    public double getDistance(double x1, double y1) {
        return Methods.getDistance(this.x, this.y, x1, y1);
    }

    public double getAngle(Location l) {
        return Methods.absoluteBearing(this.x, this.y, l.getX(), l.getY());
    }

    public double getAngle(double x1, double y1) {
        return Methods.absoluteBearing(this.x, this.y, x1, y1);
    }

    public double angleToEnemy() {
        return Methods.absoluteBearing(this.x, this.y, Data.reaper.getRecentEnemy().getX(), Data.reaper.getRecentEnemy().getY());
    }

    public double angleFromEnemy() {
        return Methods.absoluteBearing(Data.reaper.getRecentEnemy().getX(), Data.reaper.getRecentEnemy().getY(), this.x, this.y);
    }

    public double distanceToEnemy() {
        return this.getDistance(Data.reaper.getRecentEnemy().getX(), Data.reaper.getRecentEnemy().getY());
    }

    public double distanceToNearestWall() {
        return Math.min(Math.min(this.getDistance(this.x, 0.0), this.getDistance(this.x, Data.reaper.getBattleFieldHeight())), Math.min(this.getDistance(this.y, 0.0), this.getDistance(this.y, Data.reaper.getBattleFieldWidth())));
    }

    public boolean closeToWall() {
        return this.distanceToNearestWall() <= Data.evadeWall;
    }

    public double favourable() {
        double wallDistanceFavour = this.distanceToNearestWall() * -1.0 * Data.factorWallDistance;
        double enemyDistanceFavour = 0.0;
        if (this.distanceToEnemy() > Data.maxAfstand3) {
            enemyDistanceFavour = (Data.maxAfstand3 - this.distanceToEnemy()) * Data.factorEnemyDistance;
        }
        if (this.distanceToEnemy() < Data.minAfstand3) {
            enemyDistanceFavour = (this.distanceToEnemy() - Data.minAfstand3 * (double)2) * Data.factorEnemyDistance;
        }
        double favourable = wallDistanceFavour + enemyDistanceFavour;
        return favourable;
    }

    public double favourable2() {
        boolean turning = true;
        double wallDistanceFavour = this.distanceToNearestWall() * -1.0 * Data.factorWallDistance;
        double angleFromPlayer = Methods.absoluteBearing(Data.reaper.getX(), Data.reaper.getY(), this.x, this.y);
        double turningAngle = Methods.normalizeRelatief(angleFromPlayer - Data.reaper.getHeading());
        if (turningAngle < -90.0) {
            turningAngle += 180.0;
            turning = false;
        }
        if (turningAngle > 90.0) {
            turningAngle -= 180.0;
            turning = false;
        }
        double turningFavour = turningAngle * Data.factorTurning;
        double enemyBearing = Methods.normalizeRelatief(this.angleToEnemy() - angleFromPlayer);
        double distanceFrom0Deg = 0.0;
        double distanceFrom360deg = 0.0;
        if (enemyBearing >= 0.0) {
            distanceFrom0Deg = enemyBearing;
            distanceFrom360deg = 180.0 + enemyBearing;
        } else {
            distanceFrom0Deg = -enemyBearing;
            distanceFrom360deg = 180.0 - enemyBearing;
        }
        double distanceFromBoth = 0.0;
        distanceFromBoth = distanceFrom0Deg > distanceFrom360deg ? distanceFrom360deg : distanceFrom0Deg;
        double headingFavour = -1.0 * (distanceFromBoth * distanceFromBoth * Data.factorHeading);
        double turningFavour2 = (double)turning * Data.factorTurning2;
        double enemyDistanceFavour = 0.0;
        if (this.distanceToEnemy() > Data.maxAfstand4) {
            enemyDistanceFavour = (Data.maxAfstand4 - this.distanceToEnemy()) * Data.factorEnemyDistance;
        }
        if (this.distanceToEnemy() < Data.minAfstand4) {
            enemyDistanceFavour = (this.distanceToEnemy() - Data.minAfstand4 * (double)2) * Data.factorEnemyDistance;
        }
        double favourable = wallDistanceFavour + enemyDistanceFavour + headingFavour + turningFavour;
        return favourable;
    }

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

