/*
 * Decompiled with CFR 0.152.
 */
package pulsar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pulsar.AbstractManager;
import pulsar.PulsarMax;
import pulsar.Settings;
import pulsar.Strategy;
import pulsar.gf.GFUtil;
import pulsar.gf.Segmentation;
import pulsar.movement.RamMovement;
import pulsar.targeting.DirectAimTargeting;
import pulsar.targeting.LinearTargeting;
import pulsar.targeting.Targeting;
import pulsar.util.RobotData;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;
import robocode.Bullet;

public class GunManager
extends AbstractManager {
    private static Map fireWaves = new HashMap();
    private static Map virtualWaves = new HashMap();
    private int lastRound = -1;
    private static final int RAM_TIME_LIMIT = 200;
    private int ramTime = 0;
    private int bulletHitsStart = 0;
    private static boolean noRam = false;
    private static int bulletsFired = 0;
    private static final Targeting directAimTargeting = new DirectAimTargeting();
    private static final Targeting linearTargeting = new LinearTargeting();
    private Map targetingBulletMapper = new HashMap();

    public String getTargeting(Bullet bullet) {
        return (String)this.targetingBulletMapper.remove(bullet);
    }

    public void update(AdvancedRobot robot, RobotData target, Map radar) {
        if (target.dataFromRound != robot.getRoundNum()) {
            fireWaves.clear();
            virtualWaves.clear();
            this.targetingBulletMapper.clear();
            return;
        }
        if (this.lastRound != robot.getRoundNum()) {
            fireWaves.clear();
            virtualWaves.clear();
            this.targetingBulletMapper.clear();
            this.ramTime = 0;
            this.lastRound = robot.getRoundNum();
        }
        double firePower = 0.1;
        Targeting targeting = null;
        double targetEnergy = target.getValue(target.energy);
        double ourEnergy = robot.getEnergy();
        targeting = targetEnergy < 0.01 && target.getValue(target.velocity) == 0.0 ? directAimTargeting : (bulletsFired < 1 ? linearTargeting : (Targeting)this.getBestStrategy(robot, target, radar));
        firePower = targeting.getFirePower(robot, target);
        if (this.ramTime > 0 && this.bulletHitsStart < target.bulletHits) {
            noRam = true;
        }
        Bullet bullet = null;
        if (RamMovement.isFinalRammable(robot, target, noRam) && this.ramTime < 200 && PulsarMax.getMode() == 0) {
            ++this.ramTime;
            if (this.ramTime <= 1) {
                this.bulletHitsStart = target.bulletHits;
            }
        } else if (robot.getGunHeat() > robot.getGunCoolingRate() * (double)2) {
            double[] fireAngle = directAimTargeting.target(firePower, target);
            robot.setTurnGunRightRadians(Util.normalizeRelativeAngle(fireAngle[1] - robot.getGunHeadingRadians()));
        } else {
            double[] fireAngle = targeting.target(firePower, target);
            robot.setTurnGunRightRadians(Util.normalizeRelativeAngle(fireAngle[robot.getGunHeat() <= robot.getGunCoolingRate() ? Math.min(1, 1) : 1] - robot.getGunHeadingRadians()));
            if (target.isAlive && firePower > 0.0 && (bullet = robot.setFireBullet(firePower)) != null) {
                this.targetingBulletMapper.put(bullet, targeting.getName());
                ++bulletsFired;
                if (targetEnergy > 0.0 && ourEnergy > 0.0) {
                    if (Math.abs(robot.getGunTurnRemaining()) < targeting.getGunTurnLimit(target)) {
                        this.fireWave(false, bullet, robot, radar, firePower);
                    } else {
                        this.fireWave(true, bullet, robot, radar, firePower);
                    }
                }
            }
        }
        this.checkWaves(virtualWaves, robot, radar);
        this.checkWaves(fireWaves, robot, radar);
        if (target.isAlive && targetEnergy > 0.0 && ourEnergy > 0.3 && firePower > 0.0 && bullet == null) {
            this.fireWave(true, null, robot, radar, firePower);
        }
    }

    private Wave findWave(String targetName, Bullet bullet) {
        Wave wave = null;
        List list = (List)fireWaves.get(targetName);
        if (list == null) {
            list = (List)virtualWaves.get(targetName);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            wave = (Wave)iter.next();
            if (wave.bullet != bullet) continue;
            return wave;
        }
        return wave;
    }

    protected void fireWave(boolean virtual, Bullet bullet, AdvancedRobot robot, Map radar, double firePower) {
        Strategy[] strategies = this.getStrategies();
        HashMap<String, Segmentation[]> segs = new HashMap<String, Segmentation[]>();
        int i = 0;
        while (i < strategies.length) {
            Segmentation[] seg = ((Targeting)strategies[i]).getSegmentation();
            if (seg != null) {
                segs.put(strategies[i].getName(), seg);
            }
            ++i;
        }
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData target = (RobotData)iter.next();
            if (!target.isAlive || Math.abs(robot.getTime() - target.updateTime) > (long)1) continue;
            Wave wave = PulsarMax.robotStats.createWave(target, firePower, virtual, segs);
            wave.bullet = bullet;
            if (!virtual) {
                wave.addWaveGraphics();
                this.addWave(fireWaves, target, wave);
                continue;
            }
            this.addWave(virtualWaves, target, wave);
        }
    }

    protected void checkWaves(Map waves, AdvancedRobot robot, Map radar) {
        Iterator enemyIterator = waves.keySet().iterator();
        long robotTime = robot.getTime();
        while (enemyIterator.hasNext()) {
            String name = (String)enemyIterator.next();
            List list = (List)waves.get(name);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Wave wave = (Wave)iter.next();
                RobotData target = (RobotData)radar.get(name);
                wave.updateWave(robotTime);
                double totalDist = wave.origin.distance(target.getValue(target.x), target.getValue(target.y));
                double distLeft = totalDist - Util.getBulletSpeed(wave.firePower) * (double)(robotTime - wave.time);
                if (!(distLeft >= (double)-36) || !target.isAlive || robot.getRoundNum() != target.dataFromRound) {
                    iter.remove();
                    if (wave.virtual) continue;
                    wave.removeBulletGraphics();
                    continue;
                }
                if (!(distLeft <= (double)18) || wave.hit) continue;
                this.updatePassedWave(target, wave);
                wave.hit = true;
            }
        }
    }

    public void subtractForRealHit(RobotData target, Bullet bullet) {
        Wave wave = this.findWave(target.name, bullet);
        if (wave != null) {
            this.updatePassedWave(target, wave, -2);
        }
    }

    private void updatePassedWave(RobotData target, Wave wave) {
        this.updatePassedWave(target, wave, 1);
    }

    private void updatePassedWave(RobotData target, Wave wave, int realFactorSign) {
        Strategy[] targetings = this.getStrategies();
        int i = 0;
        while (i < targetings.length) {
            if (((Targeting)targetings[i]).getSegmentation() != null) {
                double x = target.getValue(target.x);
                double y = target.getValue(target.y);
                int[] segmentationSizes = ((Targeting)targetings[i]).getSegmentationSizes();
                GFUtil.updateWaveHit(targetings[i].getName(), segmentationSizes, target.name, x, y, wave, false, 27, Settings.TARGETING_HIT_SAMPLES, Settings.TARGETING_GUESSFACTOR_REAL_FACTOR * (double)realFactorSign, Double.POSITIVE_INFINITY);
            }
            ++i;
        }
    }

    private void addWave(Map waves, RobotData target, Wave wave) {
        LinkedList<Wave> list = (LinkedList<Wave>)waves.get(target.name);
        if (list == null) {
            list = new LinkedList<Wave>();
            waves.put(target.name, list);
        }
        list.add(wave);
    }

    public Strategy getBestStrategy(AdvancedRobot robot, RobotData target, Map radar) {
        int best = 0;
        double maxScore = 0.0;
        Strategy[] strategies = this.getStrategies();
        int i = 0;
        while (i < strategies.length) {
            double tmp;
            if (strategies[i].isRealStrategy() && (tmp = strategies[i].getScore(robot, target, radar, new HashMap())) >= maxScore) {
                best = i;
                maxScore = tmp;
            }
            ++i;
        }
        return strategies[best];
    }
}

