/*
 * Decompiled with CFR 0.152.
 */
package co.edu.usb.rc;

import co.edu.usb.rc.AdvancedEnemyBot;
import co.edu.usb.rc.Trigonometry;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class AdvancedBaseRobot
extends AdvancedRobot {
    PrintStream ps;
    NumberFormat f;
    static final double INITIAL_GUN_TURN_AMT = 10.0;
    static final double FAR_AWAY = 450.0;
    static final double TOO_CLOSE = 100.0;
    static final double CLOSE_ENOUGH = 140.0;
    int count = 0;
    double gunTurnAmt;
    String trackName;
    AdvancedEnemyBot enemy = new AdvancedEnemyBot();
    private boolean justScanning = false;
    double previousEnergy;
    double movementDirection = 1.0;
    protected Map<String, AdvancedEnemyBot> robotsMap = new TreeMap<String, AdvancedEnemyBot>();
    protected TreeSet<AdvancedEnemyBot> robotsSet = new TreeSet();

    public void updateRobotInfoWithList(ScannedRobotEvent e) {
        AdvancedEnemyBot robotInfo = this.robotsMap.get(e.getName());
        if (robotInfo == null) {
            robotInfo = new AdvancedEnemyBot(e, (Robot)this);
            this.robotsMap.put(e.getName(), robotInfo);
            this.robotsSet.add(robotInfo);
        } else {
            robotInfo.update(e, (Robot)this);
        }
        if (this.enemy.none() || robotInfo.getPriority() < this.enemy.getPriority() || robotInfo.getName().equals(this.enemy.getName())) {
            this.enemy = robotInfo;
            this.trackName = this.enemy.getName();
        }
    }

    public void updateRobotInfo(ScannedRobotEvent e) {
        AdvancedEnemyBot aeb = new AdvancedEnemyBot(e, (Robot)this);
        if (this.enemy.none() || aeb.getPriority() < this.enemy.getPriority() || aeb.getName().equals(this.enemy.getName())) {
            this.enemy = aeb;
            this.trackName = this.enemy.getName();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        AdvancedEnemyBot robotInfo = this.robotsMap.remove(e.getName());
        if (e.getName().equals(this.enemy.getName())) {
            this.enemy.reset();
        }
        if (robotInfo == null) {
            System.out.println("Null:" + e.getName());
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println(this.robotsSet);
            System.out.println("**********************************");
            System.out.println("**********************************");
            System.out.println("**********************************");
            return;
        }
        this.robotsSet.remove(robotInfo);
    }

    void doPredictiveShoot() {
        if (this.enemy == null) {
            System.out.println("Null enemy???");
            return;
        }
        double firePower = Math.min(500.0 / this.enemy.getDistance(), 3.0);
        double bulletSpeed = 20.0 - firePower * 3.0;
        long time = (long)(this.enemy.getDistance() / bulletSpeed);
        double futureX = this.enemy.getFutureX(time);
        double futureY = this.enemy.getFutureY(time);
        this.gunTurnAmt = Trigonometry.turnRightAngle(this.getX(), this.getY(), futureX, futureY, this.getGunHeading());
        this.setTurnGunRight(this.gunTurnAmt);
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 10.0) {
            this.setFire(firePower);
        }
    }

    public void doChoosePredictiveShoot() {
        if (this.enemy.none()) {
            return;
        }
        if (this.enemy.getDistance() > 450.0) {
            this.aproach(this.enemy);
            return;
        }
        this.doPredictiveShoot();
        if (this.enemy.getDistance() < 100.0) {
            this.retire(this.enemy);
        }
    }

    void aproach(AdvancedEnemyBot e) {
        this.gunTurnAmt = Trigonometry.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
        this.setTurnGunRight(this.gunTurnAmt);
        this.setTurnRight(e.getBearing());
        this.setAhead(e.getDistance() - 140.0);
    }

    void retire(AdvancedEnemyBot e) {
        if (e.getBearing() > -90.0 && e.getBearing() <= 90.0) {
            this.setBack(40.0);
        } else {
            this.setAhead(40.0);
        }
    }

    public void evade(HitByBulletEvent e) {
        if (e.getBearing() > -90.0 && e.getBearing() <= 90.0) {
            this.setBack(40.0);
        } else {
            this.setAhead(40.0);
        }
    }
}

