/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.compound.AbstractWeightedCompound;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.layer.FanOutLayer;
import dmonner.xlbp.layer.InternalLayer;
import dmonner.xlbp.util.MatrixTools;
import java.util.ArrayList;

public class SingletonCompound
extends AbstractWeightedCompound {
    private static final long serialVersionUID = 1L;
    private InternalLayer layer;
    private FanOutLayer fan;

    public SingletonCompound(SingletonCompound that, NetworkCopier copier) {
        super(that, copier);
        this.layer = copier.getCopyOf(that.layer);
        this.fan = copier.getCopyOf(that.fan);
        this.in = copier.getCopyOf(that.in);
        this.out = copier.getCopyOf(that.out);
    }

    public SingletonCompound(String name, InternalLayer layer) {
        super(name);
        this.layer = layer;
        this.fan = new FanOutLayer(name + "FanOut", layer.size());
        this.fan.addUpstream(layer);
        this.in = layer;
        this.out = this.fan;
    }

    @Override
    public void activateTest() {
        super.activateTest();
        if (this.layer != null) {
            this.layer.activateTest();
        }
    }

    @Override
    public void activateTrain() {
        super.activateTrain();
        if (this.layer != null) {
            this.layer.activateTrain();
        }
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            if (this.layer != null) {
                this.layer.build();
            }
            if (this.fan != null) {
                this.fan.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        if (this.layer != null) {
            this.layer.clearActivations();
        }
    }

    @Override
    public void clearResponsibilities() {
        super.clearResponsibilities();
        if (this.layer != null) {
            this.layer.clearResponsibilities();
        }
        if (this.fan != null) {
            this.fan.clearResponsibilities();
        }
    }

    @Override
    public SingletonCompound copy(NetworkCopier copier) {
        return new SingletonCompound(this, copier);
    }

    @Override
    public SingletonCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        SingletonCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        ArrayList<InternalLayer> list = new ArrayList<InternalLayer>();
        if (this.layer != null) {
            list.add(this.layer);
        }
        if (this.fan != null) {
            list.add(this.fan);
        }
        return list.toArray(new Component[list.size()]);
    }

    public InternalLayer getLayer() {
        return this.layer;
    }

    @Override
    public boolean optimize() {
        boolean rv = false;
        if (this.layer != null && !this.layer.optimize()) {
            this.layer = null;
            this.in = this.fan;
        } else {
            rv = true;
        }
        if (this.fan != null && !this.fan.optimize()) {
            this.fan = null;
            this.out = this.layer;
        } else {
            rv = true;
        }
        return rv;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            super.toString(sb);
            sb.pushIndent();
            if (this.fan != null) {
                this.fan.toString(sb);
            }
            if (this.layer != null) {
                this.layer.toString(sb);
            }
            for (WeightBank bank : this.conn) {
                bank.toString(sb);
            }
            sb.popIndent();
        } else {
            super.toString(sb);
            sb.pushIndent();
            if (this.layer != null) {
                if (sb.showActivations()) {
                    sb.appendln("Activations:");
                    sb.pushIndent();
                    sb.appendln(MatrixTools.toString(this.layer.getActivations()));
                    sb.popIndent();
                }
                if (sb.showResponsibilities()) {
                    sb.appendln("Responsibilities:");
                    sb.pushIndent();
                    sb.appendln(this.layer.getResponsibilities().toString());
                    sb.popIndent();
                }
            }
            for (WeightBank bank : this.conn) {
                bank.getConnection().toString(sb);
            }
            sb.popIndent();
        }
    }

    @Override
    public void unbuild() {
        super.unbuild();
        if (this.layer != null) {
            this.layer.unbuild();
        }
        if (this.fan != null) {
            this.fan.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
        if (this.fan != null) {
            this.fan.updateEligibilities();
        }
        if (this.layer != null) {
            this.layer.updateEligibilities();
        }
        super.updateEligibilities();
    }

    @Override
    public void updateResponsibilities() {
        if (this.fan != null) {
            this.fan.updateResponsibilities();
        }
        if (this.layer != null) {
            this.layer.updateResponsibilities();
        }
        super.updateResponsibilities();
    }

    @Override
    public void updateWeights() {
        if (this.layer != null) {
            this.layer.updateWeights();
        }
        super.updateWeights();
    }
}

