/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.connection.BiasConnection;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.layer.WeightedLayer;

public class BiasLayer
extends AbstractUpstreamLayer
implements WeightedLayer {
    private static final long serialVersionUID = 1L;
    private BiasConnection biases;

    public BiasLayer(BiasLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public BiasLayer(String name, int size) {
        super(name, size);
        this.biases = new BiasConnection(this);
    }

    @Override
    public void activateTest() {
        this.biases.activateTest();
    }

    @Override
    public void activateTrain() {
        this.biases.activateTrain();
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.biases.build();
            this.y = this.biases.get();
            this.d = new Responsibilities(this.size);
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
    }

    @Override
    public void clearEligibilities() {
        this.biases.clear();
    }

    @Override
    public BiasLayer copy(NetworkCopier copier) {
        return new BiasLayer(this, copier);
    }

    @Override
    public BiasLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof BiasLayer) {
            BiasLayer that = (BiasLayer)comp;
            this.biases = copier.copyWeights() ? that.biases.copy(copier) : new BiasConnection(this);
        }
    }

    public BiasConnection getConnection() {
        return this.biases;
    }

    @Override
    public int nWeights() {
        return this.biases.nWeights();
    }

    @Override
    public void processBatch() {
        this.biases.processBatch();
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
        this.biases.setWeightInitializer(win);
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
        this.biases.setWeightUpdater(wut);
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        this.biases.toString(sb);
        sb.popIndent();
    }

    @Override
    public void unbuild() {
        super.unbuild();
        this.biases.unbuild();
    }

    @Override
    public void updateEligibilities() {
        if (this.downstreamCopyLayer != null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
            this.biases.updateEligibilities(this.d, this.downstreamCopyLayer.getPreviousResponsibilities());
        }
    }

    @Override
    public void updateResponsibilities() {
        if (this.downstreamCopyLayer == null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateWeights() {
        if (this.downstreamCopyLayer == null) {
            this.biases.updateWeightsFromInputs(this.d);
        } else {
            this.biases.updateWeightsFromEligibilities(this.downstreamCopyLayer.getResponsibilities());
        }
    }
}

