/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history.analysis;

import bh.components.history.BulletRecord;
import bh.components.history.Frame;
import bh.components.history.History;
import bh.components.history.RobotRecord;
import bh.components.history.RobotState;
import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Duration;
import bh.units.Heading;
import bh.units.Location;
import bh.units.RelativeLocation;
import bh.units.Time;
import bh.units.Units;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class HistoricalEventParser {
    private final History history;
    private final String eventReceiverName;
    private Time latestParsed = Time.ZERO.minus(Duration.A_TURN);

    public HistoricalEventParser(String eventReceiverName, History history) {
        this.history = history;
        this.eventReceiverName = eventReceiverName;
    }

    public void parseAndStore() {
        Time t = this.latestParsed.plus(Duration.A_TURN);
        while (Units.lessOrEqual(t, this.history.getLatestRecordedEvent())) {
            Frame frame = this.history.getFrame(t);
            this.parseAndStore(frame);
            t = t.plus(Duration.A_TURN);
        }
        this.latestParsed = this.history.getLatestRecordedEvent();
    }

    private void parseAndStore(Frame frame) {
        for (SkippedTurnEvent ste : frame.skippedTurnEvents) {
            this.parseSkippedTurn(ste);
        }
        for (StatusEvent se : frame.statusEvents) {
            this.parseStatus(se);
        }
        for (ScannedRobotEvent sre : frame.scannedRobotEvents) {
            this.parseScannedRobot(sre);
        }
        for (BulletHitEvent bhe : frame.bulletHitEvents) {
            this.parseBulletHit(bhe);
        }
        for (HitByBulletEvent hbbe : frame.hitByBulletEvents) {
            this.parseHitByBullet(hbbe);
        }
        for (HitRobotEvent hre : frame.hitRobotEvents) {
            this.parseHitRobot(hre);
        }
        for (HitWallEvent hwe : frame.hitWallEvents) {
            this.parseHitWall(hwe);
        }
        for (BulletHitBulletEvent bhbe : frame.bulletHitBulletEvents) {
            this.parseBulletHitBullet(bhbe);
        }
        for (BulletMissedEvent bme : frame.bulletMissedEvents) {
            this.parseBulletMissed(bme);
        }
        for (CustomEvent ce : frame.customEvents) {
            this.parseCustomEvent(ce);
        }
        for (DeathEvent de : frame.deathEvents) {
            this.parseDeath(de);
        }
        for (RobotDeathEvent rde : frame.robotDeathEvents) {
            this.parseRobotDeath(rde);
        }
        for (WinEvent we : frame.winEvents) {
            this.parseWin(we);
        }
        for (BattleEndedEvent bee : frame.battleEndedEvents) {
            this.parseBattleEnded(bee);
        }
    }

    private void displayConflicts(String method, RobotRecord conflicts, RobotRecord newRecord) {
        if (conflicts != null) {
            System.out.println("HistoryEventListener." + method + "() had conflicts\n" + conflicts + "\n" + newRecord);
        }
    }

    private void parseBattleEnded(BattleEndedEvent event) {
    }

    private void parseBulletHit(BulletHitEvent event) {
        Time time = new Time(event.getTime());
        this.history.record(time, new BulletRecord(event.getBullet()));
        RobotRecord rr = new RobotRecord.Builder().time(event.getTime()).name(event.getName()).energy(event.getEnergy()).build();
        this.displayConflicts("onBulletHit", this.history.record(rr), rr);
    }

    private void parseBulletHitBullet(BulletHitBulletEvent event) {
        Time time = new Time(event.getTime());
        this.history.record(time, new BulletRecord(event.getBullet()));
        this.history.record(time, new BulletRecord(event.getHitBullet()));
    }

    private void parseBulletMissed(BulletMissedEvent event) {
        Time time = new Time(event.getTime());
        this.history.record(time, new BulletRecord(event.getBullet()));
    }

    private void parseCustomEvent(CustomEvent event) {
    }

    private void parseDeath(DeathEvent event) {
        RobotRecord rr = new RobotRecord.Builder().time(event.getTime()).name(this.eventReceiverName).energy(0.0).build();
        this.displayConflicts("onDeath", this.history.record(rr), rr);
    }

    private void parseHitByBullet(HitByBulletEvent event) {
        Time time = new Time(event.getTime());
        this.history.record(time, new BulletRecord(event.getBullet()));
    }

    private void parseHitRobot(HitRobotEvent event) {
        RobotRecord rr = new RobotRecord.Builder().time(event.getTime()).name(event.getName()).energy(event.getEnergy()).build();
        this.displayConflicts("onHitRobot", this.history.record(rr), rr);
    }

    private void parseHitWall(HitWallEvent event) {
    }

    private void parseRobotDeath(RobotDeathEvent event) {
        RobotRecord rr = new RobotRecord.Builder().time(event.getTime()).name(event.getName()).energy(0.0).build();
        this.displayConflicts("onRobotDeath", this.history.record(rr), rr);
    }

    private void parseScannedRobot(ScannedRobotEvent event) {
        Time time = new Time(event.getTime());
        Location botLoc = null;
        Frame f = this.history.getFrame(time);
        RobotState scannerRecord = f.robots.get(this.eventReceiverName).state();
        if (scannerRecord != null) {
            Bearing bearingToBot = new Bearing(Angle.fromDegrees(event.getBearing()));
            Distance distanceToBot = new Distance(event.getDistance());
            Heading headingToBot = scannerRecord.heading().plus(bearingToBot);
            RelativeLocation relLoc = new RelativeLocation(headingToBot, distanceToBot);
            botLoc = scannerRecord.location().plus(relLoc);
        }
        RobotRecord rr = new RobotRecord.Builder().time(time).name(event.getName()).energy(event.getEnergy()).location(botLoc).heading(event.getHeading()).speed(event.getVelocity()).build();
        this.displayConflicts("onScannedRobot", this.history.record(rr), rr);
    }

    private void parseSkippedTurn(SkippedTurnEvent event) {
    }

    private void parseStatus(StatusEvent event) {
        RobotStatus robotStatus = event.getStatus();
        RobotRecord rr = new RobotRecord.Builder().time(event.getTime()).name(this.eventReceiverName).energy(robotStatus.getEnergy()).location(robotStatus.getX(), robotStatus.getY()).heading(robotStatus.getHeading()).speed(robotStatus.getVelocity()).gunHeading(robotStatus.getGunHeading()).gunHeat(robotStatus.getGunHeat()).radarHeading(robotStatus.getRadarHeading()).build();
        this.displayConflicts("onStatus", this.history.record(rr), rr);
    }

    private void parseWin(WinEvent event) {
    }
}

