/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting.impl;

import pedersen.core.Combatant;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotImpl;
import pedersen.misc.Host;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.systems.DrivingMethod;
import pedersen.systems.DrivingMethodStandardImpl;
import pedersen.tactics.movement.MovementMethodSetImpl;
import pedersen.tactics.movement.impl.MovementMethodTangoImpl;
import pedersen.tactics.targeting.TargetingMethodBasePredictive;

public class TargetingMethodTangoImpl
extends TargetingMethodBasePredictive {
    private DrivingMethod combatantDrivingMethod = null;
    private long elapsedTime = 0L;
    private Projection projectedCombatant = null;
    private boolean patternLock = false;
    private boolean patternLockAttempted = false;
    private static DrivingMethod targetDrivingMethod = null;

    public TargetingMethodTangoImpl() {
        super(6);
    }

    protected boolean init() {
        Combatant combatant = Combatant.getCombatant();
        boolean initialized = false;
        targetDrivingMethod = TargetingMethodTangoImpl.getTargetDrivingMethod(40L, 0L);
        this.patternLock = true;
        if (this.patternLock) {
            this.combatantDrivingMethod = combatant.getDrivingMethod();
            this.projectedCombatant = new Projection(combatant);
            this.elapsedTime = Host.singleton.getTurn();
            initialized = true;
        } else if (!this.patternLockAttempted) {
            this.getPatternLock(combatant, this.target);
        }
        return initialized;
    }

    protected boolean project() {
        long round = Host.singleton.getRound();
        long turn = Host.singleton.getTurn();
        ++this.elapsedTime;
        SnapshotImpl combatantProjectionSnapshot = new SnapshotImpl(round, turn, this.projectedCombatant.getX(), this.projectedCombatant.getY(), this.projectedCombatant.getHeading(), this.projectedCombatant.getVelocity(), 0.0);
        SnapshotImpl targetProjectionSnapshot = new SnapshotImpl(round, turn, this.projectedTarget.getX(), this.projectedTarget.getY(), this.projectedTarget.getHeading(), this.projectedTarget.getVelocity(), 0.0);
        StaticVector combatantVector = this.combatantDrivingMethod.operate(combatantProjectionSnapshot, targetProjectionSnapshot, this.elapsedTime);
        StaticVector targetVector = targetDrivingMethod.operate(targetProjectionSnapshot, combatantProjectionSnapshot, this.elapsedTime);
        this.projectedCombatant.setRelativeTargetHeading(combatantVector.getHeading());
        this.projectedCombatant.setRelativeTargetVelocity(combatantVector.getVelocity());
        this.projectedTarget.setRelativeTargetHeading(targetVector.getHeading());
        this.projectedTarget.setRelativeTargetVelocity(targetVector.getVelocity());
        this.projectedCombatant.project();
        this.projectedTarget.project();
        return true;
    }

    private void getPatternLock(StaticPosition combatant, Snapshot target) {
    }

    private static DrivingMethod getTargetDrivingMethod(long period, long offset) {
        MovementMethodSetImpl movementMethods = new MovementMethodSetImpl();
        movementMethods.addDynamicMovementMethod(new MovementMethodTangoImpl(period, offset));
        return new DrivingMethodStandardImpl(movementMethods);
    }
}

