/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug.renderable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.LinkedList;
import java.util.Queue;
import pedersen.core.Competitor;
import pedersen.debug.DebuggableBase;
import pedersen.debug.renderable.RenderableArc;
import pedersen.debug.renderable.RenderableEllipse;
import pedersen.debug.renderable.RenderableLine;
import pedersen.debug.renderable.RenderableRectangle;
import pedersen.debug.renderable.RenderableShape;
import pedersen.physics.Circle;
import pedersen.physics.Direction;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.CircleImpl;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;
import pedersen.util.Constraints;

public class GraphicalDebugger
extends DebuggableBase
implements OnRound {
    public static final GraphicalDebugger singleton = new GraphicalDebugger();
    private static final Queue<RenderableShape> roundDuration = new LinkedList<RenderableShape>();
    private static final Queue<RenderableShape> turnDuration = new LinkedList<RenderableShape>();
    public static boolean paintCombatWaveBank = false;
    public static boolean paintBins = false;
    public static boolean paintMovementMethods = false;
    public static boolean paintFiringSolutions = false;
    public static boolean paintScannerSubsystem = false;
    public static boolean paintTurretSubsystem = false;
    public static boolean paintOpponents = false;

    private GraphicalDebugger() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public static void paintVehicleChassis(Vehicle chassis) {
        GraphicalDebugger.paintVehicleChassis(chassis, Color.gray);
    }

    public static void paintVehicleChassis(Vehicle chassis, Color color) {
    }

    public static void drawVehicleCircle(Position center, Color color) {
        GraphicalDebugger.addCircleTurnScope(new CircleImpl((HasPosition)center, Constraints.vehicleRadius), color);
    }

    public static void drawVehicleHitBoxRoundScope(Vehicle center, Color color) {
        GraphicalDebugger.addCircleRoundScope(new CircleImpl((HasPosition)center.getVehicle(), Constraints.vehicleRadius), color);
    }

    public static void drawMarker(Position center, Color color) {
        GraphicalDebugger.addBoxTurnScope(center, 2.0, color);
    }

    public static void traceVehicleMovement(Competitor history) {
        Snapshot presentSnapshot = history.getHistoricalSnapshot(0L);
        Snapshot previousSnapshot = history.getHistoricalSnapshot(1L);
        if (previousSnapshot != null && presentSnapshot.getTime() == previousSnapshot.getTime() + 1L) {
            double distance = previousSnapshot.getPosition().getDistance(presentSnapshot).distance();
            float heat = (float)(distance / Constraints.maxAbsVehicleVelocity.velocity());
            GraphicalDebugger.addLineRoundScope(presentSnapshot.getPosition(), previousSnapshot.getPosition(), new Color(heat, heat, heat));
        }
    }

    public static void traceBulletMovement(Competitor history) {
        Snapshot presentSnapshot = history.getHistoricalSnapshot(0L);
        Snapshot previousSnapshot = history.getHistoricalSnapshot(1L);
        if (previousSnapshot != null && presentSnapshot.getTime() == previousSnapshot.getTime() + 1L) {
            double distance = previousSnapshot.getPosition().getDistance(presentSnapshot).distance();
            float heat = (float)(distance / Constraints.maxBulletVelocity.velocity());
            GraphicalDebugger.addLineRoundScope(presentSnapshot.getPosition(), previousSnapshot.getPosition(), new Color(1.0f, 0.0f, heat));
        }
    }

    public static void addRoundScope(Line2D.Double line, Color c) {
        roundDuration.add(new RenderableLine(line, c));
    }

    public static void addTurnScope(Line2D.Double line, Color c) {
        turnDuration.add(new RenderableLine(line, c));
    }

    public static void addBoxRoundScope(Position a, double b, Color c) {
        roundDuration.add(new RenderableRectangle(a, b, c));
    }

    public static void addBoxTurnScope(Position a, double b, Color c) {
        turnDuration.add(new RenderableRectangle(a, b, c));
    }

    public static void addCircleRoundScope(Circle o, Color c) {
        roundDuration.add(new RenderableEllipse(o, c));
    }

    public static void addCircleTurnScope(Circle o, Color c) {
        turnDuration.add(new RenderableEllipse(o, c));
    }

    public static void addLineRoundScope(Position a, Position b, Color c) {
        roundDuration.add(new RenderableLine(a, b, c));
    }

    public static void addLineTurnScope(Position a, Position b, Color c) {
        turnDuration.add(new RenderableLine(a, b, c));
    }

    public static void addArcRoundScope(Circle e, Direction a, Direction b, Color c) {
        roundDuration.add(new RenderableArc(e, a, b, c));
    }

    public static void addArcTurnScope(Circle e, Direction a, Direction b, Color c) {
        turnDuration.add(new RenderableArc(e, a, b, c));
    }

    private static void drawRenderableShapes(Graphics2D console, Queue<RenderableShape> queue) {
        for (RenderableShape e : queue) {
            GraphicalDebugger.drawRenderableShape(console, e);
        }
    }

    private static void drawRenderableShape(Graphics2D console, RenderableShape o) {
        try {
            console.setColor(o.color);
            console.draw(o.shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void turnTeardown() {
        turnDuration.clear();
    }

    public static void onPaint(Graphics2D console) {
        GraphicalDebugger.drawRenderableShapes(console, roundDuration);
        GraphicalDebugger.drawRenderableShapes(console, turnDuration);
        turnDuration.clear();
    }

    @Override
    public void onRound(int round) {
        roundDuration.clear();
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("turn duration shapes: " + turnDuration.size());
        buffer.append("\n").append("round duration shapes: " + roundDuration.size());
        return buffer.toString();
    }
}

