/*
 * Decompiled with CFR 0.152.
 */
package csm.genetic_trainer;

import csm.genetic_trainer.TrainableNumberCache;
import java.io.Serializable;
import java.util.Collections;
import java.util.Random;
import java.util.Vector;

public class Population
implements Serializable {
    private Vector caches = null;
    private int populationSize = 0;
    private int cacheNum = 0;
    private double totalScore = 0.0;
    private TrainableNumberCache currentCache = null;
    private TrainableNumberCache bestCache = null;
    private double bestScore = Double.MIN_VALUE;
    private int roundsUsingThisCache = 0;
    private long populationNum = 0L;
    private double highestScoreThisGeneration = Double.MIN_VALUE;
    private double lowestScoreThisGeneration = Double.MAX_VALUE;
    private int roundsPerTest = 0;

    public Population(int populationSize, int roundsPerTest) {
        this.populationSize = populationSize;
        this.roundsPerTest = roundsPerTest;
        this.caches = new Vector();
        int i = 0;
        while (i < populationSize) {
            TrainableNumberCache t = new TrainableNumberCache();
            this.caches.add(t);
            ++i;
        }
        this.bestCache = new TrainableNumberCache();
    }

    public TrainableNumberCache getNextNumberCache() {
        if (this.roundsUsingThisCache >= this.roundsPerTest) {
            this.roundsUsingThisCache = 0;
            if (this.currentCache != null) {
                this.totalScore += this.currentCache.getScore();
                if (this.currentCache.getScore() > this.highestScoreThisGeneration) {
                    this.highestScoreThisGeneration = this.currentCache.getScore();
                }
                if (this.currentCache.getScore() < this.lowestScoreThisGeneration) {
                    this.lowestScoreThisGeneration = this.currentCache.getScore();
                }
                if (this.currentCache.getScore() > this.bestScore) {
                    this.bestScore = this.currentCache.getScore();
                    this.bestCache = this.currentCache.copy();
                }
            }
            if (this.cacheNum >= this.populationSize) {
                this.cacheNum = 0;
                this.evolvePopulation();
                this.totalScore = 0.0;
            }
            this.currentCache = (TrainableNumberCache)this.caches.elementAt(this.cacheNum);
            this.currentCache.setScore(0.0);
            ++this.cacheNum;
            System.out.println("New bot");
        }
        ++this.roundsUsingThisCache;
        if (this.currentCache == null) {
            this.currentCache = (TrainableNumberCache)this.caches.elementAt(this.cacheNum);
            this.currentCache.setScore(0.0);
            ++this.cacheNum;
            System.out.println("New bot");
        }
        return this.currentCache;
    }

    private void evolvePopulation() {
        double resolution;
        ++this.populationNum;
        Collections.sort(this.caches);
        Vector<TrainableNumberCache> nextGeneration = new Vector<TrainableNumberCache>();
        this.doElitism(nextGeneration);
        Random generator = new Random(System.currentTimeMillis());
        double baseMutationRate = 25.0 * (1.0 - (double)this.populationNum / 500.0);
        if (baseMutationRate < 1.0) {
            baseMutationRate = 1.0;
        }
        if ((resolution = 4.0 * (1.0 + (double)this.populationNum / 500.0)) > 128.0) {
            resolution = 128.0;
        }
        System.out.println("Population Generation : " + this.populationNum);
        System.out.println("Mutation Rate         : " + baseMutationRate);
        System.out.println("Resolution            : " + resolution);
        int walkPoint = this.caches.size() - 1;
        TrainableNumberCache t1 = null;
        TrainableNumberCache t2 = null;
        while (nextGeneration.size() < this.caches.size()) {
            if (t1 == null) {
                t1 = (TrainableNumberCache)this.caches.elementAt(walkPoint);
                double inclusionProbability = (t1.getScore() - this.lowestScoreThisGeneration) / (this.highestScoreThisGeneration - this.lowestScoreThisGeneration);
                if (generator.nextDouble() < inclusionProbability) {
                    t1 = null;
                }
                --walkPoint;
            } else if (t2 == null) {
                t2 = (TrainableNumberCache)this.caches.elementAt(walkPoint);
                double inclusionProbability = (t2.getScore() - this.lowestScoreThisGeneration) / (this.highestScoreThisGeneration - this.lowestScoreThisGeneration);
                if (generator.nextDouble() < inclusionProbability) {
                    t2 = null;
                }
                --walkPoint;
            } else {
                TrainableNumberCache child1 = new TrainableNumberCache(t1, t2, generator.nextInt(3) + 1);
                child1.mutate(baseMutationRate, resolution, generator);
                nextGeneration.add(child1);
                TrainableNumberCache child2 = new TrainableNumberCache(t2, t1, generator.nextInt(3) + 1);
                child2.mutate(baseMutationRate, resolution, generator);
                nextGeneration.add(child2);
                t1 = null;
                t2 = null;
            }
            if (walkPoint != 0) continue;
            walkPoint = this.caches.size() - 1;
        }
        this.caches = nextGeneration;
        this.highestScoreThisGeneration = Double.MIN_VALUE;
        this.lowestScoreThisGeneration = Double.MAX_VALUE;
    }

    private void doElitism(Vector nextGeneration) {
        int numElites = this.caches.size() / 10;
        int i = this.caches.size() - 1;
        while (i >= this.caches.size() - numElites) {
            TrainableNumberCache elite = (TrainableNumberCache)this.caches.elementAt(i);
            nextGeneration.add(elite.copy());
            System.out.println("Elite Score : " + elite.getScore());
            elite.setScore(0.0);
            --i;
        }
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public TrainableNumberCache getBestCache() {
        return this.bestCache;
    }

    public void setBestCache(TrainableNumberCache bestCache) {
        this.bestCache = bestCache;
    }

    public TrainableNumberCache getCurrentCache() {
        return this.currentCache;
    }

    public void setCurrentCache(TrainableNumberCache currentCache) {
        this.currentCache = currentCache;
    }

    public double getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(double bestScore) {
        this.bestScore = bestScore;
    }
}

