/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.EnemyPrediction;

import java.awt.Color;
import java.awt.Graphics2D;
import rdt.AgentSmith.EnemyPrediction.BulletPrediction;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionManager;
import rdt.AgentSmith.EnemyPrediction.PredictedPosition;
import rdt.AgentSmith.IDebugDrawer;
import rdt.AgentSmith.IRobot;

public class EnemyPredictionDebug
implements IDebugDrawer {
    private IRobot _robot;
    private IEnemyPredictionManager _enemyPredictionManager;

    public EnemyPredictionDebug(IRobot robot, IEnemyPredictionManager enemyPredictionManager) {
        this._robot = robot;
        this._enemyPredictionManager = enemyPredictionManager;
        robot.RegisterDebugDrawer(this);
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
        BulletPrediction[] bulletPredictions = this._enemyPredictionManager.GetBulletPredictions();
        int bulletPredictionCount = this._enemyPredictionManager.GetBulletPredictionCount();
        gfx.setColor(Color.red);
        for (int bulletPredictionIndex = 0; bulletPredictionIndex < bulletPredictionCount; ++bulletPredictionIndex) {
            BulletPrediction prediction = bulletPredictions[bulletPredictionIndex];
            this.DebugDrawBulletPrediction(prediction, gfx);
        }
    }

    private void DebugDrawBulletPrediction(BulletPrediction bulletPrediction, Graphics2D gfx) {
        int drawAtPredictionTimeStart;
        int index = drawAtPredictionTimeStart = (int)(this._robot.getTime() - bulletPrediction.TickPredictionWasGenerated);
        while ((long)index < bulletPrediction.PredictionDeactivationTime) {
            PredictedPosition position = bulletPrediction.PredicctedPositions[index];
            this.DebugDrawPredictedPosition(position, gfx);
            ++index;
        }
    }

    private void DebugDrawPredictedPosition(PredictedPosition position, Graphics2D gfx) {
        gfx.drawRect((int)position.X, (int)position.Y, 1, 1);
    }
}

