/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800.modules;

import fowl3628800.Enemy;
import fowl3628800.EnemyManager;
import fowl3628800.GravPoint;
import fowl3628800.ModularBot;
import fowl3628800.modules.Module;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseWheelEvent;
import java.util.Random;
import java.util.Vector;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyEvent;
import robocode.MouseEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class AntiGravityMovementModule
implements Module {
    int timeLeft = 0;
    private static final int REPEAT_AFTER = 1;
    ModularBot bot;
    public Vector<GravPoint> gravpoints;
    private static final double GRAVPOWER_FACTOR = -1000.0;
    private static final double GRAVPOWER_WALL_DIVIDEND = 5000.0;
    private double randomPointGravpower;
    private static final int RANDOM_POINT_REPEAT_AFTER = 30;
    private static final int RANDOM_POINT_TRESHHOLD = 50;
    private int randomPointBorderTop = 50;
    private int randomPointBorderBottom = 50;
    private int randomPointBorderLeft = 50;
    private int randomPointBorderRight = 50;
    private int cornerGravPointBorder = 0;
    private int cornerGravPointPower = -5000;
    int randomTimeLeft = 0;
    GravPoint randomPoint;
    Random random;

    public AntiGravityMovementModule(ModularBot bot) {
        this.bot = bot;
        this.gravpoints = new Vector();
        this.random = new Random();
    }

    void antiGravMove() {
        double ang;
        double force;
        double xforce = 0.0;
        double yforce = 0.0;
        int i = 0;
        while (i < this.gravpoints.size()) {
            GravPoint p = this.gravpoints.elementAt(i);
            force = p.power / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), p.x, p.y), 2.0);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.bot.getY() - p.y, this.bot.getX() - p.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
            ++i;
        }
        double[] xs = new double[]{0 + this.cornerGravPointBorder, this.bot.getBattleFieldWidth() - (double)this.cornerGravPointBorder, this.bot.getBattleFieldWidth() - (double)this.cornerGravPointBorder, 0 + this.cornerGravPointBorder};
        double[] ys = new double[]{0 + this.cornerGravPointBorder, 0 + this.cornerGravPointBorder, this.bot.getBattleFieldHeight() - (double)this.cornerGravPointBorder, this.bot.getBattleFieldHeight() - (double)this.cornerGravPointBorder};
        int i2 = 0;
        while (i2 < 4) {
            force = (double)this.cornerGravPointPower / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), xs[i2], ys[i2]), 3.0);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.bot.getY() - ys[i2], this.bot.getX() - xs[i2]));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
            ++i2;
        }
        xforce += 5000.0 / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), this.bot.getBattleFieldWidth(), this.bot.getY()), 3.0);
        yforce += 5000.0 / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), this.bot.getX(), this.bot.getBattleFieldHeight()), 3.0);
        this.goTo(this.bot.getX() - (xforce -= 5000.0 / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), 0.0, this.bot.getY()), 3.0)), this.bot.getY() - (yforce -= 5000.0 / Math.pow(AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), this.bot.getX(), 0.0), 3.0)));
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.bot.getX(), this.bot.getY(), x, y));
        double r = this.turnTo(angle);
        this.bot.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.bot.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.bot.setTurnLeft(ang);
        return dir;
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = AntiGravityMovementModule.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    @Override
    public void run() {
        this.randomPointGravpower = 10000.0 * ((double)this.bot.getOthers() / 10.0);
        if (this.randomTimeLeft <= 0 || AntiGravityMovementModule.getRange(this.bot.getX(), this.bot.getY(), this.randomPoint.x, this.randomPoint.y) <= 50.0) {
            double rndX = this.random.nextInt((int)(this.bot.getBattleFieldWidth() + 1.0 - (double)this.randomPointBorderLeft - (double)this.randomPointBorderRight)) + this.randomPointBorderLeft;
            double rndY = this.random.nextInt((int)(this.bot.getBattleFieldHeight() + 1.0 - (double)this.randomPointBorderTop - (double)this.randomPointBorderBottom)) + this.randomPointBorderBottom;
            this.randomPoint = new GravPoint(rndX, rndY, this.randomPointGravpower);
            this.randomTimeLeft = 30;
            this.bot.out.println("randomPointGravPower: " + this.randomPointGravpower);
            this.bot.out.println("\t" + 10000.0 * ((double)this.bot.getOthers() / 20.0));
            this.bot.out.println("\t" + this.bot.getOthers());
        }
        --this.randomTimeLeft;
        if (this.timeLeft <= 0) {
            this.gravpoints.clear();
            for (Object o : EnemyManager.getInstance().getMap().values()) {
                Enemy en = (Enemy)o;
                double power = en.getDamageDoneByMe() == 0.0 ? en.getDamageDoneToMe() : en.getDamageDoneToMe() / en.getDamageDoneByMe();
                power += 1.0;
                power *= en.getEnergy() / 100.0;
                power *= -1000.0;
                if (en.isDead()) continue;
                this.gravpoints.add(new GravPoint(en.getPosition().x, en.getPosition().y, power));
            }
            this.gravpoints.add(this.randomPoint);
            this.timeLeft = 1;
        }
        this.antiGravMove();
        --this.timeLeft;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
    }

    @Override
    public void onDeath(DeathEvent e) {
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent event) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent evnt) {
    }

    @Override
    public void onBulletHit(BulletHitEvent evnt) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent evnt) {
    }

    @Override
    public void onBulletMissed(BulletMissedEvent evnt) {
    }

    @Override
    public void onHitRobot(HitRobotEvent evnt) {
    }

    @Override
    public void onKeyPressed(KeyEvent e) {
    }

    @Override
    public void onKeyReleased(KeyEvent e) {
    }

    @Override
    public void onKeyTyped(KeyEvent e) {
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
    }

    @Override
    public void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void onMouseExited(MouseEvent e) {
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
    }

    @Override
    public void onMousePressed(MouseEvent e) {
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
    }

    @Override
    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void onPaint(Graphics2D g) {
        int size;
        Color color = g.getColor();
        for (GravPoint p : this.gravpoints) {
            size = (int)Math.abs(p.power / 50.0);
            if (p.power < 0.0) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            g.drawOval((int)p.x - size / 2, (int)p.y - size / 2, size, size);
        }
        double[] xs = new double[]{0 + this.cornerGravPointBorder, this.bot.getBattleFieldWidth() - (double)this.cornerGravPointBorder, this.bot.getBattleFieldWidth() - (double)this.cornerGravPointBorder, 0 + this.cornerGravPointBorder};
        double[] ys = new double[]{0 + this.cornerGravPointBorder, 0 + this.cornerGravPointBorder, this.bot.getBattleFieldHeight() - (double)this.cornerGravPointBorder, this.bot.getBattleFieldHeight() - (double)this.cornerGravPointBorder};
        g.setColor(Color.RED);
        size = Math.abs(this.cornerGravPointPower / 50);
        int i = 0;
        while (i < 4) {
            g.drawOval((int)xs[i] - size / 2, (int)ys[i] - size / 2, size, size);
            ++i;
        }
        g.setColor(Color.GREEN);
        g.drawRect((int)this.randomPoint.x - 50, (int)this.randomPoint.y - 50, 100, 100);
        g.setColor(color);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
    }

    @Override
    public void onStatus(StatusEvent e) {
    }

    @Override
    public void onWin(WinEvent event) {
    }

    @Override
    public void preRun() {
    }
}

