/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import learn.ISmart;
import robocode.util.Utils;

class Utilities {
    ISmart Is;

    Utilities(ISmart type1) {
        this.Is = type1;
    }

    double radiansToWall(Point2D.Double shotPosition, Point2D.Double target, double targetHeading, int dir) {
        double projectDist = 8.0;
        while (this.Is.playField.contains(this.project(target, projectDist * (double)dir, targetHeading))) {
            projectDist += 8.0;
        }
        Point2D.Double wallPos = this.project(target, projectDist * (double)dir, targetHeading);
        double thetaToWall = this.getAbsBearing(shotPosition, wallPos);
        return Utils.normalRelativeAngle((double)(thetaToWall - this.getAbsBearing(shotPosition, target)));
    }

    double sumInputs(double[] xVals, double[] weights, double bias) {
        double inputVal = 0.0;
        int i = 0;
        while (i < xVals.length) {
            inputVal += xVals[i] * weights[i];
            ++i;
        }
        return inputVal - bias;
    }

    double performanceFunction(double desired, double actual) {
        return (desired - actual) * (desired - actual) * -0.5;
    }

    double sigmoid(double alpha) {
        return 1.0 / (1.0 + Math.pow(Math.E, -alpha));
    }

    double bSpeed(double pow) {
        return 20.0 - 3.0 * pow;
    }

    double getAbsBearing(Point2D.Double source, Point2D.Double target) {
        return Utils.normalRelativeAngle((double)Math.atan2(target.x - source.x, target.y - source.y));
    }

    double getAbsAngle(Point2D.Double source, Point2D.Double target) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(target.x - source.x, target.y - source.y));
    }

    Point2D.Double project(Point2D.Double source, double dist, double theta) {
        return new Point2D.Double(source.x + dist * Math.sin(theta), source.y + dist * Math.cos(theta));
    }

    int sign(double val) {
        return val >= 0.0 ? 1 : -1;
    }

    List<double[]> getNearestNeighbors(Set<double[]> pointSet, double[] dataPoint, int numNeighbors) {
        if (numNeighbors == -1 || numNeighbors == 0) {
            return new ArrayList<double[]>(pointSet);
        }
        ArrayList<double[]> neighborList = new ArrayList<double[]>(numNeighbors);
        ArrayList<double[]> fullList = new ArrayList<double[]>(pointSet);
        int i = 0;
        while (i < numNeighbors) {
            neighborList.add((double[])fullList.get(i));
            ++i;
        }
        double[] nearestDistSq = new double[numNeighbors];
        nearestDistSq[0] = this.distanceSquared(dataPoint, (double[])neighborList.get(0));
        double longestDistSq = nearestDistSq[0];
        int longestIndex = 0;
        int y = 1;
        while (y < numNeighbors) {
            nearestDistSq[y] = this.distanceSquared(dataPoint, (double[])neighborList.get(y));
            if (nearestDistSq[y] > longestDistSq) {
                longestDistSq = nearestDistSq[y];
                longestIndex = y;
            }
            ++y;
        }
        double tempDist = 0.0;
        int x = numNeighbors;
        while (x < fullList.size()) {
            double distSq = this.distanceSquared(dataPoint, (double[])fullList.get(x));
            if (distSq < longestDistSq) {
                neighborList.set(longestIndex, (double[])fullList.get(x));
                nearestDistSq[longestIndex] = distSq;
                tempDist = 0.0;
                int i2 = 0;
                while (i2 < nearestDistSq.length) {
                    double dist = nearestDistSq[i2];
                    if (dist > tempDist) {
                        longestDistSq = dist;
                        tempDist = dist;
                        longestIndex = i2;
                    }
                    ++i2;
                }
            }
            ++x;
        }
        return neighborList;
    }

    double distanceSquared(double[] a, double[] b) {
        double dist = 0.0;
        int i = 0;
        while (i < a.length) {
            dist += this.sqr(a[i] - b[i]);
            ++i;
        }
        return dist;
    }

    double sqr(double val) {
        return val * val;
    }

    double limit(double a, double b, double c) {
        return Math.max(a, Math.min(b, c));
    }
}

