/*
 * Decompiled with CFR 0.152.
 */
package ethdsy;

import ethdsy.Coordinate;
import ethdsy.FireStrategy;
import ethdsy.RobotInfo;

public class LinearFire
extends FireStrategy {
    RobotInfo target;
    public Coordinate impactPoint = new Coordinate(0.0, 0.0);
    public double bulletHeading;
    protected Coordinate bulletStartingPoint = new Coordinate();
    protected Coordinate targetStartingPoint = new Coordinate();
    public double targetHeading;
    public double targetVelocity;
    public double bulletPower;
    public double angleThreshold;
    public double distance;
    public double speedDiff;
    protected double impactTime;
    protected double angularVelocity_rad_per_sec;

    public double doGun() {
        this.target = this.me.target;
        this.angularVelocity_rad_per_sec = this.target.getRadDiff();
        this.targetStartingPoint.set(this.target.x, this.target.y);
        this.bulletStartingPoint.set(this.me.getX(), this.me.getY());
        this.targetHeading = this.target.head;
        this.targetVelocity = this.target.speed;
        this.bulletPower = this.me.firePower;
        double d = 20.0 - 3.0 * this.bulletPower;
        this.speedDiff = this.target.getSpeedDiff();
        this.impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.impactPoint = this.getEstimatedPosition(this.impactTime);
        double d2 = this.impactPoint.x - this.bulletStartingPoint.x;
        double d3 = this.impactPoint.y - this.bulletStartingPoint.y;
        this.bulletHeading = Math.atan2(d2, d3);
        this.target.fireX = this.impactPoint.x;
        this.target.fireY = this.impactPoint.y;
        return this.bulletHeading;
    }

    protected Coordinate getEstimatedPosition(double d) {
        double d2 = this.targetStartingPoint.x + (this.targetVelocity + this.speedDiff) * d * Math.sin(this.targetHeading);
        double d3 = this.targetStartingPoint.y + (this.targetVelocity + this.speedDiff) * d * Math.cos(this.targetHeading);
        return new Coordinate(d2, d3);
    }

    private double f(double d) {
        double d2 = 20.0 - 3.0 * this.bulletPower;
        Coordinate coordinate = this.getEstimatedPosition(d);
        double d3 = coordinate.x - this.bulletStartingPoint.x;
        double d4 = coordinate.y - this.bulletStartingPoint.y;
        return Math.sqrt(d3 * d3 + d4 * d4) - d2 * d;
    }

    protected double getImpactTime(double d, double d2, double d3) {
        double d4 = d2;
        double d5 = d;
        int n = 0;
        double d6 = this.f(d5);
        while (Math.abs(d4 - d5) >= d3 && n < 15) {
            ++n;
            double d7 = this.f(d4);
            if (d7 - d6 == 0.0) break;
            double d8 = d4 - d7 * (d4 - d5) / (d7 - d6);
            d5 = d4;
            d4 = d8;
            d6 = d7;
        }
        return d4;
    }
}

