/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.wave;

import eem.frame.bot.InfoBot;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class wave {
    public InfoBot firedBot = null;
    protected Point2D.Double firedPosition;
    protected long firedTime;
    protected double bulletSpeed;
    protected double bulletEnergy;
    protected long timeUncertaintyLower = 0L;
    protected Color waveColor = new Color(255, 0, 0, 128);
    protected Color waveUncertaintyColorLower = new Color(0, 0, 255, 128);
    protected int count = 0;

    public wave(InfoBot infoBot, long l, double d) {
        this.firedBot = infoBot;
        this.firedTime = l;
        this.bulletEnergy = d;
        this.bulletSpeed = physics.bulletSpeed(d);
        Point2D.Double double_ = infoBot.getPositionAtTime(l);
        if (double_ != null) {
            this.firedPosition = (Point2D.Double)double_.clone();
            this.timeUncertaintyLower = 0L;
        } else {
            this.firedPosition = (Point2D.Double)infoBot.getLast().getPosition().clone();
            this.timeUncertaintyLower = l - infoBot.getPrev().getTime();
            logger.noise("timeUncertaintyLower = " + this.timeUncertaintyLower);
        }
    }

    public InfoBot getFiredBot() {
        return this.firedBot;
    }

    public Point2D.Double getFiredPosition() {
        return (Point2D.Double)this.firedPosition.clone();
    }

    public long getFiredTime() {
        return this.firedTime;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    public double getBulletEnergy() {
        return this.bulletEnergy;
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime;
        double d2 = d * this.bulletSpeed;
        return d2;
    }

    public boolean isBehindBot(InfoBot infoBot, long l) {
        Point2D.Double double_;
        double d;
        double d2 = this.getDistanceTraveledAtTime(l);
        return d2 > (d = (double_ = infoBot.getPositionClosestToTime(l)).distance(this.firedPosition)) + physics.robotHalfDiagonal;
    }

    public boolean isPassingOverBot(InfoBot infoBot, long l) {
        double d;
        if (this.firedBot.getName().equals(infoBot.getName())) {
            return false;
        }
        Point2D.Double double_ = infoBot.getPosition(l);
        if (double_ == null) {
            return false;
        }
        double d2 = this.getDistanceTraveledAtTime(l);
        return Math.abs(d2 - (d = double_.distance(this.firedPosition))) <= physics.robotHalfDiagonal;
    }

    public double getTimeToReach(Point2D.Double double_) {
        double d = double_.distance(this.firedPosition);
        return d / this.bulletSpeed;
    }

    public double getFiringAngleOffset(InfoBot infoBot, long l) {
        Point2D.Double double_ = infoBot.getPositionClosestToTime(this.firedTime);
        Point2D.Double double_2 = infoBot.getPositionClosestToTime(l);
        double d = math.angle2pt(this.firedPosition, double_);
        double d2 = math.angle2pt(this.firedPosition, double_2);
        return math.shortest_arc(d2 - d);
    }

    public double getFiringGuessFactor(InfoBot infoBot, long l) {
        double d = infoBot.getStatClosestToTime(this.firedTime).getLateralSpeed(this.firedPosition);
        return (double)math.signNoZero(d) * this.getFiringAngleOffset(infoBot, l) / physics.calculateMEA(this.bulletSpeed);
    }

    public boolean equals(wave wave2) {
        boolean bl = true;
        if (!this.getFiredBot().getName().equals(wave2.getFiredBot().getName())) {
            return false;
        }
        if (this.getFiredTime() != wave2.getFiredTime()) {
            return false;
        }
        if (this.getBulletEnergy() != wave2.getBulletEnergy()) {
            return false;
        }
        if (this.firedPosition.x != wave2.firedPosition.x) {
            return false;
        }
        return this.firedPosition.y == wave2.firedPosition.y;
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        graphics2D.setColor(this.waveColor);
        double d = this.getDistanceTraveledAtTime(l);
        graphics.drawCircle(graphics2D, this.firedPosition, d);
        if (this.timeUncertaintyLower != 0L) {
            graphics2D.setColor(this.waveUncertaintyColorLower);
            graphics.drawCircle(graphics2D, this.firedBot.getPositionAtTime(this.firedTime - this.timeUncertaintyLower), d + this.bulletSpeed * (double)this.timeUncertaintyLower);
        }
    }
}

