/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.bot;

import catcat20.core.bot.BotState;
import catcat20.core.bot.GunData;
import catcat20.core.gun.Gun;
import catcat20.core.gun.pif.PIFData;
import catcat20.core.gun.pif.PlayItForward;
import catcat20.core.gun.pm.SingleTick;
import catcat20.core.gun.waveGun.GunGF;
import catcat20.core.gun.waveGun.formula.AntiSurferGunFormula;
import catcat20.core.gun.waveGun.formula.GunKNNModel;
import catcat20.core.gun.waveGun.formula.MainGunFormula;
import catcat20.core.move.SurfDefaultTree;
import catcat20.core.move.formula.SurfKNNModel;
import catcat20.core.move.formula.duel.FlattenerFormula;
import catcat20.core.move.formula.duel.NormalFormula;
import catcat20.core.move.formula.duel.SimpleFormula;
import catcat20.core.move.formula.duel.recent.RecentNormalFormula;
import catcat20.core.move.formula.melee.MeleeComplexFormula;
import catcat20.core.move.formula.melee.MeleeFormula;
import catcat20.core.radar.Radar;
import catcat20.core.shield.angle.ApproxEnAngle;
import catcat20.core.shield.angle.CurrentEnAngle;
import catcat20.core.shield.angle.CurrentEnMyAngle;
import catcat20.core.shield.angle.LastEnMyAngle;
import catcat20.core.shield.angle.ReverseAbsAngle;
import catcat20.core.shield.angle.ReverseCurAbsAngle;
import catcat20.core.shield.angle.ShieldAngle;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.knn.GFData;
import catcat20.core.utils.knn.KNNModel;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class Bot {
    public boolean FLATTENER_ENABLE = false;
    public boolean FLATTENER_LOG = true;
    public String name;
    public boolean isAlive = false;
    public long lastScanTime;
    public double gunHeat = 3.0;
    public long gunHeatTime = -1L;
    public ArrayList<BotState> states;
    private BotState lastScanState;
    public BotState currentState;
    public KNNModel<Double> bulletPowerPredictor;
    public boolean doFired = true;
    public ArrayList<ShieldAngle> shieldAngles;
    public GunKNNModel<GunGF> mainGunModel;
    public GunKNNModel<GunGF> antiSurferModel;
    public Map<String, int[]> matcher = new SingleTick.LRUMap<String, int[]>(40000);
    public String enemyHistory = "";
    public KNNModel<PIFData> pifModel;
    public KNNModel<PIFData> meleePIFModel;
    public PIFData lastPIFData;
    public ArrayList<PIFData> stayPIFData = new ArrayList();
    public int shotsFiredDuel;
    public double oldVel;
    public double velDirChangeTime;
    public double dirChangeTimeFromMe;
    private double oldLatVel;
    public boolean useDefaultHOT = true;
    public boolean useDefaultLinear = true;
    public double predictedPowerCache = 1.0;
    public double firedPowerSum = 1.0;
    public double waveFiredCount = 1.0;
    public int youShotsFiredDuel;
    private HashMap<String, GunData> shotDataMap;
    public ArrayList<HashMap<String, GunData>> shotDataMaps;
    public HashMap<String, ArrayList<SurfKNNModel<GFData>>> surfKNNModels;
    public HashMap<String, ArrayList<SurfKNNModel<GFData>>> surfWaveFlattenerKNNModels;
    public HashMap<String, ArrayList<SurfKNNModel<GFData>>> surfMeleeKNNModels;
    public double aliveScore = 1.0;
    public double myHitRateScore = 1.0;
    public double youHitRateScore = 1.0;
    public HashMap<Gun, Double> virtualGunHitCount;
    public HashMap<Gun, Double> virtualGunFireCount;
    public String nearestBotName;
    public double nearestBotDist;
    public double nearestBotEnergy;
    public double myBotDist;
    public static Color transBluePurple;
    public static Color transRedPurple;
    public static Color transMangenta;
    public static Color transRed;
    public static Color transBlue;

    public double getStrongScore() {
        return this.aliveScore - this.myHitRateScore * 0.05 + this.youHitRateScore * 0.15;
    }

    public Bot(String name) {
        this.name = name;
        this.states = new ArrayList();
        this.shotDataMaps = new ArrayList();
        this.virtualGunFireCount = new HashMap();
        this.virtualGunHitCount = new HashMap();
        this.bulletPowerPredictor = new KNNModel(new double[]{10.0, 5.0, 10.0, 10.0});
        this.surfKNNModels = new HashMap();
        this.surfWaveFlattenerKNNModels = new HashMap();
        this.surfMeleeKNNModels = new HashMap();
        this.mainGunModel = new GunKNNModel(new MainGunFormula());
        this.antiSurferModel = new GunKNNModel(new AntiSurferGunFormula());
        this.pifModel = new KNNModel(PlayItForward.duelPatternWeights);
        this.meleePIFModel = new KNNModel(PlayItForward.meleeWeight);
        this.shieldAngles = new ArrayList();
        this.shieldAngles.add(new LastEnMyAngle().setScore(0.0));
        this.shieldAngles.add(new CurrentEnAngle().setScore(-1.0));
        this.shieldAngles.add(new ReverseAbsAngle().setScore(0.0));
        this.shieldAngles.add(new ReverseCurAbsAngle().setScore(0.0));
        this.shieldAngles.add(new CurrentEnMyAngle().setScore(0.0));
        this.shieldAngles.add(new ApproxEnAngle().setScore(-0.5));
        if (name.contains("HawkOnFire") || name.contains("Shiz") || name.contains("BlitzBat")) {
            this.useDefaultHOT = true;
            this.useDefaultLinear = false;
        }
    }

    public ShieldAngle getBestShieldAngle() {
        double bestScore = Double.POSITIVE_INFINITY;
        ShieldAngle bestAngle = null;
        for (ShieldAngle angle : this.shieldAngles) {
            if (!(angle.score < bestScore)) continue;
            bestScore = angle.score;
            bestAngle = angle;
        }
        return bestAngle;
    }

    public double[] bulletPowerDataPoint(double thisEnergy, double youEnergy, double dist, double others) {
        return new double[]{thisEnergy / 200.0, youEnergy / 200.0, dist / 1300.0, others};
    }

    private static ArrayList<SurfKNNModel<GFData>> getSurfMeleeKNNModels() {
        ArrayList<SurfKNNModel<GFData>> models = new ArrayList<SurfKNNModel<GFData>>();
        models.add(new SurfKNNModel(new MeleeFormula()).setMaxK(5).setColor(transRed).setTreeWeight(1.0).setKDivisor(1.0));
        models.add(new SurfKNNModel(new MeleeComplexFormula()).setMaxK(10).setTreeWeight(10.0).setColor(transBlue).setKDivisor(3.0));
        return models;
    }

    private static ArrayList<SurfKNNModel<GFData>> getSurfKNNModels() {
        ArrayList<SurfKNNModel<GFData>> models = new ArrayList<SurfKNNModel<GFData>>();
        models.add(new SurfKNNModel(new SimpleFormula()).setMaxK(25).setTreeWeight(3.0).setColor(transMangenta).setKDivisor(5.0));
        models.add(new SurfKNNModel(new NormalFormula()).setMaxK(20).setTreeWeight(40.0).setColor(transRed).setKDivisor(5.0));
        models.add(new SurfKNNModel(new RecentNormalFormula()).setMaxK(1).setTreeWeight(100.0).setColor(transRedPurple).setKDivisor(1.0));
        models.add(new SurfKNNModel(new RecentNormalFormula()).setMaxK(7).setTreeWeight(100.0).setColor(transBluePurple).setKDivisor(4.0));
        return models;
    }

    private static ArrayList<SurfKNNModel<GFData>> getSurfWaveFlatenerKNNModels() {
        ArrayList<SurfKNNModel<GFData>> models = new ArrayList<SurfKNNModel<GFData>>();
        models.add(new SurfKNNModel(new FlattenerFormula()).setMaxK(10).setTreeWeight(0.5).setColor(transBlue));
        return models;
    }

    public void updateState(long time, int others) {
        this.gunHeat = LUtils.limit(-1.0, this.gunHeat, 3.5);
        this.gunHeat -= LConstants.GUN_COOLING_RATE;
        if (this.gunHeat <= 0.0) {
            this.doFired = true;
            this.gunHeatTime = time;
        }
        if (!(this.currentState != null && time - this.lastScanTime <= 1L || this.states.isEmpty())) {
            BotState lastState = this.states.get(0);
            this.currentState = new BotState();
            this.currentState.time = time;
            this.currentState.isInterpolated = true;
            double nextX = lastState.x + Math.sin(lastState.heading) * lastState.velocity;
            double nextY = lastState.y + Math.cos(lastState.heading) * lastState.velocity;
            this.currentState.x = nextX;
            this.currentState.y = nextY;
            this.currentState.name = this.name;
            this.currentState.heading = lastState.heading;
            this.currentState.velocity = lastState.velocity;
            this.currentState.energy = lastState.energy;
        }
        if (this.currentState != null) {
            this.currentState.shotsFired = this.youShotsFiredDuel;
            this.states.add(0, this.currentState);
        }
    }

    public void updateOtherInfo(String myName, BotState myState) {
        this.shotDataMap = new HashMap();
        if (this.currentState != null) {
            double dist;
            BotState last8 = this.states.get(LUtils.limit(0, this.states.size() - 1, 8));
            this.currentState.dist8 = this.currentState.distance(last8.x, last8.y);
            BotState last20 = this.states.get(LUtils.limit(0, this.states.size() - 1, 20));
            this.currentState.dist20 = this.currentState.distance(last20.x, last20.y);
            this.velDirChangeTime += 1.0;
            if (LUtils.sign(this.currentState.velocity) != LUtils.sign(this.oldVel)) {
                this.velDirChangeTime = 0.0;
            }
            this.oldVel = this.currentState.velocity;
            double latVel = Bot.lateralVelocity(myState, this.currentState);
            this.dirChangeTimeFromMe += 1.0;
            if (LUtils.sign(latVel) != LUtils.sign(this.oldLatVel)) {
                this.dirChangeTimeFromMe = 0.0;
            }
            this.oldLatVel = latVel;
            double bestDist = Double.POSITIVE_INFINITY;
            if (!this.surfKNNModels.containsKey(myName)) {
                this.surfKNNModels.put(myName, Bot.getSurfKNNModels());
                this.surfWaveFlattenerKNNModels.put(myName, Bot.getSurfWaveFlatenerKNNModels());
                this.surfMeleeKNNModels.put(myName, Bot.getSurfMeleeKNNModels());
            }
            if (bestDist > (dist = this.currentState.distance(myState.x, myState.y))) {
                bestDist = dist;
                this.nearestBotName = myName;
                this.nearestBotEnergy = myState.energy;
            }
            this.myBotDist = dist;
            this.updateGunData(myName, myState);
            for (Bot bot : Radar.enemyList) {
                if (!this.surfKNNModels.containsKey(bot.name)) {
                    this.surfKNNModels.put(bot.name, Bot.getSurfKNNModels());
                    this.surfWaveFlattenerKNNModels.put(bot.name, Bot.getSurfWaveFlatenerKNNModels());
                    this.surfMeleeKNNModels.put(bot.name, Bot.getSurfMeleeKNNModels());
                }
                if (this.name.equals(bot.name) || !bot.isAlive || bot.states.isEmpty() || bot.currentState == null) continue;
                double dist2 = this.currentState.distance(bot.currentState.x, bot.currentState.y);
                if (bestDist > dist2) {
                    this.nearestBotEnergy = bot.currentState.energy;
                    bestDist = dist2;
                    this.nearestBotName = bot.name;
                }
                this.updateGunData(bot.name, bot.currentState);
            }
            this.nearestBotDist = bestDist;
        }
        this.shotDataMaps.add(0, this.shotDataMap);
    }

    public void updateGunData(String youName, BotState youState) {
        if (!this.shotDataMap.containsKey(youName)) {
            this.shotDataMap.put(youName, new GunData());
        }
        GunData oldGunData = null;
        if (!this.shotDataMaps.isEmpty() && this.shotDataMaps.get(0).containsKey(youName)) {
            oldGunData = this.shotDataMaps.get(0).get(youName);
        }
        GunData gunData = this.shotDataMap.get(youName);
        if (oldGunData != null) {
            gunData.youOldLatVel = oldGunData.youLatVel;
            gunData.youDirChangeTime = oldGunData.youDirChangeTime;
        }
        gunData.youLatVel = Bot.lateralVelocity(this.currentState, youState);
        gunData.youAdvVel = Bot.advancingVelocity(this.currentState, youState);
        gunData.youDirChangeTime += 1.0;
        if (LUtils.sign(gunData.youOldLatVel) != LUtils.sign(gunData.youLatVel)) {
            gunData.youDirChangeTime = 0.0;
        }
        gunData.youAccel = LUtils.accel(Math.abs(gunData.youLatVel), Math.abs(gunData.youOldLatVel));
    }

    public BotState getCurrentState() {
        if (this.states.isEmpty()) {
            return null;
        }
        return this.states.get(0);
    }

    public static double lateralVelocity(BotState source, BotState target) {
        double absBearing = LUtils.absoluteBearing(source.x, source.y, target.x, target.y);
        return target.velocity * Math.sin(target.heading - absBearing);
    }

    public static double advancingVelocity(BotState source, BotState target) {
        double absBearing = LUtils.absoluteBearing(source.x, source.y, target.x, target.y);
        return -Math.cos(target.heading - absBearing) * target.velocity;
    }

    public void onScannedRobot(TeamRobot robot, ScannedRobotEvent e) {
        this.currentState = new BotState();
        double angle = e.getBearingRadians() + robot.getHeadingRadians();
        double dist = e.getDistance();
        double x = robot.getX() + Math.sin(angle) * dist;
        double y = robot.getY() + Math.cos(angle) * dist;
        this.currentState.name = e.getName();
        this.currentState.time = e.getTime();
        this.currentState.x = x;
        this.currentState.y = y;
        this.currentState.velocity = e.getVelocity();
        this.currentState.heading = e.getHeadingRadians();
        this.currentState.energy = e.getEnergy();
        if (this.lastScanState != null && this.currentState.time - this.lastScanState.time > 1L) {
            int fromIndex;
            int toIndex = this.states.indexOf(this.lastScanState);
            --toIndex;
            for (int i = fromIndex = 0; i < toIndex; ++i) {
                BotState interpolate = this.states.get(i);
                interpolate.name = this.currentState.name;
                interpolate.x += (this.currentState.x - this.lastScanState.x) * (double)i / (double)toIndex;
                interpolate.y += (this.currentState.y - this.lastScanState.y) * (double)i / (double)toIndex;
                interpolate.velocity += (this.currentState.velocity - this.lastScanState.velocity) * (double)i / (double)toIndex;
                interpolate.dist8 += (this.currentState.dist8 - this.lastScanState.dist8) * (double)i / (double)toIndex;
                interpolate.dist20 += (this.currentState.dist20 - this.lastScanState.dist20) * (double)i / (double)toIndex;
                interpolate.heading += (this.currentState.heading - this.lastScanState.heading) * (double)i / (double)toIndex;
            }
        }
        this.lastScanState = this.currentState;
    }

    static {
        if (SurfDefaultTree.hotTrees == null) {
            if (SurfDefaultTree.hotTreeJson == null) {
                SurfDefaultTree.hotTrees = Bot.getSurfMeleeKNNModels();
            } else {
                Gson gson = new Gson();
                Type collectionType = new TypeToken<ArrayList<SurfKNNModel<GFData>>>(){}.getType();
                SurfDefaultTree.hotTrees = (ArrayList)gson.fromJson(SurfDefaultTree.hotTreeJson, collectionType);
            }
        }
        transBluePurple = new Color(0.75f, 0.0f, 1.0f, 0.33f);
        transRedPurple = new Color(1.0f, 0.0f, 0.75f, 0.33f);
        transMangenta = new Color(1.0f, 0.0f, 1.0f, 0.33f);
        transRed = new Color(1.0f, 0.0f, 0.0f, 0.33f);
        transBlue = new Color(0.0f, 0.0f, 1.0f, 0.33f);
    }
}

