/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import robocode.util.Utils;
import tcf.Arena;
import tcf.Bot;
import tcf.OppBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MovementBase {
    Arena m_arena;
    double m_gridStep = 25.0;
    int m_gridX;
    int m_gridY;
    int m_gridW;
    int m_gridH;
    int m_gridSize;
    int[] m_grid;
    int[] m_gridPath;
    int[] m_gridPathValue;
    static final int[] m_deltaX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    static final int[] m_deltaY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};

    MovementBase(Arena arena) {
        this.m_arena = arena;
        this.m_gridW = (int)Math.floor((this.m_arena.WIDTH - 50.0) / this.m_gridStep);
        this.m_gridH = (int)Math.floor((this.m_arena.HEIGHT - 50.0) / this.m_gridStep);
        this.m_gridX = (int)((this.m_arena.WIDTH - (double)this.m_gridW * this.m_gridStep) / 2.0);
        this.m_gridY = (int)((this.m_arena.HEIGHT - (double)this.m_gridH * this.m_gridStep) / 2.0);
        this.m_gridSize = this.m_gridW * this.m_gridH;
        this.m_grid = new int[this.m_gridSize];
    }

    abstract void tick(Map<String, OppBot> var1, int var2, OppBot var3);

    abstract void event(Event var1);

    abstract void drive();

    abstract double getToX();

    abstract double getToY();

    public int calcGridX(double d) {
        int n = (int)Math.floor((d - (double)this.m_gridX) / this.m_gridStep);
        if (n < 0) {
            n = 0;
        } else if (n >= this.m_gridW) {
            n = this.m_gridW - 1;
        }
        return n;
    }

    public int calcGridY(double d) {
        int n = (int)Math.floor((d - (double)this.m_gridY) / this.m_gridStep);
        if (n < 0) {
            n = 0;
        } else if (n >= this.m_gridH) {
            n = this.m_gridH - 1;
        }
        return n;
    }

    public int calcGridXUnsafe(double d) {
        return (int)Math.floor((d - (double)this.m_gridX) / this.m_gridStep);
    }

    public int calcGridYUnsafe(double d) {
        return (int)Math.floor((d - (double)this.m_gridY) / this.m_gridStep);
    }

    public double gridToRealX(int n) {
        return (double)this.m_gridX + ((double)n + 0.5) * this.m_gridStep;
    }

    public double gridToRealY(int n) {
        return (double)this.m_gridY + ((double)n + 0.5) * this.m_gridStep;
    }

    public void updateGrid(Map<String, OppBot> map, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (int i = 0; i < this.m_gridSize; ++i) {
            this.m_grid[i] = 0;
        }
        for (OppBot oppBot : map.values()) {
            n8 = this.calcGridX(oppBot.x());
            n7 = this.calcGridY(oppBot.y());
            this.m_grid[n8 + n7 * this.m_gridW] = 1;
        }
        if (n == 0) {
            int n9 = this.m_gridW / 2;
            int n10 = this.m_gridH / 2;
            this.m_grid[n9 + n10 * this.m_gridW] = 1;
        }
        int n11 = 3;
        int n12 = 1;
        while (n11-- > 0) {
            for (n8 = 0; n8 < this.m_gridSize; ++n8) {
                if (this.m_grid[n8] != n12) continue;
                n7 = n8 % this.m_gridW;
                n6 = n8 / this.m_gridW;
                for (n5 = 0; n5 < 8; ++n5) {
                    n4 = n7 + m_deltaX[n5];
                    n3 = n6 + m_deltaY[n5];
                    if (n4 < 0 || n4 >= this.m_gridW || n3 < 0 || n3 >= this.m_gridH || this.m_grid[n2 = n4 + n3 * this.m_gridW] != 0) continue;
                    this.m_grid[n2] = n12 + 2 + (n5 & 1);
                    n11 = 3;
                }
            }
            ++n12;
        }
        for (OppBot oppBot : map.values()) {
            n6 = this.calcGridX(oppBot.x());
            n5 = this.calcGridY(oppBot.y());
            for (n4 = -2; n4 <= 2; ++n4) {
                for (n3 = -2; n3 <= 2; ++n3) {
                    n2 = n6 + n4;
                    int n13 = n5 + n3;
                    if (n2 < 0 || n2 >= this.m_gridW || n13 < 0 || n13 >= this.m_gridH) continue;
                    this.m_grid[n2 + n13 * this.m_gridW] = -999999;
                }
            }
        }
    }

    public double[] doGoto(Bot bot, double d, double d2) {
        double d3;
        double d4 = Math.atan2(d - bot.x(), d2 - bot.y());
        double d5 = bot.heading();
        double d6 = d5 + Math.PI;
        double d7 = Utils.normalRelativeAngle((double)(d4 - d5));
        double d8 = Utils.normalRelativeAngle((double)(d4 - d6));
        boolean bl = Math.abs(d7) < Math.abs(d8);
        double d9 = 0.0;
        double d10 = 0.0;
        if (bl) {
            d9 = d7;
            d10 = Math.abs(d7) < 0.7853981633974483 ? 8.0 : 4.0;
        } else {
            d9 = d8;
            d10 = Math.abs(d8) < 0.7853981633974483 ? -8.0 : -4.0;
        }
        double d11 = Math.hypot(d - bot.x(), d2 - bot.y());
        if (d11 < Math.abs(d10) * 4.0) {
            d3 = Math.max(0.0, Math.sqrt(1.0 + 4.0 * d11) - 1.0);
            if (Math.abs(d10) > d3) {
                d10 = d3 * Math.signum(d10);
            }
            if (Math.abs(d11) < 0.5) {
                d10 = 0.0;
                d9 = 0.0;
            }
        }
        d3 = bot.speed() * Math.sin(bot.heading());
        double d12 = bot.speed() * Math.cos(bot.heading());
        double d13 = 999.0;
        if (d3 != 0.0) {
            d13 = d3 < 0.0 ? Math.min(d13, (this.m_arena.MIN_X - bot.x()) / d3) : Math.min(d13, (this.m_arena.MAX_X - bot.x()) / d3);
        }
        if (d12 != 0.0) {
            d13 = d12 < 0.0 ? Math.min(d13, (this.m_arena.MIN_Y - bot.y()) / d12) : Math.min(d13, (this.m_arena.MAX_Y - bot.y()) / d12);
        }
        if (d13 <= 4.0) {
            d10 = 0.0;
        }
        return new double[]{d9, d10};
    }

    public void onPaint(Graphics2D graphics2D) {
        int n;
        if (this.m_gridPath != null) {
            n = -1;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.m_gridPath.length; ++i) {
                if (n != this.m_gridPath[i]) {
                    if (n >= 0) {
                        double d = this.gridToRealX(n % this.m_gridW);
                        double d2 = this.gridToRealY(n / this.m_gridW);
                        int n4 = 3;
                        graphics2D.setColor(Color.blue);
                        if (n2 == 1) {
                            graphics2D.setColor(Color.orange);
                        } else if (n2 == 2) {
                            graphics2D.setColor(Color.red);
                        }
                        graphics2D.fillRect((int)d - n4, (int)d2 - n4, n4 + n4, n4 + n4);
                    }
                    n = this.m_gridPath[i];
                    n2 = 0;
                }
                n3 += this.m_gridPathValue[i];
                if (this.m_gridPathValue[i] < -1000) {
                    n2 = Math.max(n2, 2);
                    continue;
                }
                if (this.m_gridPathValue[i] >= 0) continue;
                n2 = Math.max(n2, 1);
            }
            if (n >= 0) {
                double d = this.gridToRealX(n % this.m_gridW);
                double d3 = this.gridToRealY(n / this.m_gridW);
                int n5 = 3;
                graphics2D.setColor(Color.blue);
                if (n2 == 1) {
                    graphics2D.setColor(Color.orange);
                } else if (n2 == 2) {
                    graphics2D.setColor(Color.red);
                }
                graphics2D.fillRect((int)d - n5, (int)d3 - n5, n5 + n5, n5 + n5);
            }
            graphics2D.setColor(Color.white);
            graphics2D.drawString(String.format("path %d", n3), 10, 5);
        }
        graphics2D.setColor(Color.gray);
        for (n = 0; n < this.m_gridSize; ++n) {
            double d = this.gridToRealX(n % this.m_gridW);
            double d4 = this.gridToRealY(n / this.m_gridW);
            graphics2D.drawString(String.valueOf(this.m_grid[n]), (int)d, (int)d4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Event {
        EV_NEW_INFO;

    }
}

