/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery.util;

import java.awt.geom.Rectangle2D;
import jekl.Jekyl;
import jekl.intelligence.Enemy;
import jekl.navigation.util.BattleMap;
import jekl.util.Constants;

public class FiringAssistant
implements Constants {
    Jekyl ar;
    public int fireMethod;
    BattleMap bm;

    public FiringAssistant(Jekyl _ar) {
        this.ar = _ar;
        this.bm = new BattleMap(_ar);
    }

    public double calculateFirePower(Enemy target) {
        double energy = 0.0;
        if (this.ar.getProps().getProperty("behavior", "normal").equalsIgnoreCase("normal")) {
            energy = this.ar.getEnergy() >= 20.0 ? Math.min(Math.min(3.0, 1000.0 / target.getDistance()), Math.max(0.1, target.getEnergy() >= 4.0 ? (target.getEnergy() + 2.0) / 6.0 : (target.getEnergy() + 2.0) / 4.0)) : (this.ar.getEnergy() >= 5.0 && this.ar.getEnergy() < 20.0 ? Math.min(Math.min(3.0, 1000.0 / target.getDistance()), Math.max(0.1, target.getEnergy() >= 4.0 ? (target.getEnergy() + 2.0) / 6.0 : target.getEnergy() / 4.0 + 2.0)) * 0.8 : (this.ar.getEnergy() >= 1.5 && this.ar.getEnergy() < 5.0 ? this.ar.getEnergy() / 5.0 : (this.ar.getEnergy() < 1.5 && this.ar.getTarget().getDistance() < 150.0 ? this.ar.getEnergy() / 5.0 : (this.ar.getTarget().getEnergy() / this.ar.getEnergy() < 5.0 ? 0.1 : 0.0))));
            return energy;
        }
        if (this.ar.getProps().getProperty("behavior").equalsIgnoreCase("reference")) {
            energy = this.ar.getEnergy() > 0.0 ? 3.0 : 0.0;
        }
        return energy;
    }

    public int getDistanceIndex(double firePower, Enemy target) {
        return Math.min(10, (int)target.getDistance() / 100);
    }

    public int getLatVelIndex(Enemy target) {
        double tVelocity = target.getVelocity();
        double latVel = tVelocity * Math.sin(target.getHeading() - target.getAbsBearing());
        return (int)(Math.abs(latVel) / 3.0);
    }

    public int getAccelIndex(Enemy target) {
        double tVelocity = target.getVelocity();
        double accelDiff = Math.round(Math.abs(tVelocity) - Math.abs(target.getLastVelocity()));
        return accelDiff == 0.0 ? 0 : (accelDiff > 0.0 ? 2 : 1);
    }

    public double getMaxAnglePossible(double firePower) {
        double bulletV = 20.0 - 3.0 * firePower;
        return Math.asin(8.0 / bulletV);
    }

    public int getDirection(Enemy target) {
        double tVelocity = target.getVelocity();
        double latVel = tVelocity * Math.sin(target.getHeading() - target.getAbsBearing());
        return latVel >= 0.0 ? 1 : -1;
    }

    public int getRadialIndex(Enemy target) {
        return 0;
    }

    public int getWallIndex(Enemy target) {
        double projectedY;
        Rectangle2D.Double field = this.bm.getBattleField();
        int direction = (int)(Math.abs(target.getVelocity()) / target.getVelocity());
        double projectedX = target.getX() + Math.sin(target.getHeading()) * (double)(100 * direction);
        return field.contains(projectedX, projectedY = target.getY() + Math.cos(target.getHeading()) * (double)(100 * direction)) ? 0 : 1;
    }

    public double getInitialTargetAbsBearing(Enemy target) {
        return target.getAbsBearing();
    }
}

