/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import morbid.IObject;
import morbid.IRobotPositionManager;

abstract class Utils {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final double TWO_PI = Math.PI * 2;
    public static final double DISTANCE_EPSILON = 1.0;
    public static final double VELOCITY_EPSILON = 0.1;
    public static final double ANGLE_EPSILON = 1.0E-8;
    public static final double TICK = 1.0;
    public static final boolean ASSERT_ENABLED = false;
    private static int s_ID;
    private static final char[] DIGIT_TO_CHAR;
    private static final double[] DIGITS_TO_MULTIPLIER;
    private static final double _10_IN_RADIANS = 0.17453292519943295;
    private static final double _0d75_IN_RADIANS = 0.013089969389957472;
    private static final StringBuffer s_doubleFormatter;
    private static final char[] s_formatter;
    private static final boolean STOP_ON_ZERO_V = true;
    private static final boolean ROUND_ACCELERATION = true;
    private static final boolean DEBUG_INTERPOLATE2 = false;
    private static final boolean DEBUG_SPREDICTOR = false;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$morbid$Utils;

    public static double velocityToMaxTurnRate(double v) {
        return 0.17453292519943295 - 0.013089969389957472 * Math.abs(v);
    }

    public static double degreesToRadians(double degrees) {
        return Math.PI * degrees / 180.0;
    }

    public static double radiansToDegrees(double radians) {
        return 180.0 * radians / Math.PI;
    }

    public static double normalizePhi(double phi) {
        if (phi < 0.0) {
            return phi + Math.PI * 2;
        }
        if (phi >= Math.PI * 2) {
            return phi - Math.PI * 2;
        }
        return phi;
    }

    public static double reversePhi(double phi) {
        return Utils.normalizePhi(Utils.normalizePhi(phi) - Math.PI);
    }

    public static double normalizePlus(double phi1, double phi2) {
        return Utils.normalizePhi(phi1 + phi2);
    }

    public static double normalizeMinus(double phi1, double phi2) {
        return Utils.normalizePhi(phi1 - phi2);
    }

    public static double deltaPhi(double phistar, double phi) {
        double delta = Utils.normalizeMinus(phistar, phi);
        if (Math.abs(delta) <= Math.PI) {
            return delta;
        }
        return delta > 0.0 ? delta - Math.PI * 2 : Math.PI * 2 + delta;
    }

    public static double deltaPhi2(double phistar, double phi, double direction) {
        double delta = Utils.normalizeMinus(phistar, phi);
        if (direction * delta >= 0.0) {
            return delta;
        }
        return delta > 0.0 ? delta - Math.PI * 2 : Math.PI * 2 + delta;
    }

    public static double absoluteBearing(double bearing, double relative_bearing) {
        return relative_bearing + bearing;
    }

    public static double[] bearingAndDistanceToXY(double x, double y, double bearing, double relative_bearing, double distance) {
        double[] result = new double[2];
        double absolute_bearing = Utils.absoluteBearing(bearing, relative_bearing);
        result[0] = x + distance * Math.sin(absolute_bearing);
        result[1] = y + distance * Math.cos(absolute_bearing);
        return result;
    }

    public static void interpolate(double[] out, double x, double y, double heading, double velocity, double time_delta) {
        double object_advancement = time_delta * velocity;
        out[0] = x + object_advancement * Math.sin(heading);
        out[1] = y + object_advancement * Math.cos(heading);
    }

    public static void interpolate2(PrintStream debug, double[] out, IObject.ITrackedObjectTimeSeries series, double time1, double time2, double battle_field_width, double battle_field_height) {
        out[0] = -1.0;
        IObject.IUpdatedObject breakingpoint = null;
        int valid_point_count = 0;
        while (valid_point_count < series.size()) {
            IObject.IUpdatedObject point = series.getPoint(valid_point_count);
            if ((double)point.getUpdateTime() < time1 || Math.abs(point.getVelocity()) <= 1.0) {
                breakingpoint = point;
                ++valid_point_count;
                break;
            }
            ++valid_point_count;
        }
        if (valid_point_count < 2) {
            return;
        }
        IObject.IUpdatedObject last = series.getPoint(0);
        double x = last.getX();
        double y = last.getY();
        double h = last.getHeadingRadians();
        double v = last.getVelocity();
        double acceleration = 0.0;
        double angular_velocity = 0.0;
        long time_K = -1L;
        long time_K_1 = -1L;
        double time_delta_K = -1.0;
        double time_delta_K_1 = -1.0;
        double v_K = Double.NaN;
        double v_K_1 = Double.NaN;
        double h_K = Double.NaN;
        double h_K_1 = Double.NaN;
        IObject.IUpdatedObject point_K = null;
        IObject.IUpdatedObject point_K_1 = null;
        int p = valid_point_count - 1;
        while (p > 0) {
            point_K_1 = p == valid_point_count - 1 ? series.getPoint(p) : point_K;
            point_K = series.getPoint(p - 1);
            time_K_1 = p == valid_point_count - 1 ? point_K_1.getUpdateTime() : time_K;
            time_K = point_K.getUpdateTime();
            time_delta_K_1 = p == valid_point_count - 1 ? 0.0 : time_delta_K;
            time_delta_K = time_K - time_K_1;
            v_K_1 = p == valid_point_count - 1 ? point_K_1.getVelocity() : v_K;
            v_K = point_K.getVelocity();
            h_K_1 = p == valid_point_count - 1 ? point_K_1.getHeadingRadians() : h_K;
            h_K = point_K.getHeadingRadians();
            if (p == valid_point_count - 1) {
                if (valid_point_count > 5) {
                    acceleration = (v_K - v_K_1) / time_delta_K;
                    angular_velocity = Utils.deltaPhi(h_K, h_K_1) / time_delta_K;
                } else {
                    acceleration += (v_K - v_K_1) / time_delta_K;
                    angular_velocity += Utils.deltaPhi(h_K, h_K_1) / time_delta_K;
                }
            } else if (valid_point_count > 5) {
                double alpha = 1.0 - time_delta_K / (time_delta_K + time_delta_K_1);
                acceleration = alpha * (v_K - v_K_1) / time_delta_K + (1.0 - alpha) * acceleration;
                angular_velocity = alpha * Utils.deltaPhi(h_K, h_K_1) / time_delta_K + (1.0 - alpha) * angular_velocity;
            } else {
                acceleration += (v_K - v_K_1) / time_delta_K;
                angular_velocity += Utils.deltaPhi(h_K, h_K_1) / time_delta_K;
            }
            --p;
        }
        if (valid_point_count <= 5) {
            acceleration /= (double)(valid_point_count - 1);
            angular_velocity /= (double)(valid_point_count - 1);
        }
        acceleration = Math.round(acceleration);
        double prev_v = v;
        boolean interpolate = true;
        boolean clipped = false;
        int t = 0;
        while ((long)t < Math.round(Math.floor(time2)) - last.getUpdateTime()) {
            double max_angular_velocity = 0.17453292519943295 - 0.013089969389957472 * Math.abs(v);
            if (Math.abs(angular_velocity) > max_angular_velocity) {
                angular_velocity = angular_velocity > 0.0 ? max_angular_velocity : -max_angular_velocity;
            }
            h += angular_velocity;
            if (Math.abs(v) >= 8.0) {
                acceleration = 0.0;
                double d = v = v > 0.0 ? 8.0 : -8.0;
            }
            if (acceleration != 0.0) {
                if (Math.abs(v) <= 1.0) {
                    prev_v = v;
                    v = 0.0;
                    acceleration = 0.0;
                } else {
                    prev_v = v;
                    v += acceleration;
                }
            }
            x += v * Math.sin(h);
            y += v * Math.cos(h);
            if (x <= 0.0) {
                x = 0.0;
                clipped = true;
                break;
            }
            if (y <= 0.0) {
                y = 0.0;
                clipped = true;
                break;
            }
            if (x >= battle_field_width) {
                x = battle_field_width;
                clipped = true;
                break;
            }
            if (y >= battle_field_height) {
                y = battle_field_height;
                clipped = true;
                break;
            }
            ++t;
        }
        if (!clipped) {
            double dt = time2 - Math.floor(time2);
            double max_angular_velocity = 0.17453292519943295 - 0.013089969389957472 * Math.abs(v);
            if (Math.abs(angular_velocity) > max_angular_velocity) {
                angular_velocity = angular_velocity > 0.0 ? max_angular_velocity : -max_angular_velocity;
            }
            h += angular_velocity * dt;
            if (Math.abs(v) >= 8.0) {
                acceleration = 0.0;
                double d = v = v > 0.0 ? 8.0 : -8.0;
            }
            if (acceleration != 0.0) {
                if (Math.abs(v) <= 1.0) {
                    prev_v = v;
                    v = 0.0;
                    acceleration = 0.0;
                } else {
                    prev_v = v;
                    v += acceleration * dt;
                }
            }
            x += v * Math.sin(h) * dt;
            y += v * Math.cos(h) * dt;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (x > battle_field_width) {
                x = battle_field_width;
            }
            if (y > battle_field_height) {
                y = battle_field_height;
            }
        }
        out[0] = 1.0;
        out[1] = x;
        out[2] = y;
        out[3] = Utils.normalizePhi(h);
        out[4] = v;
    }

    public static void interpolate3(PrintStream debug, double[] out, IObject.ITrackedObjectTimeSeries series, double time1, double time2, double battle_field_width, double battle_field_height) {
        if (series.size() < 2) {
            double[] out_xy = new double[2];
            IObject.IUpdatedObject point = series.getPoint(0);
            Utils.interpolate(out_xy, point.getX(), point.getY(), point.getHeadingRadians(), point.getVelocity(), time2 - (double)point.getUpdateTime());
            out[0] = 1.0;
            out[1] = out_xy[0];
            out[2] = out_xy[1];
            out[3] = point.getHeadingRadians();
            out[4] = point.getVelocity();
        } else {
            Utils.interpolate2(debug, out, series, time1, time2, battle_field_width, battle_field_height);
            if (out[0] < 0.0) {
                double[] out_xy = new double[2];
                IObject.IUpdatedObject point = series.getPoint(0);
                Utils.interpolate(out_xy, point.getX(), point.getY(), point.getHeadingRadians(), point.getVelocity(), time2 - (double)point.getUpdateTime());
                out[0] = 1.0;
                out[1] = out_xy[0];
                out[2] = out_xy[1];
                out[3] = point.getHeadingRadians();
                out[4] = point.getVelocity();
            }
        }
    }

    public static double relativeHeading(double x1, double y1, double x2, double y2) {
        if (Math.abs(y2 - y1) < 1.0E-8) {
            return x2 >= x1 ? 1.5707963267948966 : 4.71238898038469;
        }
        double phi = Math.atan((x2 - x1) / (y2 - y1));
        if (phi > 0.0) {
            if (x2 < x1) {
                phi -= Math.PI;
            }
        } else if (x2 > x1) {
            phi += Math.PI;
        }
        return Utils.normalizePhi(phi);
    }

    public static double relativeHeading(double[] xy1, double x2, double y2) {
        return Utils.relativeHeading(xy1[0], xy1[1], x2, y2);
    }

    public static double relativeHeading(double x1, double y1, double[] xy2) {
        return Utils.relativeHeading(x1, y1, xy2[0], xy2[1]);
    }

    public static double relativeHeading(double[] xy1, double[] xy2) {
        return Utils.relativeHeading(xy1[0], xy1[1], xy2[0], xy2[1]);
    }

    public static double relativeDistance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double relativeDistance(double[] xy1, double x2, double y2) {
        double dx = xy1[0] - x2;
        double dy = xy1[1] - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double relativeDistance(double[] xy1, double[] xy2) {
        double dx = xy1[0] - xy2[0];
        double dy = xy1[1] - xy2[1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static void maxPhiGap(double[] out, double[] phis) {
        double gap;
        Arrays.sort(phis);
        double max = Double.MIN_VALUE;
        int i = 0;
        while (i < phis.length - 1) {
            gap = phis[i + 1] - phis[i];
            if (gap > max) {
                max = gap;
                out[0] = Utils.normalizePhi(0.5 * (phis[i] + phis[i + 1]) + Math.PI);
                out[1] = Math.PI * 2 - gap;
            }
            ++i;
        }
        gap = Math.PI * 2 - phis[phis.length - 1] + phis[0];
        if (gap > max) {
            max = gap;
            out[0] = Utils.normalizePhi(0.5 * (phis[phis.length - 1] + phis[0]));
            out[1] = Math.PI * 2 - gap;
        }
    }

    public static void runSeriesPredictor(PrintStream debug, double[] out, double xF, double yF, double tF, double U, IRobotPositionManager.ITrackedRobot enemy, double battle_field_width, double battle_field_height) {
        out[0] = -1.0;
        IObject.ITrackedObjectTimeSeries series = enemy.getTimeSeries();
        int series_size = series.size();
        switch (series_size) {
            case 0: {
                Utils.ASSERT(false, "[enemy: " + enemy + "]: malformed series: " + series);
                break;
            }
            case 1: {
                Utils.runLPredictor2(debug, out, xF, yF, U, enemy.getX(), enemy.getY(), enemy.getVelocity(), enemy.getHeadingRadians());
                break;
            }
            default: {
                double denominator;
                double sin_hit_phi;
                double r = Utils.relativeDistance(xF, yF, enemy.getX(), enemy.getY());
                double bullet_time_min = tF + 0.9 * r / (U + 8.0);
                double max_r = Utils.relativeDistance(xF, yF, 0.0, 0.0);
                r = Utils.relativeDistance(xF, yF, battle_field_width, battle_field_height);
                if (r > max_r) {
                    max_r = r;
                }
                if ((r = Utils.relativeDistance(xF, yF, 0.0, battle_field_height)) > max_r) {
                    max_r = r;
                }
                if ((r = Utils.relativeDistance(xF, yF, battle_field_width, 0.0)) > max_r) {
                    max_r = r;
                }
                double bullet_time_max = tF + 1.05 * max_r / U;
                double[] interpolate = new double[out.length];
                double U2 = U * U;
                double time1 = series.getEarliestPoint().getUpdateTime();
                double eq_min = Double.MAX_VALUE;
                double t_min = Double.NaN;
                double t_A = Math.floor(bullet_time_min);
                Utils.interpolate3(debug, interpolate, series, time1, t_A, battle_field_width, battle_field_height);
                double f_A = Utils.F(interpolate, xF, yF, tF, U2, t_A);
                double t_B = Double.NaN;
                double f_B = Double.NaN;
                boolean B_found = false;
                double t = t_A;
                while (t <= bullet_time_max) {
                    Utils.interpolate3(debug, interpolate, series, time1, t, battle_field_width, battle_field_height);
                    double f_t = Utils.F(interpolate, xF, yF, tF, U2, t);
                    if (f_A * f_t < 0.0) {
                        t_B = t;
                        f_B = f_t;
                        B_found = true;
                        break;
                    }
                    t += 3.0;
                }
                if (!B_found) {
                    return;
                }
                double t2 = (t_A * f_B - t_B * f_A) / (f_B - f_A);
                Utils.interpolate3(debug, interpolate, series, time1, t2, battle_field_width, battle_field_height);
                double f_t = Utils.F(interpolate, xF, yF, tF, U2, t2);
                int iteration = 0;
                while (iteration < 50 && (f_t > 1.0 || f_t < -1.0)) {
                    if (f_A * f_t < 0.0) {
                        t_B = t2;
                        f_B = f_t;
                    } else if (f_B * f_t < 0.0) {
                        t_A = t2;
                        f_A = f_t;
                    } else {
                        Utils.ASSERT(false, "runSeriesPredictor failed: t_A = " + t_A + ", t_B = " + t_B);
                    }
                    t2 = (t_A * f_B - t_B * f_A) / (f_B - f_A);
                    Utils.interpolate3(debug, interpolate, series, time1, t2, battle_field_width, battle_field_height);
                    f_t = Utils.F(interpolate, xF, yF, tF, U2, t2);
                    ++iteration;
                }
                if (iteration == 100) {
                    Utils.ASSERT(false, "runSeriesPredictor failed after 50 iterations: t_A = " + t_A + ", t_B = " + t_B + ", f_t = " + f_t);
                }
                if ((sin_hit_phi = (interpolate[1] - xF) / (denominator = U * (t2 - tF))) < -1.0) {
                    sin_hit_phi = -1.0;
                } else if (sin_hit_phi > 1.0) {
                    sin_hit_phi = 1.0;
                }
                double cos_hit_phi = (interpolate[2] - yF) / denominator;
                if (cos_hit_phi < -1.0) {
                    cos_hit_phi = -1.0;
                } else if (cos_hit_phi > 1.0) {
                    cos_hit_phi = 1.0;
                }
                double hit_phi = Math.asin(sin_hit_phi);
                if (cos_hit_phi < 0.0) {
                    hit_phi = Math.PI - hit_phi;
                }
                hit_phi = Utils.normalizePhi(hit_phi);
                out[0] = 1.0;
                out[1] = hit_phi;
                out[2] = t2 - tF;
                out[3] = interpolate[1];
                out[4] = interpolate[2];
                out[5] = interpolate[4];
            }
        }
    }

    private static double F(double[] interpolate, double xF, double yF, double tF, double U2, double t) {
        double dx = interpolate[1] - xF;
        double dy = interpolate[2] - yF;
        double dt = t - tF;
        return dx * dx + dy * dy - U2 * dt * dt;
    }

    public static void runLPredictor2(PrintStream debug, double[] out, double xF, double yF, double U, double xE, double yE, double vE, double phiE) {
        out[0] = -1.0;
        double dx = xE - xF;
        double dy = yE - yF;
        double sin_phiE = Math.sin(phiE);
        double cos_phiE = Math.cos(phiE);
        double r2 = dx * dx + dy * dy;
        if (vE < U) {
            double vE2 = vE * vE;
            double U2 = U * U;
            double term1 = dx * sin_phiE + dy * cos_phiE;
            double term2 = vE2 - U2;
            double D = (vE2 * term1 * term1 / term2 - r2) / term2;
            double hit_time = -vE * term1 / term2 + Math.sqrt(D);
            double sin_hit_phi = (vE * sin_phiE + dx / hit_time) / U;
            double hit_phi = Math.asin(sin_hit_phi);
            double cos_hit_phi = (vE * cos_phiE + dy / hit_time) / U;
            if (cos_hit_phi < 0.0) {
                hit_phi = Math.PI - hit_phi;
            }
            hit_phi = Utils.normalizePhi(hit_phi);
            out[0] = 1.0;
            out[1] = hit_phi;
            out[2] = hit_time;
            out[3] = xE + vE * sin_phiE * hit_time;
            out[4] = yE + vE * cos_phiE * hit_time;
        }
    }

    public static double bulletPowerToVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double bulletPowerToDamage(double power) {
        return power > 1.0 ? 6.0 * power - 2.0 : 4.0 * power;
    }

    public static double bulletPowerToGunHeat(double power) {
        return 1.0 + power / 5.0;
    }

    public static int bulletPowerToGunCoolTime(double power, double coolingRate) {
        double gunHeat = Utils.bulletPowerToGunHeat(power);
        return (int)Math.ceil(gunHeat / coolingRate);
    }

    public static double damageToBulletPower(double damage) {
        double power = damage / 4.0;
        if (power < 0.1) {
            return 0.1;
        }
        if (power > 1.0) {
            power = (damage + 2.0) / 6.0;
            if (power > 3.0) {
                return -1.0;
            }
            return power;
        }
        return power;
    }

    public static boolean onTheBoundary(double x, double y, double margin, double fieldWidth, double fieldHeight) {
        return x < margin || x > fieldWidth - margin || y < margin || y > fieldHeight - margin;
    }

    public static boolean onTheBoundary(double[] xy, double margin, double fieldWidth, double fieldHeight) {
        return xy[0] < margin || xy[0] > fieldWidth - margin || xy[1] < margin || xy[1] > fieldHeight - margin;
    }

    public static double boundaryGap(int boundary, double x, double y, double fieldWidth, double fieldHeight) {
        switch (boundary) {
            default: {
                return y;
            }
            case 1: {
                return x;
            }
            case 2: {
                return fieldHeight - y;
            }
            case 4: 
        }
        return fieldWidth - x;
    }

    public static int closestBoundary(double x, double y, double fieldWidth, double fieldHeight) {
        double minGap = Double.MAX_VALUE;
        int result = 0;
        int b = 0;
        while (b < 4) {
            double gap = Utils.boundaryGap(b, x, y, fieldWidth, fieldHeight);
            if (gap < minGap) {
                minGap = gap;
                result = b;
            }
            ++b;
        }
        return result;
    }

    public static double cornerDistance(int corner, double x, double y, double fieldWidth, double fieldHeight) {
        switch (corner) {
            default: {
                return x * x + y * y;
            }
            case 1: {
                return x * x + (fieldHeight - y) * (fieldHeight - y);
            }
            case 2: {
                return (fieldWidth - x) * (fieldWidth - x) + (fieldHeight - y) * (fieldHeight - y);
            }
            case 4: 
        }
        return (fieldWidth - x) * (fieldWidth - x) + y * y;
    }

    public static int closestCorner(double x, double y, double fieldWidth, double fieldHeight) {
        double minGap = Double.MAX_VALUE;
        int result = 0;
        int c = 0;
        while (c < 4) {
            double gap = Utils.cornerDistance(c, x, y, fieldWidth, fieldHeight);
            if (gap < minGap) {
                minGap = gap;
                result = c;
            }
            ++c;
        }
        return result;
    }

    public static boolean inTheCorner(double x, double y, double margin, double fieldWidth, double fieldHeight) {
        if (x < margin) {
            return y < margin || y > fieldHeight - margin;
        }
        if (x > fieldWidth - margin) {
            return y < margin || y > fieldHeight - margin;
        }
        return false;
    }

    public static boolean inTheCorner(double[] xy, double margin, double fieldWidth, double fieldHeight) {
        if (xy[0] < margin) {
            return xy[1] < margin || xy[1] > fieldHeight - margin;
        }
        if (xy[0] > fieldWidth - margin) {
            return xy[1] < margin || xy[1] > fieldHeight - margin;
        }
        return false;
    }

    public static synchronized String getGID(String prefix) {
        return prefix + s_ID++;
    }

    public static ClassLoader getResourceLoader() {
        ClassLoader result = (class$morbid$Utils == null ? (class$morbid$Utils = Utils.class$("morbid.Utils")) : class$morbid$Utils).getClassLoader();
        if (result == null) {
            result = ClassLoader.getSystemClassLoader();
        }
        return result;
    }

    public static InputStream getResourceAsStream(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("null input: resourceName");
        }
        ClassLoader loader = Utils.getResourceLoader();
        return loader.getResourceAsStream(resourceName);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getResourceAsProperties(String resourceName) {
        block11: {
            if (resourceName == null) {
                throw new IllegalArgumentException("null input: resourceName");
            }
            in = null;
            try {
                try {
                    in = Utils.getResourceAsStream(resourceName);
                    if (in == null) break block11;
                    result = new Properties();
                    result.load(in);
                    var3_4 = result;
                    var5_6 = null;
                    if (in == null) return var3_4;
                }
                catch (IOException e) {
                    var3_5 = null;
                    var5_8 = null;
                    if (in == null) return var3_5;
                    try {
                        in.close();
                        return var3_5;
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    return var3_5;
                }
            }
            catch (Throwable var4_14) {
                var5_9 = null;
                if (in == null) throw var4_14;
                ** try [egrp 2[TRYBLOCK] [2 : 73->80)] { 
lbl31:
                // 1 sources

                in.close();
                throw var4_14;
lbl33:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
                throw var4_14;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 73->80)] { 
lbl38:
            // 1 sources

            in.close();
            return var3_4;
lbl40:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
            return var3_4;
        }
        var5_7 = null;
        if (in == null) return null;
        try {}
        catch (Throwable ignore) {}
        in.close();
        return null;
        return null;
    }

    public static String printDouble(double d) {
        return Utils.printDouble(d, 1);
    }

    public static String printDouble(double d, int digits) {
        double abs_d = d >= 0.0 ? d : -d;
        s_doubleFormatter.setLength(0);
        if (abs_d > 1.0E10) {
            return d > 0.0 ? "+inf" : "-inf";
        }
        if (abs_d >= 1.0) {
            long ld = (long)d;
            if (d < 0.0) {
                s_doubleFormatter.append('-');
            }
            Utils.appendLong(s_doubleFormatter, ld >= 0L ? ld : -ld);
            s_doubleFormatter.append('.');
            if (digits > 0) {
                int fraction = (int)((d - (double)ld) * DIGITS_TO_MULTIPLIER[digits]);
                if (fraction < 0) {
                    fraction = -fraction;
                }
                Utils.appendInt(s_doubleFormatter, fraction);
            }
        } else {
            s_doubleFormatter.append(d >= 0.0 ? "0." : "-0.");
            if (digits > 0) {
                int fraction = (int)(d * DIGITS_TO_MULTIPLIER[digits]);
                if (fraction < 0) {
                    fraction = -fraction;
                }
                Utils.appendInt(s_doubleFormatter, fraction);
            }
        }
        return s_doubleFormatter.toString();
    }

    public static String printPhi(double phi) {
        return Utils.printDouble(Utils.radiansToDegrees(phi));
    }

    public static String printPercentage(int enumerator, int denominator) {
        StringBuffer s = new StringBuffer(0);
        if (denominator > 0) {
            s.append(Utils.printDouble(100.0 * (double)enumerator / (double)denominator));
            s.append("% [");
            s.append(enumerator);
            s.append('/');
            s.append(denominator);
            s.append(']');
        } else {
            s.append("0% [");
            s.append(enumerator);
            s.append('/');
            s.append(denominator);
            s.append(']');
        }
        return s.toString();
    }

    public static String printPercentage(double enumerator, double denominator) {
        StringBuffer s = new StringBuffer(0);
        if (denominator > 0.0) {
            s.append(Utils.printDouble(100.0 * enumerator / denominator));
            s.append("% [");
            s.append(Utils.printDouble(enumerator));
            s.append('/');
            s.append(Utils.printDouble(denominator));
            s.append(']');
        } else {
            s.append("0% [");
            s.append(Utils.printDouble(enumerator));
            s.append('/');
            s.append(Utils.printDouble(denominator));
            s.append(']');
        }
        return s.toString();
    }

    public static void ASSERT(boolean condition, String msg) {
    }

    private Utils() {
    }

    private static void appendLong(StringBuffer s, long nonnegative_l) {
        if (nonnegative_l == 0L) {
            s.append('0');
        } else {
            int digit = 0;
            long magnitude = 1L;
            long l_digit = nonnegative_l;
            while (nonnegative_l >= magnitude) {
                Utils.s_formatter[digit++] = DIGIT_TO_CHAR[(int)(l_digit % 10L)];
                magnitude *= 10L;
                l_digit /= 10L;
            }
            int d = digit;
            while (--d >= 0) {
                s.append(s_formatter[d]);
            }
        }
    }

    private static void appendInt(StringBuffer s, int nonnegative_i) {
        if (nonnegative_i == 0) {
            s.append('0');
        } else {
            int digit = 0;
            int magnitude = 1;
            int i_digit = nonnegative_i;
            while (nonnegative_i >= magnitude) {
                Utils.s_formatter[digit++] = DIGIT_TO_CHAR[i_digit % 10];
                magnitude *= 10;
                i_digit /= 10;
            }
            int d = digit;
            while (--d >= 0) {
                s.append(s_formatter[d]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        DIGITS_TO_MULTIPLIER = new double[]{Double.NaN, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
        s_doubleFormatter = new StringBuffer(20);
        s_formatter = new char[32];
    }
}

