/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Utilities;

import wcsv.Engineer.Utilities.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Map {
    public Node head;
    public double spreadFactor;
    public int size;
    public int featureSize;
    public int lastAddedIndex;
    private int closestIndex;

    public Node add(double[] v) {
        Node closest = this.closestNode(v);
        Node toAdd = new Node();
        if (closest == null) {
            ++this.size;
            this.head = toAdd;
            return toAdd;
        }
        if (this.distance(closest.featureVector, v) > this.spreadFactor) {
            double prevDist;
            ++this.size;
            double nextDist = closest.next != null ? this.distance(v, closest.next.featureVector) : Double.MAX_VALUE;
            double d = prevDist = closest.prev != null ? this.distance(v, closest.prev.featureVector) : Double.MAX_VALUE;
            if (nextDist < prevDist) {
                toAdd.prev = closest;
                toAdd.next = closest.next;
                if (closest.next != null) {
                    closest.next.prev = toAdd;
                }
                closest.next = toAdd;
                this.lastAddedIndex = this.closestIndex + 1;
            } else {
                toAdd.prev = closest.prev;
                toAdd.next = closest;
                if (closest.prev == null) {
                    this.head = toAdd;
                } else {
                    closest.prev.next = toAdd;
                }
                closest.prev = toAdd;
                this.lastAddedIndex = this.closestIndex;
            }
            return toAdd;
        }
        this.lastAddedIndex = this.closestIndex;
        return closest;
    }

    public double[] get(double[] v) {
        Node closest = this.closestNode(v);
        return closest != null ? closest.buffer : null;
    }

    public Node closestNode(double[] vector) {
        Node temp = this.head;
        Node closest = null;
        double closestDist = Double.MAX_VALUE;
        this.closestIndex = 0;
        int index = 0;
        while (temp != null) {
            double currDist = this.distance(temp.featureVector, vector);
            if (currDist < closestDist) {
                closestDist = currDist;
                closest = temp;
                this.closestIndex = index;
            }
            temp = temp.next;
            ++index;
        }
        return closest;
    }

    public double distance(double[] v1, double[] v2) {
        double dist = 0.0;
        int i = 0;
        while (i < v1.length) {
            dist += Utilities.square(v1[i] - v2[i]);
            ++i;
        }
        return Math.sqrt(dist);
    }

    public void combine(double[] input, Node vector) {
        int i = 0;
        while (i < input.length) {
            vector.featureVector[i] = (vector.featureVector[i] * (double)vector.uses + input[i]) / ((double)vector.uses + 1.0);
            ++i;
        }
    }

    public void combine(double[] inputVector, Node receive, double weight, double addFactor, int bin) {
        int n = bin;
        receive.buffer[n] = receive.buffer[n] + addFactor * weight;
        int i = 0;
        while (i < inputVector.length) {
            receive.featureVector[i] = (receive.featureVector[i] * (double)receive.uses + inputVector[i] * weight) / ((double)receive.uses + weight);
            ++i;
        }
    }

    public void combineRolling(double[] inputVector, Node receive, double weight, double bin) {
        int i = 0;
        while (i < receive.buffer.length) {
            receive.buffer[i] = Utilities.rollingAvg(receive.buffer[i], 1.0 / (Math.abs(bin - (double)i) + 1.0), receive.uses, 1.0, weight);
            ++i;
        }
        i = 0;
        while (i < inputVector.length) {
            receive.featureVector[i] = (receive.featureVector[i] * (double)receive.uses + inputVector[i] * weight) / ((double)receive.uses + weight);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.head = null;
    }

    public Map(int fSize, double spread) {
        this.this();
        this.spreadFactor = spread;
        this.size = 0;
        this.featureSize = fSize;
        this.lastAddedIndex = 0;
        this.closestIndex = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Node {
        public int uses;
        public Node next;
        public Node prev;
        double[] featureVector;
        public double[] buffer;

        private final /* synthetic */ void this() {
            this.uses = 0;
            this.featureVector = new double[Map.this.featureSize];
            this.buffer = new double[41];
        }

        public Node() {
            this.this();
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = 0.5;
                ++i;
            }
        }
    }
}

