/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.Util;

class BulletData {
    protected String name;
    protected double originX;
    protected double originY;
    protected double power;
    protected long time;
    protected double robotX;
    protected double robotY;
    protected double robotHeading;
    protected int robotVelocity;
    protected int robotAcceleration;
    protected double distance;
    protected double angle;
    protected double maxGuessFactorAngle;
    protected boolean active;

    public BulletData(String string, double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, long l) {
        this.name = string;
        this.originX = d;
        this.originY = d2;
        this.power = d3;
        this.robotX = d4;
        this.robotY = d5;
        this.robotHeading = d6;
        this.robotVelocity = n;
        this.robotAcceleration = n2;
        this.time = l;
        this.distance = Util.distance(this.originX, this.originY, this.robotX, this.robotY);
        this.angle = Util.direction(this.originX, this.originY, this.robotX, this.robotY);
        this.maxGuessFactorAngle = Math.toDegrees(Math.asin(8.0 / (20.0 - 3.0 * this.power)));
        double d7 = this.robotVelocity < 0 ? this.robotHeading + 180.0 : this.robotHeading;
        if (Math.abs(Util.relativeAngle(this.angle + 90.0, d7)) > 90.0) {
            this.maxGuessFactorAngle *= -1.0;
        }
        this.active = true;
    }

    public final String getName() {
        return this.name;
    }

    public final double getOriginX() {
        return this.originX;
    }

    public final double getOriginY() {
        return this.originY;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getPower() {
        return this.power;
    }

    public final double getSpeed() {
        return 20.0 - 3.0 * this.power;
    }

    public final double getRobotX() {
        return this.robotX;
    }

    public final double getRobotY() {
        return this.robotY;
    }

    public final double getRobotHeading() {
        return this.robotHeading;
    }

    public final int getRobotVelocity() {
        return this.robotVelocity;
    }

    public final int getRobotAcceleration() {
        return this.robotAcceleration;
    }

    public final long getTime() {
        return this.time;
    }

    public final double getGuessFactor(double d) {
        return Util.confine(Util.relativeAngle(this.angle, d) / this.maxGuessFactorAngle, -1.0, 1.0);
    }

    public final double getHeading(double d) {
        return this.angle + d * this.maxGuessFactorAngle;
    }

    public final double getGuessFactor(double d, double d2) {
        return this.getGuessFactor(Util.direction(this.originX, this.originY, d, d2));
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void deactivate() {
        this.active = false;
    }
}

