/*
 * Decompiled with CFR 0.152.
 */
package rdm.gunners;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.precepts.GunPrecept;
import rdm.state.entities.EnemyState;
import rdm.state.entities.InstantState;
import rdm.state.entities.State;
import robocode.Bullet;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001f\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lrdm/gunners/LinearClassifierGunner;", "Lrdm/gunners/Gunner;", "()V", "threshold", "", "calculateProbability", "state", "Lrdm/state/entities/State;", "dispose", "", "handle", "Lrdm/precepts/GunPrecept;", "saveShot", "bullet", "Lrobocode/Bullet;", "precept", "saveShotResult", "hit", "", "(Lrobocode/Bullet;Ljava/lang/Boolean;)V", "shouldFire", "sigma", "value", "Weights", "Commons"})
public final class LinearClassifierGunner
implements Gunner {
    private final double threshold = 0.3;
    private static final double BEARING = -0.00336388;
    private static final double DISTANCE = -5.9512E-4;
    private static final double DIRECTION = -0.00169745;
    private static final double VELOCITY_PROJECTION = -0.21801968;
    private static final double BIAS = 0.01398674;
    @Deprecated
    public static final Weights Weights = new Weights(null);

    @Override
    @NotNull
    public GunPrecept handle(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        return new GunPrecept(this.shouldFire(state), 3.0, 0.0);
    }

    @Override
    public void saveShot(@NotNull Bullet bullet, @NotNull State state, @NotNull GunPrecept precept) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(precept, "precept");
    }

    @Override
    public void saveShotResult(@NotNull Bullet bullet, @Nullable Boolean hit) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
    }

    @Override
    public void dispose() {
    }

    private final boolean shouldFire(State state) {
        return this.calculateProbability(state) < this.threshold;
    }

    public final double calculateProbability(@NotNull State state) {
        InstantState instant;
        Intrinsics.checkParameterIsNotNull(state, "state");
        State state2 = state;
        InstantState instantState = instant = state2.component1();
        EnemyState enemy = instantState.component3();
        boolean headingDirection = instant.getEnemyHeadingFromGun() >= 0.0;
        boolean velocityDirection = instant.getEnemy().getVelocity() >= 0.0;
        double direction = !(headingDirection ^ velocityDirection) ? 1.0 : 0.0;
        double velocityProjection = Math.abs(enemy.getVelocity()) * Math.sin(Math.toRadians(Math.abs(instant.getEnemyHeadingFromGun())));
        double sum = -0.00336388 * instant.getEnemyBearingFromGun() + -5.9512E-4 * enemy.getDistance() + -0.00169745 * direction + -0.21801968 * velocityProjection + 0.01398674;
        double probability = this.sigma(sum);
        return probability;
    }

    private final double sigma(double value) {
        return 1.0 / (1.0 + Math.exp(-value));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lrdm/gunners/LinearClassifierGunner$Weights;", "", "()V", "BEARING", "", "BIAS", "DIRECTION", "DISTANCE", "VELOCITY_PROJECTION", "Commons"})
    private static final class Weights {
        private Weights() {
        }

        public /* synthetic */ Weights(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

